/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBackupNode;
import com.netscape.admin.dirserv.config.ConfigDataNode;
import com.netscape.admin.dirserv.config.ConfigLogNode;
import com.netscape.admin.dirserv.config.ConfigPerformanceNode;
import com.netscape.admin.dirserv.config.ConfigPluginRootNode;
import com.netscape.admin.dirserv.config.ConfigRootPanel;
import com.netscape.admin.dirserv.config.ConfigSchemaNode;
import com.netscape.admin.dirserv.config.ConfigTabbedBasePanel;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.management.client.IMenuItem;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ConfigRootNode
extends DefaultMutableTreeNode
implements IConfigNode {
    protected DSFramework _framework;
    protected String _name;
    protected Icon _icon;
    protected ConfigTabbedBasePanel _customPanel;
    protected JTree _tree;
    protected boolean _refreshPanelOnRequest;
    private final IMenuItem[] _objectMenuItems = new IMenuItem[0];
    private final IMenuItem[] _contextMenuItems = new IMenuItem[0];
    private static final String SERVER_ICON_NAME = "directory.gif";

    public ConfigRootNode(DSFramework dSFramework) {
        this._framework = dSFramework;
        this._name = this._framework.getServerObject().getServerInfo().getHost() + ":" + this._framework.getServerObject().getServerInfo().getPort();
        this._icon = DSUtil.getPackageImage(SERVER_ICON_NAME);
    }

    public void setTree(JTree jTree) {
        this._tree = jTree;
    }

    public JTree getTree() {
        return this._tree;
    }

    public void addChildren() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
        defaultTreeModel.insertNodeInto(new ConfigDataNode(this._framework, this._tree), this, 0);
        defaultTreeModel.insertNodeInto(new ConfigPerformanceNode(this._framework), this, 1);
        defaultTreeModel.insertNodeInto(new ConfigSchemaNode(this._framework), this, 2);
        defaultTreeModel.insertNodeInto(new ConfigBackupNode(this._framework), this, 3);
        defaultTreeModel.insertNodeInto(new ConfigLogNode(this._framework), this, 4);
        defaultTreeModel.insertNodeInto(new ConfigPluginRootNode(this._framework, defaultTreeModel), this, 5);
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public Component getCustomPanel() {
        if (this._customPanel == null) {
            this._customPanel = this.createCustomPanel();
        } else if (this._refreshPanelOnRequest) {
            this._customPanel.refreshPanel();
        }
        this._refreshPanelOnRequest = false;
        return this._customPanel;
    }

    public boolean isRefreshNeededOnExpansion() {
        return false;
    }

    public void refreshNode() {
        this._refreshPanelOnRequest = true;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            ((IConfigNode)((Object)treeNode)).refreshNode();
        }
    }

    public void menuAction(String string) {
    }

    public IMenuItem[] getObjectMenuItems() {
        return this._objectMenuItems;
    }

    public IMenuItem[] getContextMenuItems() {
        return this._contextMenuItems;
    }

    private ConfigRootPanel createCustomPanel() {
        return new ConfigRootPanel(this._framework);
    }
}

