/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.EntryEditor;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.Plugin;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;

public class ConfigPluginPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private JPanel _innerPanel;
    private JPanel _contentPanel;
    private JPanel _argumentsPanel;
    private JPanel _buttonPanel;
    private JCheckBox _cbEnable;
    private JButton _bAddArgument;
    private JButton _bDeleteArgument;
    private JButton _bHelp;
    private JButton _bSave;
    private JButton _bReset;
    private JButton _bAdvanced;
    private JLabel _lId;
    private JLabel _lDescription;
    private JLabel _lVersion;
    private JLabel _lVendor;
    private JLabel _lType;
    private JLabel _lSignatureState;
    private JLabel _lInitFunction;
    private JTextField _tfInitFunction;
    private JLabel _lPath;
    private JTextField _tfPath;
    private ArrayList _listArgLabels;
    private ArrayList _listArgTextFields;
    private boolean _isEnableDirty;
    private boolean[] _pathValidDirty = new boolean[]{true, false};
    private boolean[] _initFunctionValidDirty = new boolean[]{true, false};
    private boolean _isArgNumberDirty;
    private ArrayList _listArgValidDirty;
    private Plugin _savePlugin;
    private boolean _ignoreDocumentEvents;
    private ResourceSet _resource = DSConfigPage._resource;
    private final JLabel NO_ARGUMENTS_LABEL = UIFactory.makeJLabel("pluginpanel", "lnoarguments", this._resource);
    private static final String _helpToken = "configuration-plugins-help";

    public ConfigPluginPanel(DSFramework dSFramework, Plugin plugin) {
        super(new BorderLayout(0, 0));
        this._framework = dSFramework;
        this._savePlugin = plugin;
        this.createContentPanel();
        this.createButtonPanel();
        this.initComponentsFromPlugin();
        this._innerPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this._innerPanel);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this._buttonPanel, "South");
        this.showComponent(this._contentPanel, false);
    }

    public void refreshPanel() {
        this.initComponentsFromPlugin();
        this.repaintNow();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bSave) {
            this.actionSave();
        } else if (object == this._bReset) {
            this.actionReset();
        } else if (object == this._bAdvanced) {
            this.actionAdvanced();
        } else if (object == this._bHelp) {
            this.actionHelp();
        } else if (object == this._cbEnable) {
            this.actionEnable();
        } else if (object == this._bAddArgument) {
            this.actionAddArgument();
        } else if (object == this._bDeleteArgument) {
            this.actionDeleteArgument();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._ignoreDocumentEvents) {
            if (documentEvent.getDocument() == this._tfInitFunction.getDocument()) {
                this.checkField(this._lInitFunction, this._tfInitFunction.getText(), this._savePlugin.initFunction, this._initFunctionValidDirty);
                this.fireValidDirtyChange();
            } else if (documentEvent.getDocument() == this._tfPath.getDocument()) {
                this.checkField(this._lPath, this._tfPath.getText(), this._savePlugin.path, this._pathValidDirty);
                this.fireValidDirtyChange();
            } else {
                boolean bl = false;
                ListIterator listIterator = ((AbstractList)this._listArgTextFields).listIterator();
                while (listIterator.hasNext() && !bl) {
                    JTextField jTextField = (JTextField)listIterator.next();
                    if (documentEvent.getDocument() != jTextField.getDocument()) continue;
                    bl = true;
                    this.checkArgumentField(jTextField);
                }
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this.NO_ARGUMENTS_LABEL.setFont(this.NO_ARGUMENTS_LABEL.getFont().deriveFont(2));
        this._listArgLabels = new ArrayList();
        this._listArgTextFields = new ArrayList();
        this._listArgValidDirty = new ArrayList();
        this._cbEnable = UIFactory.makeJCheckBox(this, "pluginpanel", "cbenable", false, this._resource);
        JLabel jLabel = UIFactory.makeJLabel("pluginpanel", "lid", this._resource);
        this._lId = new JLabel();
        jLabel.setLabelFor(this._lId);
        Component[] componentArray = new Component[]{jLabel, this._lId};
        JLabel jLabel2 = UIFactory.makeJLabel("pluginpanel", "ldescription", this._resource);
        this._lDescription = new JLabel();
        jLabel2.setLabelFor(this._lDescription);
        Component[] componentArray2 = new Component[]{jLabel2, this._lDescription};
        JLabel jLabel3 = UIFactory.makeJLabel("pluginpanel", "lversion", this._resource);
        this._lVersion = new JLabel();
        jLabel3.setLabelFor(this._lVersion);
        Component[] componentArray3 = new Component[]{jLabel3, this._lVersion};
        JLabel jLabel4 = UIFactory.makeJLabel("pluginpanel", "lvendor", this._resource);
        this._lVendor = new JLabel();
        jLabel4.setLabelFor(this._lVendor);
        Component[] componentArray4 = new Component[]{jLabel4, this._lVendor};
        JLabel jLabel5 = UIFactory.makeJLabel("pluginpanel", "ltype", this._resource);
        this._lType = new JLabel();
        jLabel5.setLabelFor(this._lType);
        Component[] componentArray5 = new Component[]{jLabel5, this._lType};
        JLabel jLabel6 = UIFactory.makeJLabel("pluginpanel", "lsignaturestate", this._resource);
        this._lSignatureState = new JLabel();
        jLabel6.setLabelFor(this._lSignatureState);
        Component[] componentArray6 = new Component[]{jLabel6, this._lSignatureState};
        this._lInitFunction = UIFactory.makeJLabel("pluginpanel", "linitfunction", this._resource);
        this._tfInitFunction = UIFactory.makeJTextField(this, "pluginpanel", "linitfunction", null, 10, this._resource);
        this._lInitFunction.setLabelFor(this._tfInitFunction);
        Component[] componentArray7 = new Component[]{this._lInitFunction, this._tfInitFunction};
        this._lPath = UIFactory.makeJLabel("pluginpanel", "lpath", this._resource);
        this._tfPath = UIFactory.makeJTextField(this, "pluginpanel", "lpath", null, 10, this._resource);
        this._lPath.setLabelFor(this._tfPath);
        Component[] componentArray8 = new Component[]{this._lPath, this._tfPath};
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._bAddArgument = UIFactory.makeJButton(this, "pluginpanel", "baddargument", this._resource);
        this._bDeleteArgument = UIFactory.makeJButton(this, "pluginpanel", "bdeleteargument", this._resource);
        this._argumentsPanel = new JPanel(new GridBagLayout());
        int n = UIFactory.getComponentSpace() - 4;
        this.addLine(jPanel, componentArray, false, 0, UIFactory.getComponentSpace());
        this.addLine(jPanel, componentArray2, false, n, UIFactory.getComponentSpace());
        this.addLine(jPanel, componentArray3, false, 0, UIFactory.getComponentSpace());
        this.addLine(jPanel, componentArray4, false, 0, UIFactory.getComponentSpace());
        this.addLine(jPanel, componentArray6, false, 0, UIFactory.getComponentSpace());
        this.addLine(jPanel, componentArray4, false, 0, UIFactory.getComponentSpace());
        this.addLine(jPanel, componentArray7, true, 0, UIFactory.getComponentSpace());
        this.addLine(jPanel, componentArray8, true, 0, UIFactory.getComponentSpace());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._bAddArgument, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        jPanel2.add((Component)this._bDeleteArgument, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this._argumentsPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel3.add(Box.createVerticalGlue(), gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        ConfigBasePanel.addComponentBorder(jPanel4, this._cbEnable);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.left = n;
        gridBagConstraints.insets.right = n;
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel4.add((Component)new JSeparator(0), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = -1;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        this._contentPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void addLine(Container container, Component[] componentArray, boolean bl, int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, n, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = componentArray.length;
        container.add(componentArray[0], gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        int n3 = 1;
        while (n3 < componentArray.length - 1) {
            --gridBagConstraints.gridwidth;
            container.add(componentArray[n3], gridBagConstraints);
            ++n3;
        }
        gridBagConstraints.insets.right = n;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = bl ? 1.0 : 0.0;
        gridBagConstraints.fill = bl ? 2 : 0;
        container.add(componentArray[componentArray.length - 1], gridBagConstraints);
    }

    private void createButtonPanel() {
        this._bAdvanced = UIFactory.makeJButton(this, "pluginpanel", "badvanced", this._resource);
        this._bSave = UIFactory.makeJButton(this, "general", "apply", this._resource);
        this._bSave.setEnabled(false);
        this._bReset = UIFactory.makeJButton(this, "general", "reset", this._resource);
        this._bReset.setEnabled(false);
        this._bHelp = UIFactory.makeJButton(this, "general", "help", this._resource);
        JButton[] jButtonArray = new JButton[]{this._bSave, this._bReset, this._bHelp};
        this._buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this._buttonPanel.add((Component)this._bAdvanced, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = -1;
        this._buttonPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        this._buttonPanel.add((Component)UIFactory.makeJButtonPanel(jButtonArray, true), gridBagConstraints);
    }

    private void initComponentsFromPlugin() {
        this._ignoreDocumentEvents = true;
        this._cbEnable.setSelected(this._savePlugin.isEnabled);
        this._lId.setText(this._savePlugin.id);
        this._lDescription.setText(this._savePlugin.description);
        this._lVersion.setText(this._savePlugin.version);
        this._lVendor.setText(this._savePlugin.vendor);
        this._lType.setText(this._savePlugin.type);
        this._lSignatureState.setText(this._savePlugin.signatureState);
        this._tfPath.setText(this._savePlugin.path);
        this._tfInitFunction.setText(this._savePlugin.initFunction);
        this.checkField(this._lInitFunction, this._tfInitFunction.getText(), this._savePlugin.initFunction, this._initFunctionValidDirty);
        this.checkField(this._lPath, this._tfPath.getText(), this._savePlugin.path, this._pathValidDirty);
        this._argumentsPanel.removeAll();
        this._listArgLabels.clear();
        this._listArgTextFields.clear();
        this._listArgValidDirty.clear();
        ListIterator listIterator = this._savePlugin.arguments.listIterator();
        boolean bl = false;
        String[] stringArray = new String[1];
        while (listIterator.hasNext()) {
            this.addField((String)listIterator.next());
        }
        this._isArgNumberDirty = false;
        if (this._savePlugin.arguments.size() == 0) {
            Component[] componentArray = new Component[]{this.NO_ARGUMENTS_LABEL, Box.createHorizontalGlue()};
            this.addLine(this._argumentsPanel, componentArray, true, 0, UIFactory.getComponentSpace());
        }
        this._bDeleteArgument.setEnabled(this._listArgTextFields.size() > 0);
        this.actionEnable();
        this.fireValidDirtyChange();
        this._ignoreDocumentEvents = false;
    }

    private void showComponent(JComponent jComponent, boolean bl) {
        if (!this._innerPanel.isAncestorOf(jComponent)) {
            this._innerPanel.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            if (bl) {
                gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 10;
                this._bAdvanced.setVisible(false);
                this._bReset.setVisible(false);
            } else {
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 11;
                this._bAdvanced.setVisible(true);
                this._bReset.setVisible(true);
            }
            this.repaintNow();
            this._innerPanel.add((Component)jComponent, gridBagConstraints);
        }
    }

    private void checkField(JLabel jLabel, String string, String string2, boolean[] blArray) {
        blArray[0] = !string.equals("");
        blArray[1] = !string.equals(string2);
        this.updateColoring(jLabel, blArray);
    }

    private void checkArgumentField(JTextField jTextField) {
        int n = this._listArgTextFields.indexOf(jTextField);
        if (n < this._savePlugin.arguments.size()) {
            this.checkField((JLabel)this._listArgLabels.get(n), jTextField.getText(), (String)this._savePlugin.arguments.get(n), (boolean[])this._listArgValidDirty.get(n));
            this.fireValidDirtyChange();
        } else {
            boolean[] blArray = (boolean[])this._listArgValidDirty.get(n);
            blArray[0] = !jTextField.getText().equals("");
            blArray[1] = true;
            this.updateColoring((JLabel)this._listArgLabels.get(n), blArray);
            this.fireValidDirtyChange();
        }
    }

    private void updateColoring(JLabel jLabel, boolean[] blArray) {
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2;
        if (this._cbEnable.isSelected()) {
            ListIterator listIterator = ((AbstractList)this._listArgValidDirty).listIterator();
            boolean bl3 = this._isArgNumberDirty;
            boolean bl4 = true;
            while (listIterator.hasNext() && (!bl3 || bl4)) {
                boolean[] blArray = (boolean[])listIterator.next();
                bl4 = bl4 && blArray[0];
                boolean bl5 = bl3 = bl3 || blArray[1];
            }
            bl2 = this._isEnableDirty || this._initFunctionValidDirty[1] || this._pathValidDirty[1] || bl3;
            bl = this._initFunctionValidDirty[0] && this._pathValidDirty[0] && bl4;
        } else {
            bl2 = this._isEnableDirty;
            bl = true;
        }
        if (!bl) {
            this._bReset.setEnabled(true);
            this._bSave.setEnabled(false);
        } else if (bl2) {
            this._bReset.setEnabled(true);
            this._bSave.setEnabled(true);
        } else {
            this._bReset.setEnabled(false);
            this._bSave.setEnabled(false);
        }
    }

    private void actionSave() {
        String string;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isEnableDirty) {
            string = this._cbEnable.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-pluginenabled", string));
        }
        if (this._cbEnable.isSelected()) {
            String string2;
            if (this._initFunctionValidDirty[1]) {
                lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-plugininitfunc", this._tfInitFunction.getText()));
            }
            if (this._pathValidDirty[1]) {
                lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-pluginpath", this._tfPath.getText()));
            }
            int n = 0;
            ListIterator listIterator = ((AbstractList)this._listArgValidDirty).listIterator();
            while (listIterator.hasNext()) {
                boolean[] blArray = (boolean[])listIterator.next();
                if (blArray[1]) {
                    string2 = "nsslapd-pluginarg" + String.valueOf(n);
                    String string3 = ((JTextField)this._listArgTextFields.get(n)).getText();
                    lDAPModificationSet.add(2, new LDAPAttribute(string2, string3));
                }
                ++n;
            }
            int n2 = n;
            while (n2 < this._savePlugin.arguments.size()) {
                string2 = "nsslapd-pluginarg" + String.valueOf(n);
                lDAPModificationSet.add(2, new LDAPAttribute(string2));
                ++n2;
            }
        }
        if (lDAPModificationSet.size() > 0) {
            string = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            try {
                string.modify(this._savePlugin.dn, lDAPModificationSet);
                this.actionReset();
                boolean bl = DSUtil.requiresRestart(this._savePlugin.dn, "nsslapd-pluginenabled");
                if (bl) {
                    DSUtil.showInformationDialog((Component)((Object)this._framework), "needsrestartserver", null, "pluginpanel", this._resource);
                }
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-modifying-title", "error-modifying-msg", stringArray, "pluginpanel", this._resource);
            }
        }
    }

    private void actionReset() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(this._savePlugin.dn);
            Plugin.updatePluginFromEntry(this._savePlugin, lDAPEntry);
            this.initComponentsFromPlugin();
            this.repaintNow();
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            String string = this._resource.getString("pluginpanel-error-reading", "label", stringArray);
            this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
        }
    }

    private void actionAdvanced() {
        LDAPConnection lDAPConnection;
        LDAPSchema lDAPSchema = DSUtil.getSchema(this._framework.getServerObject().getServerInfo());
        EntryEditor entryEditor = new EntryEditor(lDAPSchema, (JFrame)((Object)this._framework));
        boolean bl = entryEditor.editObject(this._savePlugin.dn, lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection(), false);
        if (bl) {
            this.actionReset();
            boolean bl2 = DSUtil.requiresRestart(this._savePlugin.dn, "nsslapd-pluginenabled");
            if (bl2) {
                DSUtil.showInformationDialog((Component)((Object)this._framework), "needsrestartserver", null, "pluginpanel", this._resource);
            }
        }
    }

    private void actionHelp() {
        DSUtil.help(_helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void actionEnable() {
        boolean bl = this._cbEnable.isSelected();
        this._isEnableDirty = bl != this._savePlugin.isEnabled;
        this._tfInitFunction.setEnabled(bl);
        this._tfPath.setEnabled(bl);
        this._bAddArgument.setEnabled(bl);
        this._bDeleteArgument.setEnabled(bl && this._listArgTextFields.size() > 0);
        ListIterator listIterator = ((AbstractList)this._listArgTextFields).listIterator();
        while (listIterator.hasNext()) {
            JTextField jTextField = (JTextField)listIterator.next();
            jTextField.setEnabled(bl);
        }
        this.fireValidDirtyChange();
    }

    private void actionAddArgument() {
        if (this._listArgTextFields.size() == 0) {
            this._argumentsPanel.removeAll();
        }
        this.addField(null);
        this._isArgNumberDirty = this._savePlugin.arguments.size() != this._listArgTextFields.size();
        this._bDeleteArgument.setEnabled(true);
        this.fireValidDirtyChange();
        this.repaintNow();
    }

    private void actionDeleteArgument() {
        int n = this._listArgTextFields.size() - 1;
        this._argumentsPanel.remove((JComponent)this._listArgTextFields.get(n));
        this._argumentsPanel.remove((JComponent)this._listArgLabels.get(n));
        this._listArgTextFields.remove(n);
        this._listArgLabels.remove(n);
        this._listArgValidDirty.remove(n);
        if (this._listArgTextFields.size() == 0) {
            Component[] componentArray = new Component[]{this.NO_ARGUMENTS_LABEL, Box.createHorizontalGlue()};
            this.addLine(this._argumentsPanel, componentArray, true, 0, UIFactory.getComponentSpace());
        }
        this._isArgNumberDirty = this._savePlugin.arguments.size() != this._listArgTextFields.size();
        this._bDeleteArgument.setEnabled(this._listArgTextFields.size() > 0);
        this.fireValidDirtyChange();
        this.repaintNow();
    }

    private void addField(String string) {
        String[] stringArray = new String[]{String.valueOf(this._listArgLabels.size() + 1)};
        JLabel jLabel = UIFactory.makeJLabel(this._resource.getString("pluginpanel", "larg-label", stringArray));
        JTextField jTextField = UIFactory.makeJTextField((Object)this, string, 20);
        jLabel.setLabelFor(jTextField);
        this._listArgLabels.add(jLabel);
        this._listArgTextFields.add(jTextField);
        boolean[] blArray = new boolean[]{true, false};
        this._listArgValidDirty.add(blArray);
        int n = this._listArgTextFields.size() - 1;
        if (this._savePlugin.arguments.size() > n) {
            this.checkField(jLabel, jTextField.getText(), (String)this._savePlugin.arguments.get(n), blArray);
        } else {
            blArray[0] = !jTextField.getText().equals("");
            blArray[1] = true;
            this.updateColoring(jLabel, blArray);
        }
        ++n;
        Component[] componentArray = new Component[]{jLabel, jTextField};
        this.addLine(this._argumentsPanel, componentArray, true, 0, UIFactory.getComponentSpace());
    }

    private void repaintNow() {
        this.revalidate();
        this.repaint();
    }
}

