/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;

public class ConfigClientControlPanel
extends ConfigBasePanel
implements ActionListener,
DocumentListener {
    private boolean _isInitializing;
    private boolean _isCancelled;
    private boolean _isInitializingComponents;
    private boolean _needsRestartServer;
    private JPanel _contentPanel;
    private JLabel _lSizeLimit;
    private JTextField _tfSizeLimit;
    private JCheckBox _cbSizeLimit;
    private JLabel _lLookThroughLimit;
    private JTextField _tfLookThroughLimit;
    private JCheckBox _cbLookThroughLimit;
    private JLabel _lTimeLimit;
    private JTextField _tfTimeLimit;
    private JCheckBox _cbTimeLimit;
    private JLabel _lIdleTimeout;
    private JTextField _tfIdleTimeout;
    private JCheckBox _cbIdleTimeout;
    private JLabel _lDSMLBufferSize;
    private JTextField _tfDSMLBufferSize;
    private JLabel _lDSMLRequestMaxSize;
    private JTextField _tfDSMLRequestMaxSize;
    private JLabel _lDSMLResponseMaxSize;
    private JTextField _tfDSMLResponseMaxSize;
    private boolean[] _isSizeLimitValidDirty = new boolean[]{true, false};
    private boolean[] _isLookThroughLimitValidDirty = new boolean[]{true, false};
    private boolean[] _isTimeLimitValidDirty = new boolean[]{true, false};
    private boolean[] _isIdleTimeoutValidDirty = new boolean[]{true, false};
    private boolean[] _isDSMLBufferSizeValidDirty = new boolean[]{true, false};
    private boolean[] _isDSMLRequestMaxSizeValidDirty = new boolean[]{true, false};
    private boolean[] _isDSMLResponseMaxSizeValidDirty = new boolean[]{true, false};
    private int _saveSizeLimit;
    private int _saveLookThroughLimit;
    private int _saveTimeLimit;
    private int _saveIdleTimeout;
    private int _saveDSMLBufferSize;
    private int _saveDSMLRequestMaxSize;
    private int _saveDSMLResponseMaxSize;
    private String _lastReadAttribute;
    private String _lastReadEntry;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("clientcontrolpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("clientcontrolpanel-no-rights", "label"), 2, 50);
    private final int UNLIMITED_SIZE_LIMIT = -1;
    private final int UNLIMITED_LOOK_THROUGH_LIMIT = -1;
    private final int UNLIMITED_TIME_LIMIT = -1;
    private final int UNLIMITED_IDLE_TIMEOUT = 0;
    private final int MAX_SIZE_LIMIT = Integer.MAX_VALUE;
    private final int MIN_SIZE_LIMIT = 0;
    private final int MAX_LOOK_THROUGH_LIMIT = Integer.MAX_VALUE;
    private final int MIN_LOOK_THROUGH_LIMIT = 0;
    private final int MAX_TIME_LIMIT = Integer.MAX_VALUE;
    private final int MIN_TIME_LIMIT = 0;
    private final int MAX_IDLE_TIMEOUT = Integer.MAX_VALUE;
    private final int MIN_IDLE_TIMEOUT = 1;
    private final int MAX_DSML_BUFFER_SIZE = Integer.MAX_VALUE;
    private final int MIN_DSML_BUFFER_SIZE = 1;
    private final int MAX_DSML_REQUEST_MAX_SIZE = Integer.MAX_VALUE;
    private final int MIN_DSML_REQUEST_MAX_SIZE = 1;
    private final int MAX_DSML_RESPONSE_MAX_SIZE = Integer.MAX_VALUE;
    private final int MIN_DSML_RESPONSE_MAX_SIZE = 1;

    public ConfigClientControlPanel() {
        this.setTitle(ConfigBasePanel._resource.getString("clientcontrolpanel", "title"));
        this._helpToken = "configuration-performance-client-control-help";
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigClientControlPanel.this.createContentPanel();
                        ConfigClientControlPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigClientControlPanel.access$300(1.access$200(this.this$1));
                                ConfigClientControlPanel.access$400(1.access$200(this.this$1));
                                1.access$200(this.this$1).showComponent(ConfigClientControlPanel.access$500(1.access$200(this.this$1)), false);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{ConfigClientControlPanel.access$600(1.access$200(this.this$1)), ConfigClientControlPanel.access$700(1.access$200(this.this$1))};
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("clientcontrolpanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigClientControlPanel.access$800(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{ConfigClientControlPanel.this._lastReadEntry, DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("clientcontrolpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigClientControlPanel.this._isInitialized = true;
                    ConfigClientControlPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigClientControlPanel access$200(1 var0) {
                    return var0.ConfigClientControlPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigClientControlPanel.this.initComponentsFromServerValues();
                    ConfigClientControlPanel.this.fireValidDirtyChange();
                    ConfigClientControlPanel.this.showComponent(ConfigClientControlPanel.this._contentPanel, false);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigClientControlPanel.this._lastReadAttribute, ConfigClientControlPanel.this._lastReadEntry};
                    ConfigClientControlPanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("clientcontrolpanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigClientControlPanel.this.showComponent((JComponent)ConfigClientControlPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{this._lastReadEntry, DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("clientcontrolpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigClientControlPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        this._needsRestartServer = false;
        boolean bl = false;
        String string = null;
        try {
            String string2;
            String string3;
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            if (this._isSizeLimitValidDirty[1]) {
                string3 = this._cbSizeLimit.isSelected() ? String.valueOf(-1) : this._tfSizeLimit.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-sizelimit", string3));
            }
            if (this._isTimeLimitValidDirty[1]) {
                string3 = this._cbTimeLimit.isSelected() ? String.valueOf(-1) : this._tfTimeLimit.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-timelimit", string3));
            }
            if (this._isIdleTimeoutValidDirty[1]) {
                string3 = this._cbIdleTimeout.isSelected() ? String.valueOf(0) : this._tfIdleTimeout.getText();
                lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-idletimeout", string3));
            }
            if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
                string = "cn=config";
                string3 = this.getServerInfo().getLDAPConnection();
                string3.modify(string, lDAPModificationSet);
                bl = true;
            }
            string3 = new LDAPModificationSet();
            if (this._isLookThroughLimitValidDirty[1]) {
                string2 = this._cbLookThroughLimit.isSelected() ? String.valueOf(-1) : this._tfLookThroughLimit.getText();
                string3.add(2, new LDAPAttribute("nsslapd-lookthroughlimit", string2));
            }
            if (string3.size() > 0 && !this._isCancelled) {
                string = "cn=config,cn=ldbm database,cn=plugins,cn=config";
                string2 = this.getServerInfo().getLDAPConnection();
                string2.modify(string, (LDAPModificationSet)string3);
                bl = true;
            }
            string2 = new LDAPModificationSet();
            if (this._isDSMLBufferSizeValidDirty[1]) {
                try {
                    int n = Integer.parseInt(this._tfDSMLBufferSize.getText());
                    string2.add(2, new LDAPAttribute("ds-hdsml-iobuffersize", String.valueOf(n *= 1024)));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if (this._isDSMLRequestMaxSizeValidDirty[1]) {
                try {
                    int n = Integer.parseInt(this._tfDSMLRequestMaxSize.getText());
                    string2.add(2, new LDAPAttribute("ds-hdsml-requestmaxsize", String.valueOf(n *= 1024)));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if (this._isDSMLResponseMaxSizeValidDirty[1]) {
                try {
                    int n = Integer.parseInt(this._tfDSMLResponseMaxSize.getText());
                    string2.add(2, new LDAPAttribute("ds-hdsml-responsemsgsize", String.valueOf(n *= 1024)));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if (string2.size() > 0 && !this._isCancelled) {
                string = "cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config";
                LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
                lDAPConnection.modify(string, (LDAPModificationSet)string2);
                bl = true;
            }
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
            throw new ConfigPanelException(ConfigBasePanel._resource.getString("clientcontrolpanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("clientcontrolpanel", "updating-server-error-msg", stringArray));
        }
        this._needsRestartServer = bl;
        if (!this._isCancelled && bl) {
            this.resetCallback();
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsRestartServer() {
        return this._needsRestartServer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbSizeLimit) {
            this.unlimitedClicked(this._cbSizeLimit, this._lSizeLimit, this._tfSizeLimit, this._saveSizeLimit, this._isSizeLimitValidDirty, -1);
        } else if (object == this._cbLookThroughLimit) {
            this.unlimitedClicked(this._cbLookThroughLimit, this._lLookThroughLimit, this._tfLookThroughLimit, this._saveLookThroughLimit, this._isLookThroughLimitValidDirty, -1);
        } else if (object == this._cbTimeLimit) {
            this.unlimitedClicked(this._cbTimeLimit, this._lTimeLimit, this._tfTimeLimit, this._saveTimeLimit, this._isTimeLimitValidDirty, -1);
        } else if (object == this._cbIdleTimeout) {
            this.unlimitedClicked(this._cbIdleTimeout, this._lIdleTimeout, this._tfIdleTimeout, this._saveIdleTimeout, this._isIdleTimeoutValidDirty, 0);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitializingComponents) {
            Document document = documentEvent.getDocument();
            if (document == this._tfSizeLimit.getDocument()) {
                this.fieldUpdated(this._tfSizeLimit, this._lSizeLimit, this._isSizeLimitValidDirty, this._saveSizeLimit, 0, Integer.MAX_VALUE);
            } else if (document == this._tfLookThroughLimit.getDocument()) {
                this.fieldUpdated(this._tfLookThroughLimit, this._lLookThroughLimit, this._isLookThroughLimitValidDirty, this._saveLookThroughLimit, 0, Integer.MAX_VALUE);
            } else if (document == this._tfTimeLimit.getDocument()) {
                this.fieldUpdated(this._tfTimeLimit, this._lTimeLimit, this._isTimeLimitValidDirty, this._saveTimeLimit, 0, Integer.MAX_VALUE);
            } else if (document == this._tfIdleTimeout.getDocument()) {
                this.fieldUpdated(this._tfIdleTimeout, this._lIdleTimeout, this._isIdleTimeoutValidDirty, this._saveIdleTimeout, 1, Integer.MAX_VALUE);
            } else if (document == this._tfDSMLBufferSize.getDocument()) {
                this.fieldUpdated(this._tfDSMLBufferSize, this._lDSMLBufferSize, this._isDSMLBufferSizeValidDirty, this._saveDSMLBufferSize, 1, Integer.MAX_VALUE);
            } else if (document == this._tfDSMLRequestMaxSize.getDocument()) {
                this.fieldUpdated(this._tfDSMLRequestMaxSize, this._lDSMLRequestMaxSize, this._isDSMLRequestMaxSizeValidDirty, this._saveDSMLRequestMaxSize, 1, Integer.MAX_VALUE);
            } else if (document == this._tfDSMLResponseMaxSize.getDocument()) {
                this.fieldUpdated(this._tfDSMLResponseMaxSize, this._lDSMLResponseMaxSize, this._isDSMLResponseMaxSizeValidDirty, this._saveDSMLResponseMaxSize, 1, Integer.MAX_VALUE);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._lSizeLimit = UIFactory.makeJLabel("clientcontrolpanel", "lsizelimit", ConfigBasePanel._resource);
        this._tfSizeLimit = UIFactory.makeJTextField(this, "clientcontrolpanel", "lsizelimit", null, 7, ConfigBasePanel._resource);
        this._cbSizeLimit = UIFactory.makeJCheckBox(this, "clientcontrolpanel", "cbsizelimit", false, ConfigBasePanel._resource);
        this._lSizeLimit.setLabelFor(this._tfSizeLimit);
        this._lLookThroughLimit = UIFactory.makeJLabel("clientcontrolpanel", "llookthroughlimit", ConfigBasePanel._resource);
        this._tfLookThroughLimit = UIFactory.makeJTextField(this, "clientcontrolpanel", "llookthroughlimit", null, 7, ConfigBasePanel._resource);
        this._cbLookThroughLimit = UIFactory.makeJCheckBox(this, "clientcontrolpanel", "cblookthroughlimit", false, ConfigBasePanel._resource);
        this._lLookThroughLimit.setLabelFor(this._tfLookThroughLimit);
        this._lTimeLimit = UIFactory.makeJLabel("clientcontrolpanel", "ltimelimit", ConfigBasePanel._resource);
        this._tfTimeLimit = UIFactory.makeJTextField(this, "clientcontrolpanel", "ltimelimit", null, 7, ConfigBasePanel._resource);
        this._cbTimeLimit = UIFactory.makeJCheckBox(this, "clientcontrolpanel", "cbtimelimit", false, ConfigBasePanel._resource);
        this._lTimeLimit.setLabelFor(this._tfTimeLimit);
        this._lIdleTimeout = UIFactory.makeJLabel("clientcontrolpanel", "lidletimeout", ConfigBasePanel._resource);
        this._tfIdleTimeout = UIFactory.makeJTextField(this, "clientcontrolpanel", "lidletimeout", null, 7, ConfigBasePanel._resource);
        this._cbIdleTimeout = UIFactory.makeJCheckBox(this, "clientcontrolpanel", "cbidletimeout", false, ConfigBasePanel._resource);
        this._lIdleTimeout.setLabelFor(this._tfIdleTimeout);
        this._lDSMLBufferSize = UIFactory.makeJLabel("clientcontrolpanel", "ldsmlbuffersize", ConfigBasePanel._resource);
        this._tfDSMLBufferSize = UIFactory.makeJTextField(this, "clientcontrolpanel", "ldsmlbuffersize", null, 7, ConfigBasePanel._resource);
        this._lDSMLBufferSize.setLabelFor(this._tfDSMLBufferSize);
        this._lDSMLRequestMaxSize = UIFactory.makeJLabel("clientcontrolpanel", "ldsmlrequestmaxsize", ConfigBasePanel._resource);
        this._tfDSMLRequestMaxSize = UIFactory.makeJTextField(this, "clientcontrolpanel", "ldsmlrequestmaxsize", null, 7, ConfigBasePanel._resource);
        this._lDSMLRequestMaxSize.setLabelFor(this._tfDSMLRequestMaxSize);
        this._lDSMLResponseMaxSize = UIFactory.makeJLabel("clientcontrolpanel", "ldsmlresponsemaxsize", ConfigBasePanel._resource);
        this._tfDSMLResponseMaxSize = UIFactory.makeJTextField(this, "clientcontrolpanel", "ldsmlresponsemaxsize", null, 7, ConfigBasePanel._resource);
        this._lDSMLResponseMaxSize.setLabelFor(this._tfDSMLResponseMaxSize);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("clientcontrolpanel", "ldapclientcontrolpanel-label"));
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        GroupPanel groupPanel2 = new GroupPanel(ConfigBasePanel._resource.getString("clientcontrolpanel", "dsmlclientcontrolpanel-label"));
        this._contentPanel.add((Component)groupPanel2, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        JLabel jLabel = UIFactory.makeJLabel("clientcontrolpanel", "lsizelimit-unit", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._tfSizeLimit);
        JComponent[] jComponentArray = new JComponent[]{this._lSizeLimit, this._tfSizeLimit, jLabel, this._cbSizeLimit};
        this.addLine(groupPanel, jComponentArray);
        jLabel = UIFactory.makeJLabel("clientcontrolpanel", "llookthroughlimit-unit", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._tfLookThroughLimit);
        JComponent[] jComponentArray2 = new JComponent[]{this._lLookThroughLimit, this._tfLookThroughLimit, jLabel, this._cbLookThroughLimit};
        this.addLine(groupPanel, jComponentArray2);
        jLabel = UIFactory.makeJLabel("clientcontrolpanel", "ltimelimit-unit", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._tfTimeLimit);
        JComponent[] jComponentArray3 = new JComponent[]{this._lTimeLimit, this._tfTimeLimit, jLabel, this._cbTimeLimit};
        this.addLine(groupPanel, jComponentArray3);
        jLabel = UIFactory.makeJLabel("clientcontrolpanel", "lidletimeout-unit", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._tfIdleTimeout);
        JComponent[] jComponentArray4 = new JComponent[]{this._lIdleTimeout, this._tfIdleTimeout, jLabel, this._cbIdleTimeout};
        this.addLine(groupPanel, jComponentArray4);
        jLabel = UIFactory.makeJLabel("clientcontrolpanel", "ldsmlbuffersize-unit", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._tfDSMLBufferSize);
        JComponent[] jComponentArray5 = new JComponent[]{this._lDSMLBufferSize, this._tfDSMLBufferSize, jLabel};
        this.addLine(groupPanel2, jComponentArray5);
        jLabel = UIFactory.makeJLabel("clientcontrolpanel", "ldsmlrequestmaxsize-unit", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._tfDSMLRequestMaxSize);
        JComponent[] jComponentArray6 = new JComponent[]{this._lDSMLRequestMaxSize, this._tfDSMLRequestMaxSize, jLabel};
        this.addLine(groupPanel2, jComponentArray6);
        jLabel = UIFactory.makeJLabel("clientcontrolpanel", "ldsmlresponsemaxsize-unit", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._tfDSMLResponseMaxSize);
        JComponent[] jComponentArray7 = new JComponent[]{this._lDSMLResponseMaxSize, this._tfDSMLResponseMaxSize, jLabel};
        this.addLine(groupPanel2, jComponentArray7);
    }

    private void readDataFromServer() throws LDAPException, NumberFormatException {
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setMaxResults(0);
        String[] stringArray = new String[]{"nsslapd-sizelimit", "nsslapd-timelimit", "nsslapd-idletimeout"};
        this._lastReadEntry = "cn=config";
        LDAPEntry lDAPEntry = lDAPConnection.read(this._lastReadEntry, stringArray, lDAPSearchConstraints);
        this._lastReadAttribute = "nsslapd-sizelimit";
        this._saveSizeLimit = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsslapd-timelimit";
        this._saveTimeLimit = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsslapd-idletimeout";
        this._saveIdleTimeout = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        if (this._saveIdleTimeout < 0) {
            this._saveIdleTimeout = 0;
        }
        String[] stringArray2 = new String[]{"nsslapd-lookthroughlimit"};
        this._lastReadEntry = "cn=config,cn=ldbm database,cn=plugins,cn=config";
        LDAPEntry lDAPEntry2 = lDAPConnection.read(this._lastReadEntry, stringArray2, lDAPSearchConstraints);
        this._lastReadAttribute = "nsslapd-lookthroughlimit";
        this._saveLookThroughLimit = Integer.parseInt(this.getValue(lDAPEntry2, this._lastReadAttribute).trim());
        String[] stringArray3 = new String[]{"ds-hdsml-iobuffersize", "ds-hdsml-requestmaxsize", "ds-hdsml-responsemsgsize"};
        this._lastReadEntry = "cn=DSMLv2-SOAP-HTTP,cn=frontends,cn=plugins,cn=config";
        LDAPEntry lDAPEntry3 = lDAPConnection.read(this._lastReadEntry, stringArray3, lDAPSearchConstraints);
        this._lastReadAttribute = "ds-hdsml-iobuffersize";
        this._saveDSMLBufferSize = DSUtil.getAttrValue(lDAPEntry3, this._lastReadAttribute).equals("") ? 0 : Integer.parseInt(this.getValue(lDAPEntry3, this._lastReadAttribute).trim()) / 1024;
        this._lastReadAttribute = "ds-hdsml-requestmaxsize";
        this._saveDSMLRequestMaxSize = DSUtil.getAttrValue(lDAPEntry3, this._lastReadAttribute).equals("") ? 0 : Integer.parseInt(this.getValue(lDAPEntry3, this._lastReadAttribute).trim()) / 1024;
        this._lastReadAttribute = "ds-hdsml-responsemsgsize";
        this._saveDSMLResponseMaxSize = DSUtil.getAttrValue(lDAPEntry3, this._lastReadAttribute).equals("") ? 0 : Integer.parseInt(this.getValue(lDAPEntry3, this._lastReadAttribute).trim()) / 1024;
    }

    private void initComponentsFromServerValues() {
        boolean bl;
        this._isInitializingComponents = true;
        boolean bl2 = bl = this._saveSizeLimit == -1;
        if (!bl) {
            this._tfSizeLimit.setText(String.valueOf(this._saveSizeLimit));
        } else {
            this._tfSizeLimit.setText("");
        }
        this._tfSizeLimit.setEnabled(!bl);
        this._cbSizeLimit.setSelected(bl);
        BlankPanel.setChangeState(this._lSizeLimit, 1);
        boolean bl3 = bl = this._saveLookThroughLimit == -1;
        if (!bl) {
            this._tfLookThroughLimit.setText(String.valueOf(this._saveLookThroughLimit));
        } else {
            this._tfLookThroughLimit.setText("");
        }
        this._tfLookThroughLimit.setEnabled(!bl);
        this._cbLookThroughLimit.setSelected(bl);
        BlankPanel.setChangeState(this._lLookThroughLimit, 1);
        boolean bl4 = bl = this._saveTimeLimit == -1;
        if (!bl) {
            this._tfTimeLimit.setText(String.valueOf(this._saveTimeLimit));
        } else {
            this._tfTimeLimit.setText("");
        }
        this._tfTimeLimit.setEnabled(!bl);
        this._cbTimeLimit.setSelected(bl);
        BlankPanel.setChangeState(this._lTimeLimit, 1);
        boolean bl5 = bl = this._saveIdleTimeout == 0;
        if (!bl) {
            this._tfIdleTimeout.setText(String.valueOf(this._saveIdleTimeout));
        } else {
            this._tfIdleTimeout.setText("");
        }
        this._tfIdleTimeout.setEnabled(!bl);
        this._cbIdleTimeout.setSelected(bl);
        BlankPanel.setChangeState(this._lIdleTimeout, 1);
        this._tfDSMLBufferSize.setText(String.valueOf(this._saveDSMLBufferSize));
        BlankPanel.setChangeState(this._lDSMLBufferSize, 1);
        this._tfDSMLRequestMaxSize.setText(String.valueOf(this._saveDSMLRequestMaxSize));
        BlankPanel.setChangeState(this._lDSMLRequestMaxSize, 1);
        this._tfDSMLResponseMaxSize.setText(String.valueOf(this._saveDSMLResponseMaxSize));
        BlankPanel.setChangeState(this._lDSMLResponseMaxSize, 1);
        this._isSizeLimitValidDirty[1] = false;
        this._isSizeLimitValidDirty[0] = true;
        this._isLookThroughLimitValidDirty[1] = false;
        this._isLookThroughLimitValidDirty[0] = true;
        this._isTimeLimitValidDirty[1] = false;
        this._isTimeLimitValidDirty[0] = true;
        this._isIdleTimeoutValidDirty[1] = false;
        this._isIdleTimeoutValidDirty[0] = true;
        this._isDSMLBufferSizeValidDirty[1] = false;
        this._isDSMLBufferSizeValidDirty[0] = true;
        this._isDSMLRequestMaxSizeValidDirty[1] = false;
        this._isDSMLRequestMaxSizeValidDirty[0] = true;
        this._isDSMLResponseMaxSizeValidDirty[1] = false;
        this._isDSMLResponseMaxSizeValidDirty[0] = true;
        this._isInitializingComponents = false;
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this._isSizeLimitValidDirty[1] || this._isLookThroughLimitValidDirty[1] || this._isTimeLimitValidDirty[1] || this._isIdleTimeoutValidDirty[1] || this._isDSMLBufferSizeValidDirty[1] || this._isDSMLRequestMaxSizeValidDirty[1] || this._isDSMLResponseMaxSizeValidDirty[1];
        if (bl2) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        boolean bl4 = bl = this._isSizeLimitValidDirty[0] && this._isLookThroughLimitValidDirty[0] && this._isTimeLimitValidDirty[0] && this._isIdleTimeoutValidDirty[0] && this._isDSMLBufferSizeValidDirty[0] && this._isDSMLRequestMaxSizeValidDirty[0] && this._isDSMLResponseMaxSizeValidDirty[0];
        if (bl) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private void addLine(Container container, JComponent[] jComponentArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = jComponentArray.length + 1;
        container.add((Component)jComponentArray[0], gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        int n = 1;
        while (n < jComponentArray.length - 1) {
            --gridBagConstraints.gridwidth;
            container.add((Component)jComponentArray[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        container.add((Component)jComponentArray[jComponentArray.length - 1], gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 0;
        container.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    private void unlimitedClicked(JCheckBox jCheckBox, JLabel jLabel, JTextField jTextField, int n, boolean[] blArray, int n2) {
        if (jCheckBox.isSelected()) {
            blArray[0] = true;
            blArray[1] = n != n2;
        } else {
            try {
                int n3 = Integer.parseInt(jTextField.getText());
                blArray[0] = n3 >= 0;
                blArray[1] = n3 != n;
            }
            catch (NumberFormatException numberFormatException) {
                blArray[0] = false;
                blArray[1] = true;
            }
        }
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        jTextField.setEnabled(!jCheckBox.isSelected());
        this.fireValidDirtyChange();
    }

    private void fieldUpdated(JTextField jTextField, JLabel jLabel, boolean[] blArray, int n, int n2, int n3) {
        try {
            int n4 = Integer.parseInt(jTextField.getText());
            blArray[1] = n4 != n;
            blArray[0] = n2 <= n4 && n4 <= n3;
        }
        catch (NumberFormatException numberFormatException) {
            blArray[0] = false;
            blArray[1] = true;
        }
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        this.fireValidDirtyChange();
    }
}

