/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;

public class ResourceSet {
    protected static final String separator = "-";
    protected static final char parameter = '%';
    protected static Hashtable cache = new Hashtable();
    protected static String sysLoaderCacheID = "sysLoader";
    protected PropertyResourceBundle prb;
    protected ClassLoader loader = new StackLookup().getLoader();
    protected Object loaderCacheID = this.loader == null ? sysLoaderCacheID : this.loader;
    protected String loaderName = this.loader == null ? sysLoaderCacheID : "loader" + this.loader.hashCode();

    public ResourceSet(String string, Locale locale) {
        this.prb = this.getBundle(string, locale);
    }

    public ResourceSet(String string) {
        this(string, Locale.getDefault());
    }

    public String getString(String string, String string2) {
        return this.getString(string, string2, (String[])null);
    }

    public String getString(String string, String string2, String[] stringArray) {
        if (this.prb != null) {
            if (string != null) {
                try {
                    return this.substitute(this.prb.getString(string + separator + string2), stringArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                return this.substitute(this.prb.getString(string2), stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Debug.println(1, "ResourceSet:getString():Unable to resolve " + string + separator + string2);
        return null;
    }

    public String getString(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return this.getString(string, string2, stringArray);
    }

    protected String substitute(String string, String[] stringArray) {
        if (stringArray == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] != '%') {
                stringBuffer.append(cArray[n]);
            } else {
                if (++n == cArray.length) {
                    stringBuffer.append(cArray[n]);
                    break;
                }
                int n2 = Character.getNumericValue(cArray[n]);
                if (n2 < 0 || n2 >= stringArray.length) {
                    stringBuffer.append("<error>");
                } else if (stringArray[n2] != null) {
                    stringBuffer.append(stringArray[n2]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected synchronized PropertyResourceBundle getBundle(String string, Locale locale) {
        PropertyResourceBundle propertyResourceBundle = this.getFromCache(string);
        if (propertyResourceBundle != null) {
            this.notifyAll();
            return propertyResourceBundle;
        }
        String string2 = "_" + locale.toString();
        String string3 = string.replace('.', '/');
        while (true) {
            String string4 = string3 + string2 + ".properties";
            InputStream inputStream = this.loader != null ? this.loader.getResourceAsStream(string4) : ClassLoader.getSystemResourceAsStream(string4);
            if (inputStream != null) {
                try {
                    propertyResourceBundle = new PropertyResourceBundle(inputStream);
                }
                catch (IOException iOException) {
                    Debug.println(0, "ResourceSet(): unable to process " + string);
                    this.notifyAll();
                    return null;
                }
                this.putInCache(string, propertyResourceBundle);
                this.notifyAll();
                return propertyResourceBundle;
            }
            int n = string2.lastIndexOf(95);
            if (n == -1) {
                Debug.println(0, "ResourceSet(): unable to open " + string);
                this.notifyAll();
                return null;
            }
            string2 = string2.substring(0, n);
        }
    }

    private PropertyResourceBundle getFromCache(String string) {
        Hashtable hashtable = (Hashtable)cache.get(this.loaderCacheID);
        PropertyResourceBundle propertyResourceBundle = null;
        if (hashtable != null) {
            propertyResourceBundle = (PropertyResourceBundle)hashtable.get(string);
        }
        if (Debug.getTraceLevel() == 9) {
            Debug.println(9, "ResourceSet: " + (propertyResourceBundle == null ? "NOT " : "") + "found " + this.loaderName + ":" + string);
        }
        return propertyResourceBundle;
    }

    private void putInCache(String string, PropertyResourceBundle propertyResourceBundle) {
        Hashtable<String, PropertyResourceBundle> hashtable = (Hashtable<String, PropertyResourceBundle>)cache.get(this.loaderCacheID);
        if (hashtable == null) {
            hashtable = new Hashtable<String, PropertyResourceBundle>();
            cache.put(this.loaderCacheID, hashtable);
            Debug.println(5, "ResourceSet: Create ResourceSet cache for " + this.loaderName);
        }
        hashtable.put(string, propertyResourceBundle);
    }

    static class StackLookup
    extends SecurityManager {
        StackLookup() {
        }

        public ClassLoader getLoader() {
            Class<?>[] classArray = this.getClassContext();
            Class<?> clazz = classArray[3];
            return clazz == null ? null : clazz.getClassLoader();
        }
    }
}

