/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;

public class ModalDialogUtil {
    private static Window _helperWindow;

    public static void dispose(JDialog jDialog) {
        if (jDialog != null) {
            jDialog.dispose();
        }
        ModalDialogUtil.sleep(200);
    }

    public static void disposeAndRaise(JDialog jDialog, Frame frame) {
        if (jDialog != null) {
            jDialog.dispose();
        }
        ModalDialogUtil.sleep(200);
        ModalDialogUtil.raise(frame);
    }

    public static void raise(Frame frame) {
        if (frame != null) {
            frame.toFront();
            frame.repaint();
        }
    }

    public static void sleep() {
        ModalDialogUtil.sleep(200);
    }

    public static void sleep(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            Debug.println(0, "ERROR ModalDialogUtil: exception: " + exception);
        }
    }

    public static Component getShowingAncestor(Component component) {
        while (component != null && !component.isShowing() && component.getParent() != null) {
            component = component.getParent();
        }
        if (component == null) {
            component = UtilConsoleGlobals.getActivatedFrame();
        }
        if (component == null || !component.isShowing()) {
            if (_helperWindow == null) {
                _helperWindow = new Window(new Frame());
            }
            if (!_helperWindow.isVisible()) {
                _helperWindow.setBounds(0, 0, 0, 0);
                _helperWindow.setVisible(true);
            }
            component = _helperWindow;
        }
        return component;
    }

    public static void setDialogLocation(Component component, Component component2) {
        Component component3 = ModalDialogUtil.getShowingAncestor(component2);
        Point point = component3.getLocationOnScreen();
        Point point2 = new Point();
        Dimension dimension = component3.getSize();
        Dimension dimension2 = component.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension2.width < dimension.width || dimension2.height < dimension.height) {
            point2.x = point.x + (dimension.width - dimension2.width) / 2;
            point2.y = point.y + (dimension.height - dimension2.height) / 2;
        } else {
            point2.x = point.x + 20;
            point2.y = point.y + 20;
        }
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.y < 0) {
            point2.y = 0;
        }
        if (point2.x + dimension2.width > dimension3.width) {
            point2.x = dimension3.width - dimension2.width;
        }
        if (point2.y + dimension2.height > dimension3.height) {
            point2.y = dimension3.height - dimension2.height;
        }
        component.setLocation(point2);
    }

    public static void setWindowLocation(Component component) {
        component.setLocation(ModalDialogUtil.calcWindowLocation(component.getSize()));
    }

    public static Point calcWindowLocation(Dimension dimension) {
        Point point = new Point();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        point.x = (dimension2.width - dimension.width) / 2;
        point.y = (dimension2.height - dimension.height) / 2;
        if (point.x + dimension.width > dimension2.width) {
            point.x = 0;
        }
        if (point.y + dimension.height > dimension2.height) {
            point.y = 0;
        }
        return point;
    }

    public static void setCenteredDialog(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component.getToolkit().getScreenSize();
        component.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }
}

