/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class LDAPInputStream
extends ByteArrayInputStream {
    private LDAPConnection _ldc;
    private String _attrName;
    private String _dn;

    public LDAPInputStream(LDAPConnection lDAPConnection, String string, String string2) {
        super(new byte[1]);
        this._ldc = lDAPConnection;
        this._dn = string;
        this._attrName = string2;
        this.pos = 0;
        this.count = 0;
        this.load();
    }

    private void load() {
        try {
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry = null;
            lDAPEntry = this._ldc.read(this._dn, new String[]{this._attrName});
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(this._attrName)) != null && (enumeration = lDAPAttribute.getByteValues()).hasMoreElements()) {
                this.buf = (byte[])enumeration.nextElement();
                this.pos = 0;
                this.count = this.buf.length;
            }
        }
        catch (LDAPException lDAPException) {
            switch (lDAPException.getLDAPResultCode()) {
                case 32: {
                    break;
                }
                default: {
                    Debug.println("Cannot read user preference: " + this._dn);
                }
            }
        }
    }
}

