/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.VLDirectoryTableModel;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.TableHeaderEditor;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiOptionPane;
import com.netscape.management.nmclf.SuiTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;

public class VLDirectoryTable
extends JPanel {
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
    SuiTable _table;
    VLDirectoryTableModel _dataModel;
    JScrollPane _scrollpane;
    JPopupMenu _tableHeaderMenu;
    JMenuItem _customizeMenuItem;
    Hashtable _map;
    Vector _attributes;
    Vector _columnNames;
    ConsoleInfo _ci;
    static String[] _availableAttributes;
    Preferences _prefs;
    private boolean _isColumnCustomizationEnabled = true;

    public VLDirectoryTable(Hashtable hashtable, Vector vector, Preferences preferences) {
        this(hashtable, vector);
        this._prefs = preferences;
    }

    public VLDirectoryTable(Hashtable hashtable, Vector vector) {
        super(true);
        this.setLayout(new BorderLayout());
        this._prefs = null;
        this._ci = null;
        this._map = hashtable;
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            Object v = hashtable.get(vector.elementAt(n));
            if (v == null) {
                vector2.addElement(vector.elementAt(n));
            } else {
                vector2.addElement(v);
            }
            ++n;
        }
        this._attributes = vector;
        this._columnNames = vector2;
        this._dataModel = new VLDirectoryTableModel(vector, vector2);
        this._table = new SuiTable((TableModel)this._dataModel);
        this._table.setColumnSelectionAllowed(false);
        this._table.setCellSelectionEnabled(false);
        this._table.setRowSelectionAllowed(true);
        this._table.setShowGrid(false);
        this._table.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this._customizeMenuItem = new JMenuItem(this._resource.getString("TableHeader", "Customize"));
        this._customizeMenuItem.addActionListener(new TableHeaderActionListener());
        this._tableHeaderMenu = new JPopupMenu();
        this._tableHeaderMenu.add(this._customizeMenuItem);
        int n2 = 0;
        while (n2 < this._dataModel.getColumnCount()) {
            switch (n2) {
                case 0: {
                    this._table.setColumnWidth(0, 200);
                    break;
                }
                case 1: {
                    this._table.setColumnWidth(1, 100);
                    break;
                }
                case 2: {
                    this._table.setColumnWidth(2, 200);
                }
            }
            ++n2;
        }
        this._scrollpane = SuiTable.createScrollPaneForTable((JTable)this._table);
        JViewport jViewport = this._scrollpane.getViewport();
        jViewport.setBackground(Color.white);
        this.add("Center", this._scrollpane);
    }

    public boolean isColumnCustomizationEnabled() {
        return this._isColumnCustomizationEnabled;
    }

    public void setColumnCustomizationEnabled(boolean bl) {
        this._isColumnCustomizationEnabled = bl;
    }

    public void setColumnInfo(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null) {
            int n = vector.size();
            int n2 = vector2.size();
            if (n == 0 || n != n2) {
                Debug.println("VLDirectoryTable.setColumnInfo: invalid parameters: size of column attributes and labels differ");
                return;
            }
            if (this._prefs != null) {
                this._prefs.set("ColumnCount", n);
                int n3 = 0;
                while (n3 < n) {
                    this._prefs.set("Attribute" + n3, (String)vector.elementAt(n3));
                    this._prefs.set("Label" + n3, (String)vector2.elementAt(n3));
                    ++n3;
                }
                PreferenceManager.saveAllPreferences();
            }
            this._attributes = vector;
            this._columnNames = vector2;
            this._dataModel.setColumnInfo(vector, vector2);
        } else {
            Debug.println("VLDirectoryTable.setColumnInfo: invalid parameters: column attributes and/or labels are null");
        }
    }

    public int getMaxResults() {
        return this._dataModel.getMaxResults();
    }

    public void setMaxResults(int n) {
        this._dataModel.setMaxResults(n);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this._table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addTableMouseListener(MouseListener mouseListener) {
        this._table.addMouseListener(mouseListener);
    }

    public synchronized void doSearch(LDAPConnection lDAPConnection, String string, String string2) {
        this.doSearch(lDAPConnection, string, 2, string2);
    }

    public synchronized void doSearch(LDAPConnection lDAPConnection, String string, int n, String string2) {
        int n2 = this._scrollpane.getViewport().getSize().height;
        int n3 = this._table.getRowHeight();
        int n4 = n2 / n3;
        this._dataModel.setPageSize(n4);
        this._dataModel.doSearch(lDAPConnection, string, n, string2);
        if (this._dataModel.getRowCount() > 0) {
            this._table.setRowSelectionInterval(0, 0);
        }
    }

    public void addRow(LDAPEntry lDAPEntry) {
        this._dataModel.addRow(lDAPEntry);
        int n = this._dataModel.getRowCount();
        int n2 = n - 1;
        if (n2 >= 0) {
            this._table.setRowSelectionInterval(n2, n2);
        }
    }

    public void addRow(String string) {
        this._dataModel.addRow(string);
    }

    public void replaceRow(LDAPEntry lDAPEntry, int n) {
        this._dataModel.replaceRow(lDAPEntry, n);
    }

    public int[] getSelectedRows() {
        return this._table.getSelectedRows();
    }

    public Vector getSelectedEntries() {
        int[] nArray = this._table.getSelectedRows();
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        if (nArray.length == 1 && this.getRow(nArray[0]) == null) {
            return vector;
        }
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(this.getRow(nArray[n]));
            ++n;
        }
        return vector;
    }

    public LDAPEntry getRow(int n) {
        return this._dataModel.getRow(n);
    }

    public int getRowCount() {
        return this._dataModel.getRowCount();
    }

    public int getSelectedRow() {
        return this._table.getSelectedRow();
    }

    public int getSelectedRowCount() {
        return this._table.getSelectedRowCount();
    }

    public void deleteAllRow() {
        this._dataModel.deleteAllRows();
    }

    public void deleteAllRows() {
        this._dataModel.deleteAllRows();
    }

    public void deleteRow(int[] nArray) {
        this.deleteRows(nArray);
    }

    public void deleteRows(int[] nArray) {
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(this.getRow(nArray[n]));
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            this._dataModel.deleteRow((LDAPEntry)vector.elementAt(n2));
            ++n2;
        }
    }

    public void deleteRows(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this._dataModel.deleteRow((LDAPEntry)vector.elementAt(n2));
            ++n2;
        }
    }

    public int rowAtPoint(Point point) {
        return this._table.rowAtPoint(point);
    }

    public void setTableColumnWidth(int n, int n2) {
        this._table.setColumnWidth(n, n2);
    }

    public void cancelSearch() {
        this._dataModel.cancelSearch();
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        this._ci = consoleInfo;
    }

    private boolean initializeAvailableAttributes() {
        if (this._ci == null) {
            Debug.println("VLDirectoryTable: no session info to get schema from");
            return false;
        }
        LDAPSchema lDAPSchema = null;
        LDAPConnection lDAPConnection = this._ci.getUserLDAPConnection();
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                lDAPSchema = new LDAPSchema();
                lDAPSchema.fetchSchema(lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                lDAPSchema = null;
            }
        }
        if (lDAPSchema == null) {
            Debug.println("VLDirectoryTable: could not get schema");
            return false;
        }
        Vector vector = new Vector();
        Vector vector2 = (Vector)ResourceEditor.getNewObjectClasses().get("newUserObjectClasses");
        Vector vector3 = (Vector)ResourceEditor.getNewObjectClasses().get("newGroupObjectClasses");
        Vector vector4 = (Vector)ResourceEditor.getNewObjectClasses().get("newOUObjectClasses");
        if (vector2 == null || vector3 == null || vector4 == null) {
            Debug.println("VLDirectoryTable: cannot get attributes since one or more objectclasses are null");
            return false;
        }
        this.getAllAttributesFor(vector, vector2, lDAPSchema);
        this.getAllAttributesFor(vector, vector3, lDAPSchema);
        this.getAllAttributesFor(vector, vector4, lDAPSchema);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        _availableAttributes = objectArray;
        return true;
    }

    private void getAllAttributesFor(Vector vector, Vector vector2, LDAPSchema lDAPSchema) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LDAPObjectClassSchema lDAPObjectClassSchema = lDAPSchema.getObjectClass(string);
            Enumeration enumeration2 = lDAPObjectClassSchema.getRequiredAttributes();
            Enumeration enumeration3 = lDAPObjectClassSchema.getOptionalAttributes();
            Object e = null;
            while (enumeration2.hasMoreElements()) {
                e = enumeration2.nextElement();
                if (((String)e).indexOf("binary") != -1 || vector.indexOf(e) != -1) continue;
                vector.addElement(e);
            }
            while (enumeration3.hasMoreElements()) {
                e = enumeration3.nextElement();
                if (((String)e).indexOf("binary") != -1 || vector.indexOf(e) != -1) continue;
                vector.addElement(e);
            }
        }
    }

    class TableHeaderMouseListener
    implements MouseListener {
        TableHeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (VLDirectoryTable.this._isColumnCustomizationEnabled && mouseEvent.isPopupTrigger()) {
                VLDirectoryTable.this._tableHeaderMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (VLDirectoryTable.this._isColumnCustomizationEnabled && mouseEvent.isPopupTrigger()) {
                VLDirectoryTable.this._tableHeaderMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class TableHeaderActionListener
    implements ActionListener {
        TableHeaderActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VLDirectoryTable.this._isColumnCustomizationEnabled && actionEvent.getSource().equals(VLDirectoryTable.this._customizeMenuItem)) {
                Window window;
                if (_availableAttributes == null) {
                    window = UtilConsoleGlobals.getActivatedFrame();
                    if (window != null) {
                        window.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    if (!VLDirectoryTable.this.initializeAvailableAttributes()) {
                        SuiOptionPane.showMessageDialog((Component)window, (Object)VLDirectoryTable.this._resource.getString("TableHeaderEditor", "NoSchemaError"), (String)VLDirectoryTable.this._resource.getString("TableHeaderEditor", "ErrorTitle"), (int)0);
                    }
                    if (window != null) {
                        window.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (_availableAttributes != null) {
                    window = new TableHeaderEditor(UtilConsoleGlobals.getActivatedFrame(), VLDirectoryTable.this._resource.getString("TableHeaderEditor", "Title"), VLDirectoryTable.this._resource.getString("TableHeaderEditor", "ListLabel"), VLDirectoryTable.this._resource.getString("TableHeaderEditor", "TableSelectedLabel"), VLDirectoryTable.this._resource.getString("TableHeaderEditor", "TableSelectedNameLabel"), _availableAttributes, VLDirectoryTable.this._attributes, VLDirectoryTable.this._columnNames);
                    ((TableHeaderEditor)window).show();
                    if (((AbstractDialog)window).isCancel()) {
                        return;
                    }
                    Vector vector = ((TableHeaderEditor)window).getColumnValues();
                    Vector vector2 = ((TableHeaderEditor)window).getColumnNames();
                    VLDirectoryTable.this.setColumnInfo(vector, vector2);
                }
            }
        }
    }
}

