/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.ActionPanel;
import com.netscape.management.client.ug.AdvancePanel;
import com.netscape.management.client.ug.AttributeSearchFilter;
import com.netscape.management.client.ug.BasicPanel;
import com.netscape.management.client.ug.ChangeDirectoryDialog;
import com.netscape.management.client.ug.IAdvancedResPickerPlugin;
import com.netscape.management.client.ug.IRPCallBack;
import com.netscape.management.client.ug.IResourcePickerPlugin;
import com.netscape.management.client.ug.ISearchResultCallBack;
import com.netscape.management.client.ug.PickerEditorResourceSet;
import com.netscape.management.client.ug.ResourcePickerDlgMenu;
import com.netscape.management.client.ug.SearchResultPanel;
import com.netscape.management.client.util.AbstractModalDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;

public class ResourcePickerDlg
extends AbstractModalDialog
implements ActionListener,
ComponentListener {
    private PickerEditorResourceSet resource = new PickerEditorResourceSet();
    public static final String BASIC_SEARCH_PANEL = "BASIC";
    public static final String ADVANCE_SEARCH_PANEL = "ADVANCE";
    private final int SEARCH_PANEL = 0;
    private final int RESULT_PANEL = 1;
    private final int PANEL_COUNT = 2;
    static final String ADMIN_BASE_DN = "ou=Administrators, ou=TopologyManagement, o=netscapeRoot";
    JPanel _mainPanel;
    CardLayout _mainPanelLayout;
    BasicPanel _basicPanel;
    boolean _basicSearchEnabled;
    AdvancePanel _advancedPanel;
    boolean _advancedSearchEnabled;
    ActionPanel _actionPanel;
    SearchResultPanel _searchResultPanel;
    boolean _requireCallback;
    IRPCallBack _callBack = null;
    ResourcePickerDlgMenu _menuBar;
    ConsoleInfo _consoleInfo;
    Object[] _displayedPanel = new Object[2];
    boolean[] _shown = new boolean[2];
    Vector _searchInterface;
    ISearchResultCallBack _resultCB = null;
    JLabel _baseDNValue;
    boolean _changeDirectoryEnabled = false;
    JFrame _parent;

    public ResourcePickerDlg(ConsoleInfo consoleInfo, JFrame jFrame) {
        super(jFrame);
        this._parent = jFrame;
        this.initialize(consoleInfo);
    }

    public ResourcePickerDlg(ConsoleInfo consoleInfo) {
        super((Frame)null);
        this._parent = null;
        this.initialize(consoleInfo);
    }

    public ResourcePickerDlg(ConsoleInfo consoleInfo, JFrame jFrame, SearchResultPanel searchResultPanel) {
        super((Frame)jFrame, "", 12);
        this._parent = jFrame;
        this.initialize(consoleInfo, searchResultPanel);
    }

    public ResourcePickerDlg(ConsoleInfo consoleInfo, SearchResultPanel searchResultPanel) {
        super(null, "", 12);
        this._parent = null;
        this.initialize(consoleInfo, searchResultPanel);
    }

    public ResourcePickerDlg(ConsoleInfo consoleInfo, IRPCallBack iRPCallBack, JFrame jFrame) {
        super(jFrame);
        this._parent = jFrame;
        this.initialize(consoleInfo);
        this._callBack = iRPCallBack;
    }

    public ResourcePickerDlg(ConsoleInfo consoleInfo, IRPCallBack iRPCallBack) {
        super((Frame)null);
        this._parent = null;
        this.initialize(consoleInfo);
        this._callBack = iRPCallBack;
    }

    public void setSearchResultCallBack(ISearchResultCallBack iSearchResultCallBack) {
        this._resultCB = iSearchResultCallBack;
    }

    public void setColumnInfo(Vector vector, Vector vector2) {
        this._searchResultPanel.setColumnInfo(vector, vector2);
    }

    public int getMaxResults() {
        return this._searchResultPanel.getMaxResults();
    }

    public void setMaxResults(int n) {
        this._searchResultPanel.setMaxResults(n);
    }

    public void setEnableBasicSearch(boolean bl) {
        this.setBasicSearchEnabled(bl);
    }

    public void setBasicSearchEnabled(boolean bl) {
        this._menuBar.disableSearchInterfaceMenuItem(this._searchInterface.indexOf(this._basicPanel), bl);
        this._basicSearchEnabled = bl;
    }

    public void enableAdminSearch() {
        if (this._basicPanel != null) {
            this._basicPanel.enableAdminSearch();
        }
        if (this._advancedPanel != null) {
            this._advancedPanel.enableAdminSearch();
        }
    }

    public void setBasicSearchFilter(AttributeSearchFilter[] attributeSearchFilterArray) {
        this._basicPanel.setDisplayAttribute(attributeSearchFilterArray);
    }

    public void setEnableAdvanceSearch(boolean bl) {
        this.setAdvancedSearchEnabled(bl);
    }

    public void setAdvancedSearchEnabled(boolean bl) {
        this._menuBar.disableSearchInterfaceMenuItem(this._searchInterface.indexOf(this._advancedPanel), bl);
        this._advancedSearchEnabled = bl;
    }

    public void setAtributeSearchFilter(AttributeSearchFilter[] attributeSearchFilterArray) {
        this._advancedPanel.setDisplayAttribute(attributeSearchFilterArray);
    }

    public void setAttributeSearchFilter(AttributeSearchFilter[] attributeSearchFilterArray) {
        this._advancedPanel.setDisplayAttribute(attributeSearchFilterArray);
    }

    public void appendSearchInterface(IResourcePickerPlugin iResourcePickerPlugin) {
        this._menuBar.addSearchInterfaceMenuItem(iResourcePickerPlugin.getDisplayName(), iResourcePickerPlugin.getID(), this._searchInterface.size());
        this._searchInterface.addElement(iResourcePickerPlugin);
        this._mainPanel.add(iResourcePickerPlugin.getID(), iResourcePickerPlugin.getSearchUI());
        ((Component)((Object)iResourcePickerPlugin)).addComponentListener(this);
        this._actionPanel.updateMethodButtonWidth(iResourcePickerPlugin.getDisplayName());
        if (this._displayedPanel[0] != null) {
            this.selectSearchInterface(((IResourcePickerPlugin)this._displayedPanel[0]).getID());
        }
    }

    public void insertSearchInterfaceAt(int n, IResourcePickerPlugin iResourcePickerPlugin) {
        this._menuBar.addSearchInterfaceMenuItem(iResourcePickerPlugin.getDisplayName(), iResourcePickerPlugin.getID(), this._searchInterface.size());
        this._searchInterface.insertElementAt(iResourcePickerPlugin, n);
        this._mainPanel.add(iResourcePickerPlugin.getID(), iResourcePickerPlugin.getSearchUI());
        ((Component)((Object)iResourcePickerPlugin)).addComponentListener(this);
        this._actionPanel.updateMethodButtonWidth(iResourcePickerPlugin.getDisplayName());
        if (this._displayedPanel[0] != null) {
            this.selectSearchInterface(((IResourcePickerPlugin)this._displayedPanel[0]).getID());
        }
    }

    public void deleteSearchInterface(int n) {
        IResourcePickerPlugin iResourcePickerPlugin = (IResourcePickerPlugin)this._searchInterface.elementAt(n);
        if (iResourcePickerPlugin == this._displayedPanel[0]) {
            IResourcePickerPlugin iResourcePickerPlugin2 = this.getNextInterface(iResourcePickerPlugin);
            this._displayedPanel[0] = iResourcePickerPlugin2 == iResourcePickerPlugin ? null : iResourcePickerPlugin2;
        }
        this._mainPanel.remove(iResourcePickerPlugin.getSearchUI());
        this._searchInterface.removeElementAt(n);
        this._menuBar.deleteSearchInterfaceMenuItem(n);
        if (this._displayedPanel[0] != null) {
            this.selectSearchInterface(((IResourcePickerPlugin)this._displayedPanel[0]).getID());
        } else {
            this._actionPanel.setMethodButtonText("", "");
            this.updateGUI();
        }
    }

    public Enumeration getSearchInterfaces() {
        return this._searchInterface.elements();
    }

    public void selectSearchInterface(String string) {
        Enumeration enumeration = this.getSearchInterfaces();
        String string2 = "";
        String string3 = "";
        while (enumeration.hasMoreElements()) {
            IResourcePickerPlugin iResourcePickerPlugin = (IResourcePickerPlugin)enumeration.nextElement();
            if (!iResourcePickerPlugin.getID().equals(string)) continue;
            this._mainPanelLayout.show(this._mainPanel, string);
            this._displayedPanel[0] = iResourcePickerPlugin;
            this._shown[0] = true;
            iResourcePickerPlugin = this.getNextInterface(iResourcePickerPlugin);
            if (iResourcePickerPlugin == null) {
                this._actionPanel.setEnableMethod(false);
            } else {
                string2 = iResourcePickerPlugin.getID();
                string3 = iResourcePickerPlugin.getDisplayName();
                this._actionPanel.setMethodButtonText(string2, string3);
            }
            this.updateGUI();
            return;
        }
    }

    private IResourcePickerPlugin getNextInterface(IResourcePickerPlugin iResourcePickerPlugin) {
        IResourcePickerPlugin iResourcePickerPlugin2;
        block3: {
            IResourcePickerPlugin iResourcePickerPlugin3;
            iResourcePickerPlugin2 = null;
            int n = this._searchInterface.indexOf(iResourcePickerPlugin);
            while (true) {
                if (++n >= this._searchInterface.size()) {
                    n = 0;
                }
                if ((iResourcePickerPlugin3 = (IResourcePickerPlugin)this._searchInterface.elementAt(n)) == iResourcePickerPlugin) break block3;
                if (iResourcePickerPlugin3 == this._basicPanel && !this._basicSearchEnabled) {
                    ++n;
                    continue;
                }
                if (iResourcePickerPlugin3 != this._advancedPanel || this._advancedSearchEnabled) break;
                ++n;
            }
            iResourcePickerPlugin2 = iResourcePickerPlugin3;
        }
        return iResourcePickerPlugin2;
    }

    private void initialize(ConsoleInfo consoleInfo) {
        this.setTitle(this.resource.getString("resourcePicker", "Title"));
        this._consoleInfo = (ConsoleInfo)consoleInfo.clone();
        this._searchInterface = new Vector();
        this._actionPanel = new ActionPanel(this);
        this.setDefaultButton(this._actionPanel.getSearchButton());
        this._menuBar = new ResourcePickerDlgMenu(this);
        this._mainPanelLayout = new CardLayout();
        this._mainPanel = new JPanel(this._mainPanelLayout);
        this._basicPanel = new BasicPanel();
        this._basicPanel.setActionPanel(this._actionPanel);
        this.appendSearchInterface(this._basicPanel);
        this._basicSearchEnabled = true;
        this._advancedPanel = new AdvancePanel();
        this._advancedPanel.setActionPanel(this._actionPanel);
        this.appendSearchInterface(this._advancedPanel);
        this._advancedSearchEnabled = true;
        this.selectSearchInterface(BASIC_SEARCH_PANEL);
        this.setFocusComponent(this._basicPanel.getFocusComponent());
        this._searchResultPanel = new SearchResultPanel(this._consoleInfo, this);
        this._requireCallback = true;
        this._displayedPanel[1] = this._searchResultPanel;
        this._shown[1] = false;
        JLabel jLabel = new JLabel(this.resource.getString("resourcePicker", "SearchBaseDN"), 4);
        jLabel.setLabelFor(this._baseDNValue);
        this._baseDNValue = new JLabel("");
        this.updateBaseDN();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagUtil.constrain(container, jLabel, 0, 0, 1, 1, 0.0, 0.0, 18, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(container, this._baseDNValue, 1, 0, 1, 1, 1.0, 0.0, 18, 2, 0, 9, 0, 0);
        GridBagUtil.constrain(container, this._actionPanel, 2, 0, 1, 2, 0.0, 0.0, 12, 0, 0, 12, 0, 0);
        GridBagUtil.constrain(container, this._mainPanel, 0, 1, 2, 1, 1.0, 0.0, 18, 2, 12, 0, 0, 0);
        GridBagUtil.constrain(container, this._searchResultPanel, 0, 2, 0, 0, 1.0, 1.0, 18, 1, 12, 0, 0, 0);
        this.setChangeDirectoryEnabled(this._changeDirectoryEnabled);
        this.setMinimumSize(600, 330);
        this.setSize(600, 330);
    }

    private void initialize(ConsoleInfo consoleInfo, SearchResultPanel searchResultPanel) {
        this.setTitle(this.resource.getString("resourcePicker", "Title"));
        this._consoleInfo = consoleInfo;
        this._searchInterface = new Vector();
        this._actionPanel = new ActionPanel(this);
        this.setDefaultButton(this._actionPanel.getSearchButton());
        this._menuBar = new ResourcePickerDlgMenu(this);
        this._mainPanelLayout = new CardLayout();
        this._mainPanel = new JPanel(this._mainPanelLayout);
        this._basicPanel = null;
        this._basicSearchEnabled = false;
        this._advancedPanel = new AdvancePanel();
        this._advancedPanel.setActionPanel(this._actionPanel);
        this.appendSearchInterface(this._advancedPanel);
        this._advancedSearchEnabled = true;
        this.selectSearchInterface(ADVANCE_SEARCH_PANEL);
        this.setFocusComponent(this._advancedPanel.getFocusComponent());
        this._searchResultPanel = searchResultPanel;
        this._requireCallback = false;
        this._displayedPanel[1] = this._searchResultPanel;
        this._shown[1] = false;
        JLabel jLabel = new JLabel(this.resource.getString("resourcePicker", "SearchBaseDN"), 4);
        this._baseDNValue = new JLabel("");
        jLabel.setLabelFor(this._baseDNValue);
        this.updateBaseDN();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagUtil.constrain(container, jLabel, 0, 0, 1, 1, 0.0, 0.0, 18, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(container, this._baseDNValue, 1, 0, 1, 1, 1.0, 0.0, 18, 2, 0, 9, 0, 0);
        GridBagUtil.constrain(container, this._actionPanel, 2, 0, 1, 2, 0.0, 0.0, 12, 0, 0, 12, 0, 0);
        GridBagUtil.constrain(container, this._mainPanel, 0, 1, 2, 1, 1.0, 0.0, 18, 2, 12, 0, 0, 0);
        JLabel jLabel2 = new JLabel("");
        GridBagUtil.constrain(container, jLabel2, 0, 2, 0, 0, 1.0, 1.0, 18, 1, 12, 0, 0, 0);
        this.setChangeDirectoryEnabled(this._changeDirectoryEnabled);
        this.setMinimumSize(600, 210);
        this.setSize(600, 210);
    }

    private void startSearching() {
        boolean bl = false;
        this.setBusyCursor(true);
        this._actionPanel.setEnableSearch(false);
        this._searchResultPanel.removeAllElements();
        String string = ((IResourcePickerPlugin)this._displayedPanel[0]).getFilterString();
        if (this._displayedPanel[0] instanceof AdvancePanel) {
            AdvancePanel advancePanel = (AdvancePanel)this._displayedPanel[0];
            bl = advancePanel.getSearchType().equals("Administrators");
        } else if (this._displayedPanel[0] instanceof BasicPanel) {
            BasicPanel basicPanel = (BasicPanel)this._displayedPanel[0];
            bl = basicPanel.getSearchType().equals("Administrators");
        }
        if (string != null && !string.equals("")) {
            if (bl) {
                this._searchResultPanel.doSearch(this._consoleInfo.getLDAPConnection(), ADMIN_BASE_DN, string);
            } else {
                this._searchResultPanel.doSearch(this._consoleInfo.getUserLDAPConnection(), this._consoleInfo.getUserBaseDN(), string);
            }
        }
        this._actionPanel.setEnableSearch(true);
        if (this._resultCB != null) {
            this._resultCB.update();
        }
        this.setBusyCursor(false);
    }

    boolean isUser(LDAPEntry lDAPEntry) {
        boolean bl = true;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttributeSet().getAttribute("objectclass");
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration.hasMoreElements()) {
            if (!"groupOfUniqueNames".equalsIgnoreCase((String)enumeration.nextElement())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void okInvoked() {
        if (this._callBack != null && this._requireCallback) {
            try {
                this._callBack.getResults(this._searchResultPanel.getSelectedEntries());
            }
            catch (Exception exception) {
                return;
            }
        }
        super.okInvoked();
    }

    protected void helpInvoked() {
        if (this._displayedPanel[0] instanceof IResourcePickerPlugin) {
            ((IResourcePickerPlugin)this._displayedPanel[0]).help();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().startsWith("SHOW:")) {
            this.selectSearchInterface(actionEvent.getActionCommand().substring(5));
            this.updateGUI();
        } else if (actionEvent.getActionCommand().equals("ChangeDir")) {
            ChangeDirectoryDialog changeDirectoryDialog = new ChangeDirectoryDialog(this._parent, this._consoleInfo);
            changeDirectoryDialog.show();
            this.updateBaseDN();
        } else if (actionEvent.getActionCommand().equals("Search")) {
            if (this._displayedPanel[0] instanceof IResourcePickerPlugin) {
                this.startSearching();
            } else if (this._displayedPanel[0] instanceof IAdvancedResPickerPlugin) {
                ((IAdvancedResPickerPlugin)this._displayedPanel[0]).start();
            }
            if (this._searchResultPanel.getListCount() > 0) {
                this._shown[1] = true;
            }
            this.updateGUI();
        } else {
            Debug.println("ResourcePickerDlg: unhandled option: " + actionEvent.getActionCommand());
        }
    }

    public void setCallBack(IRPCallBack iRPCallBack) {
        this._callBack = iRPCallBack;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getComponent().equals(this._displayedPanel[0])) {
            this.updateGUI();
        }
    }

    private void updateGUI() {
        this.validate();
        this.repaint();
    }

    public boolean showModally() {
        super.show();
        return true;
    }

    public void setAllowChangeDirectory(boolean bl) {
        this.setChangeDirectoryEnabled(bl);
    }

    public void setChangeDirectoryEnabled(boolean bl) {
        this._changeDirectoryEnabled = bl;
        this._actionPanel.setAllowChangeDirectory(bl);
    }

    private void updateBaseDN() {
        LDAPConnection lDAPConnection = this._consoleInfo.getUserLDAPConnection();
        String string = lDAPConnection != null && lDAPConnection.getSocketFactory() != null ? "ldaps://" : "ldap://";
        this._baseDNValue.setText(string + this._consoleInfo.getUserHost() + ":" + this._consoleInfo.getUserPort() + "/" + this._consoleInfo.getUserBaseDN());
    }
}

