/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.LdapQueryBuilderDialog;
import com.netscape.management.client.ug.PickerEditorResourceSet;
import com.netscape.management.client.ug.SearchResultPanel;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPUrl;

public class DynamicQueryDlg
extends AbstractDialog {
    PickerEditorResourceSet _resource = new PickerEditorResourceSet();
    JTextField _url;
    JButton _constructButton;
    JButton _testButton;
    SearchResultPanel _resultPanel;
    String _resultQuery;
    ConsoleInfo _consoleInfo;
    Help _helpSession;
    FocusAdapter _focusAdaptor = new FocusAdapter(){

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getComponent() == DynamicQueryDlg.this._url) {
                DynamicQueryDlg.this._testButton.getRootPane().setDefaultButton(DynamicQueryDlg.this._testButton);
            }
        }
    };
    ActionListener _actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == DynamicQueryDlg.this._constructButton) {
                LdapQueryBuilderDialog ldapQueryBuilderDialog = new LdapQueryBuilderDialog(DynamicQueryDlg.this._resource.getString("dynamicQueryConstructor", "title"), DynamicQueryDlg.this._consoleInfo);
                ldapQueryBuilderDialog.show();
                if (!ldapQueryBuilderDialog.isCancel()) {
                    DynamicQueryDlg.this._url.setText(ldapQueryBuilderDialog.getQueryString());
                }
            } else if (object == DynamicQueryDlg.this._testButton) {
                Debug.println("DynamicQueryDlg:" + DynamicQueryDlg.this._url.getText());
                DynamicQueryDlg.this._resultPanel.removeAllElements();
                LDAPUrl lDAPUrl = DynamicQueryDlg.this.getLDAPUrl();
                if (lDAPUrl == null) {
                    return;
                }
                LDAPConnection lDAPConnection = DynamicQueryDlg.this._consoleInfo.getUserLDAPConnection();
                if (!lDAPConnection.isConnected()) {
                    Debug.println("DynamicQueryDlg.actionPerformed: not connected");
                    return;
                }
                Debug.println("DynamicQueryDlg:" + lDAPUrl.getHost() + " " + lDAPUrl.getPort());
                DynamicQueryDlg.this._resultPanel.doSearch(lDAPConnection, lDAPUrl);
            }
        }
    };

    public DynamicQueryDlg(ConsoleInfo consoleInfo, JFrame jFrame, boolean bl, String string) {
        super(jFrame, "", bl, 11, 0);
        this._helpSession = new Help(this._resource);
        this.setTitle(this._resource.getString("dynamicQuery", "title"));
        this._resultQuery = "";
        this._consoleInfo = consoleInfo;
        JLabel jLabel = new JLabel(this._resource.getString("dynamicQuery", "label"));
        this._url = new JTextField();
        jLabel.setLabelFor(jLabel);
        this._url.setText(string);
        this._url.addFocusListener(this._focusAdaptor);
        this._constructButton = new JButton(this._resource.getString("dynamicQuery", "constructQuery"));
        this._constructButton.setToolTipText(this._resource.getString("dynamicQuery", "constructQuery_tt"));
        this._constructButton.addActionListener(this._actionListener);
        this._testButton = new JButton(this._resource.getString("dynamicQuery", "testQuery"));
        this._testButton.setToolTipText(this._resource.getString("dynamicQuery", "testQuery_tt"));
        this._testButton.addActionListener(this._actionListener);
        JButtonFactory.resizeGroup(this._constructButton, this._testButton);
        JLabel jLabel2 = new JLabel("");
        JLabel jLabel3 = new JLabel(this._resource.getString("dynamicQuery", "resultLabel"));
        this._resultPanel = new SearchResultPanel(this._actionListener);
        jLabel3.setLabelFor(this._resultPanel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 0, 1, 1.0, 0.0, 18, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(jPanel, this._url, 0, 1, 0, 1, 1.0, 0.0, 18, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(jPanel, this._testButton, 0, 2, 1, 1, 0.0, 0.0, 18, 0, 9, 0, 0, 0);
        GridBagUtil.constrain(jPanel, this._constructButton, 1, 2, 1, 1, 0.0, 0.0, 18, 0, 9, 6, 0, 0);
        GridBagUtil.constrain(jPanel, jLabel3, 0, 3, 0, 1, 1.0, 0.0, 18, 2, 12, 0, 0, 0);
        GridBagUtil.constrain(jPanel, this._resultPanel, 0, 4, 0, 0, 1.0, 1.0, 10, 1, 0, 0, 0, 0);
        this.setComponent(jPanel);
        this.setMinimumSize(600, 350);
        this.setSize(600, 350);
    }

    private LDAPUrl getLDAPUrl() {
        String string = this._url.getText();
        LDAPUrl lDAPUrl = null;
        String string2 = null;
        try {
            lDAPUrl = new LDAPUrl(LDAPUrl.decode((String)string));
            if (!string.startsWith("ldap:///") && !string.startsWith("ldaps:///")) {
                string2 = this._resource.getString("dynamicQuery", "errorHostPort");
                lDAPUrl = null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            string2 = this._resource.getString("dynamicQuery", "errortext");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = this._resource.getString("dynamicQuery", "errortext");
        }
        if (string2 != null) {
            JOptionPane.showMessageDialog(UtilConsoleGlobals.getActivatedFrame(), string2, this._resource.getString("dynamicQuery", "errortitle"), 0);
            ModalDialogUtil.sleep();
            this._url.requestFocus();
            this._url.selectAll();
        }
        return lDAPUrl;
    }

    public void okInvoked() {
        if (this.getLDAPUrl() == null) {
            return;
        }
        this._resultQuery = this._url.getText();
        super.okInvoked();
    }

    public void helpInvoked() {
        this._helpSession.contextHelp("ug", "ResEditorDynamicGpMembersAdd");
    }

    public String getResult() {
        return this._resultQuery;
    }
}

