/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.ActionPanel;
import com.netscape.management.client.ug.AttributeSearchFilter;
import com.netscape.management.client.ug.IStandardResPickerPlugin;
import com.netscape.management.client.ug.PickerEditorResourceSet;
import com.netscape.management.client.ug.ResourcePickerDlg;
import com.netscape.management.client.ug.SearchParameter;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AdvancePanel
extends JPanel
implements ActionListener,
IStandardResPickerPlugin {
    private static final int MAX_SEARCH_PARAMETERS = 5;
    public static final String KEY_USERS = "Users";
    public static final String KEY_GROUPS = "Groups";
    public static final String KEY_USERS_GROUPS = "Users and Groups";
    public static final String KEY_ADMINISTRATORS = "Administrators";
    private static final String KEY_SERVERS = "Servers";
    private static final String KEY_CONTAINS = "contains";
    private static final String KEY_EQUALS = "equals";
    private static final String KEY_NOT_EQUALS = "does not equal";
    PickerEditorResourceSet _resource = new PickerEditorResourceSet();
    JComboBox _puSearchGroup;
    Hashtable _objectClassLookup;
    JButton bMore;
    JButton bFewer;
    int _iDisplayCount = 1;
    JLabel _label1 = new JLabel(this._resource.getString("search", "AdvancedLabel"), 4);
    JLabel _label2 = new JLabel(this._resource.getString("advance", "conditionLabel"), 4);
    JLabel[] _additionalConditionLabels;
    GridBagLayout _layout;
    SearchParameter[] _p;
    ConsoleInfo _ConsoleInfo;
    AttributeSearchFilter[] _AttributeSearchFilter;

    public AdvancePanel() {
        this._puSearchGroup = new JComboBox();
        this._label1.setLabelFor(this._puSearchGroup);
        this._objectClassLookup = new Hashtable();
        int n = Integer.parseInt(this._resource.getString("search", "Nchoice"));
        int n2 = 0;
        while (n2 < n) {
            String string = this._resource.getString("search", "Choice" + n2);
            int n3 = string.indexOf(44);
            String string2 = string.substring(0, n3);
            String string3 = string.substring(n3 + 1);
            this._objectClassLookup.put(string2, string3);
            this._puSearchGroup.addItem(string3);
            ++n2;
        }
        this._puSearchGroup.setSelectedItem(this._objectClassLookup.get(KEY_USERS_GROUPS));
        this._additionalConditionLabels = new JLabel[4];
        this._p = new SearchParameter[5];
        int n4 = 0;
        while (n4 < 5) {
            this._p[n4] = new SearchParameter();
            if (n4 < 4) {
                this._additionalConditionLabels[n4] = new JLabel(this._resource.getString("advance", "additionalConditionLabel"), 4);
            }
            ++n4;
        }
        this.bMore = new JButton(this._resource.getString("advance", "moreButton"));
        JButtonFactory.initializeMnemonic(this.bMore);
        this.bMore.setToolTipText(this._resource.getString("advance", "more_tt"));
        this.bMore.addActionListener(this);
        this.bFewer = new JButton(this._resource.getString("advance", "fewerButton"));
        JButtonFactory.initializeMnemonic(this.bFewer);
        this.bFewer.setToolTipText(this._resource.getString("advance", "fewer_tt"));
        this.bFewer.addActionListener(this);
        this.bFewer.setEnabled(false);
        this.resetLayout();
    }

    public void enableAdminSearch() {
        String string = KEY_ADMINISTRATORS;
        String string2 = this._resource.getString("search", "ChoiceAdmin");
        this._objectClassLookup.put(string, string2);
        this._puSearchGroup.addItem(string2);
    }

    public void initialize(ConsoleInfo consoleInfo) {
        this._ConsoleInfo = consoleInfo;
    }

    public void setActionPanel(ActionPanel actionPanel) {
        int n = 0;
        while (n < this._p.length) {
            this._p[n].setActionPanel(actionPanel);
            ++n;
        }
    }

    public JComponent getFocusComponent() {
        return this._p[0].getFocusComponent();
    }

    public String getID() {
        return "ADVANCE";
    }

    public String getDisplayName() {
        return this._resource.getString("ActionPanel", "AdvancedButton");
    }

    public Component getSearchUI() {
        return this;
    }

    public void setDisplayAttribute(AttributeSearchFilter[] attributeSearchFilterArray) {
        this._AttributeSearchFilter = attributeSearchFilterArray;
    }

    public AttributeSearchFilter[] getDisplayAttribute() {
        return this._AttributeSearchFilter;
    }

    void resetLayout() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagUtil.constrain(this, this._label1, 0, 0, 1, 1, 0.0, 0.0, 17, 2, 0, 48, 0, 0);
        GridBagUtil.constrain(this, this._puSearchGroup, 1, 0, 0, 1, 1.0, 0.0, 17, 2, 0, 9, 0, 0);
        GridBagUtil.constrain(this, this._label2, 0, 1, 1, 1, 0.0, 0.0, 17, 2, 9, 0, 0, 0);
        GridBagUtil.constrain(this, this._p[0], 1, 1, 0, 1, 1.0, 0.0, 17, 2, 9, 9, 0, 0);
        this._label2.setLabelFor(this._p[0]);
        int n = 1;
        while (n < this._iDisplayCount) {
            this._additionalConditionLabels[n - 1].setLabelFor(this._p[n]);
            GridBagUtil.constrain(this, this._additionalConditionLabels[n - 1], 0, n + 1, 1, 1, 0.0, 0.0, 17, 2, 6, 0, 0, 0);
            GridBagUtil.constrain(this, this._p[n], 1, n + 1, 0, 1, 1.0, 0.0, 17, 2, 6, 9, 0, 0);
            ++n;
        }
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 6, 0));
        jPanel2.add(this.bMore);
        jPanel2.add(this.bFewer);
        jPanel.add(jPanel2);
        GridBagUtil.constrain(this, jPanel, 1, this._iDisplayCount + 1, 0, 1, 1.0, 0.0, 15, 2, 6, 9, 0, 0);
        this.doLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        if (actionEvent.getSource().equals(this.bMore)) {
            ++this._iDisplayCount;
            if (this._iDisplayCount == 5) {
                this.bMore.setEnabled(false);
            }
            this.bFewer.setEnabled(true);
            this.resetLayout();
            n = this._p[0].getFocusComponent().getHeight() + 6;
            this.setSize(this.getSize().width, this.getSize().height + n);
            this.resizeParent(n);
        } else if (actionEvent.getSource().equals(this.bFewer)) {
            --this._iDisplayCount;
            if (this._iDisplayCount == 1) {
                this.bFewer.setEnabled(false);
            }
            this.bMore.setEnabled(true);
            this.resetLayout();
            n = this._p[0].getFocusComponent().getHeight() + 6;
            this.setSize(this.getSize().width, this.getSize().height - n);
            this.resizeParent(-n);
        } else {
            this.validate();
        }
    }

    private void resizeParent(int n) {
        Container container = this.getParent();
        while (container != null && !(container instanceof ResourcePickerDlg)) {
            container = container.getParent();
        }
        if (container != null) {
            Dimension dimension = container.getSize();
            container.setSize(dimension.width, dimension.height + n);
            ((ResourcePickerDlg)container).validate();
        }
    }

    public String getSearchType() {
        String string = null;
        String string2 = (String)this._puSearchGroup.getSelectedItem();
        if (string2.equals(this._objectClassLookup.get(KEY_USERS))) {
            string = KEY_USERS;
        } else if (string2.equals(this._objectClassLookup.get(KEY_ADMINISTRATORS))) {
            string = KEY_ADMINISTRATORS;
        } else if (string2.equals(this._objectClassLookup.get(KEY_GROUPS))) {
            string = KEY_GROUPS;
        } else if (string2.equals(this._objectClassLookup.get(KEY_USERS_GROUPS))) {
            string = KEY_USERS_GROUPS;
        } else if (string2.equals(this._objectClassLookup.get(KEY_SERVERS))) {
            string = KEY_SERVERS;
        }
        return string;
    }

    public String getFilterString() {
        String string = "";
        String string2 = "";
        String string3 = (String)this._puSearchGroup.getSelectedItem();
        int n = 0;
        while (n < this._iDisplayCount) {
            SearchParameter searchParameter = this._p[n];
            String string4 = "";
            String string5 = searchParameter.getAttributeName();
            String string6 = searchParameter.getCondition();
            String string7 = searchParameter.getTextValue();
            if (string7 != null && !string7.equals("")) {
                if (string6.equals(searchParameter.getCondition(KEY_CONTAINS))) {
                    string4 = string7 == "" || string7.equals("*") ? "(" + string5 + "=*)" : (string7.charAt(0) == '*' || string7.charAt(string7.length() - 1) == '*' ? "(" + string5 + "=" + string7 + ")" : "(" + string5 + "=*" + string7 + "*)");
                } else if (string6.equals(searchParameter.getCondition(KEY_EQUALS))) {
                    string4 = "(" + string5 + "=" + string7 + ")";
                } else if (string6.equals(searchParameter.getCondition(KEY_NOT_EQUALS))) {
                    string4 = "(!(" + string5 + "=" + string7 + "))";
                }
                string = n != 0 ? "(&" + string4 + string + ")" : string4;
            }
            ++n;
        }
        if (string.equals("")) {
            if (string3.equals(this._objectClassLookup.get(KEY_USERS))) {
                string2 = "(objectclass=person)";
            } else if (string3.equals(this._objectClassLookup.get(KEY_ADMINISTRATORS))) {
                string2 = "(objectclass=person)";
            } else if (string3.equals(this._objectClassLookup.get(KEY_GROUPS))) {
                string2 = "(objectclass=groupofuniquenames)";
            } else if (string3.equals(this._objectClassLookup.get(KEY_USERS_GROUPS))) {
                string2 = "(|(objectclass=person)(objectclass=groupofuniquenames))";
            } else if (string3.equals(this._objectClassLookup.get(KEY_SERVERS))) {
                string2 = "(objectclass=netscapeserver)";
            }
        } else if (string3.equals(this._objectClassLookup.get(KEY_USERS))) {
            string2 = "(&(objectclass=person)" + string + ")";
        } else if (string3.equals(this._objectClassLookup.get(KEY_ADMINISTRATORS))) {
            string2 = "(&(objectclass=person)" + string + ")";
        } else if (string3.equals(this._objectClassLookup.get(KEY_GROUPS))) {
            string2 = "(&(objectclass=groupofuniquenames)" + string + ")";
        } else if (string3.equals(this._objectClassLookup.get(KEY_USERS_GROUPS))) {
            string2 = "(&(|(objectclass=person)(objectclass=groupofuniquenames))" + string + ")";
        } else if (string3.equals(this._objectClassLookup.get(KEY_SERVERS))) {
            string2 = "(&(objectclass=netscapeserver)" + string + ")";
        }
        Debug.println("Advanced Search: " + string2);
        return string2;
    }

    public void help() {
        Help help = new Help(this._resource);
        help.contextHelp("ug", "AdvancedSearch");
    }
}

