/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.customview;

import com.netscape.management.client.ResourceCellRenderer;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UITools;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class EditDialog
extends GenericDialog {
    JTree defaultTree;
    JTree customTree;
    TreeModel customTreeModel;
    JPanel mainPanel;
    private JTextField viewNameField;

    static String i18n(String string) {
        return TopologyInitializer._resource.getString("customview", string);
    }

    public EditDialog(JFrame jFrame, TreeModel treeModel, TreeModel treeModel2, String string) {
        super(jFrame, EditDialog.i18n("EditView"), 11);
        this.customTreeModel = treeModel2;
        this.getContentPane().add(this.createDialogPanel(treeModel, treeModel2, string));
    }

    private JComponent createDialogPanel(TreeModel treeModel, TreeModel treeModel2, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(EditDialog.i18n("DefaultView"));
        UITools.constrain(jPanel, jLabel, 0, 0, 1, 1, 1.0, 0.0, 13, 2, 0, 0, 6, 0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(UITools.createLoweredBorder());
        this.defaultTree = new JTree(treeModel);
        this.defaultTree.setToolTipText(EditDialog.i18n("defaultTree_tt"));
        this.defaultTree.setRootVisible(false);
        this.defaultTree.setShowsRootHandles(false);
        this.defaultTree.setCellRenderer(new ResourceCellRenderer());
        this.defaultTree.expandRow(0);
        jScrollPane.getViewport().add(this.defaultTree);
        UITools.constrain(jPanel, jScrollPane, 0, 1, 1, 1, 1.0, 1.0, 13, 1, 0, 0, 0, 0);
        JButton jButton = ButtonFactory.createButton(EditDialog.i18n("Copy"), new CopyButtonActionListener(), "COPY");
        jButton.setToolTipText(EditDialog.i18n("copy_tt"));
        jButton.setIcon(ButtonFactory.RIGHT_ICON);
        jButton.setHorizontalTextPosition(2);
        jButton.setEnabled(false);
        this.defaultTree.addTreeSelectionListener(new ButtonTreeSelectionListener(jButton));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.viewNameField = new JTextField(string);
        this.viewNameField.setToolTipText(EditDialog.i18n("viewName_tt"));
        UITools.constrain(jPanel2, this.viewNameField, 1, 0, 1, 1, 1.0, 0.0, 13, 2, 0, 0, 6, 0);
        treeModel2.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                EditDialog.this.setOKButtonEnabled(EditDialog.this.customTree.getRowCount() > 0);
            }
        });
        this.customTree = new JTree(treeModel2);
        this.customTree.setToolTipText(EditDialog.i18n("customTree_tt"));
        this.customTree.setRootVisible(false);
        this.customTree.setShowsRootHandles(false);
        this.customTree.setCellRenderer(new ResourceCellRenderer());
        this.setOKButtonEnabled(this.customTree.getRowCount() > 0);
        JScrollPane jScrollPane2 = new JScrollPane(this.customTree);
        UITools.constrain(jPanel2, jScrollPane2, 1, 1, 1, 1, 1.0, 1.0, 13, 1, 0, 0, 0, 0);
        JButton jButton2 = ButtonFactory.createButton(EditDialog.i18n("RemoveView"), new RemoveButtonActionListener(), "REMOVE");
        jButton2.setToolTipText(EditDialog.i18n("removeView_tt"));
        jButton2.setIcon(ButtonFactory.LEFT_ICON);
        jButton2.setHorizontalTextPosition(4);
        jButton2.setEnabled(false);
        ButtonFactory.resizeButtons(jButton, jButton2);
        this.customTree.addTreeSelectionListener(new ButtonTreeSelectionListener(jButton2));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        UITools.constrain(jPanel3, new JPanel(), 0, 0, 1, 1, 0.0, 1.0, 11, 3, 0, 0, 0, 0);
        UITools.constrain(jPanel3, jButton, 0, 1, 1, 1, 1.0, 0.0, 15, 2, 0, 0, 6, 0);
        UITools.constrain(jPanel3, jButton2, 0, 2, 1, 1, 1.0, 0.0, 11, 2, 0, 0, 0, 0);
        UITools.constrain(jPanel3, new JPanel(), 0, 3, 1, 1, 0.0, 1.0, 11, 3, 0, 0, 0, 0);
        this.mainPanel = new JPanel(new GridBagLayout());
        UITools.constrain(this.mainPanel, jPanel, 0, 0, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 6, 6);
        UITools.constrain(this.mainPanel, jPanel3, 1, 0, 1, 1, 0.0, 1.0, 11, 1, 0, 0, 6, 0);
        UITools.constrain(this.mainPanel, jPanel2, 2, 0, 1, 1, 1.0, 1.0, 11, 1, 0, 6, 6, 0);
        this.mainPanel.setPreferredSize(new Dimension(500, 250));
        return this.mainPanel;
    }

    protected void helpInvoked() {
        ConsoleHelp.showContextHelp("customview-EditDialogHelp");
    }

    public String getViewName() {
        return this.viewNameField.getText().trim();
    }

    public void setNameFieldFocused() {
        this.setFocusComponent(this.viewNameField);
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = EditDialog.this.customTree.getSelectionPaths();
            int n = 0;
            while (n < treePathArray.length) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                if (defaultMutableTreeNode != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    defaultMutableTreeNode2.remove(defaultMutableTreeNode);
                    TreeModel treeModel = EditDialog.this.customTreeModel;
                    if (treeModel instanceof ResourceModel) {
                        ((ResourceModel)treeModel).fireTreeStructureChanged((ResourceObject)defaultMutableTreeNode2);
                    }
                }
                ++n;
            }
        }
    }

    class CopyButtonActionListener
    implements ActionListener {
        CopyButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = EditDialog.this.defaultTree.getSelectionPaths();
            int n = 0;
            while (n < treePathArray.length) {
                ResourceObject resourceObject = (ResourceObject)treePathArray[n].getLastPathComponent();
                if (resourceObject != null) {
                    TreeModel treeModel = EditDialog.this.customTreeModel;
                    ResourceObject resourceObject2 = (ResourceObject)treeModel.getRoot();
                    if (resourceObject instanceof Cloneable) {
                        resourceObject2.add((MutableTreeNode)resourceObject.clone());
                        if (treeModel instanceof ResourceModel) {
                            ((ResourceModel)treeModel).fireTreeStructureChanged(resourceObject2);
                        }
                        EditDialog.this.mainPanel.repaint();
                        EditDialog.this.mainPanel.validate();
                    } else {
                        Debug.println("Tree Node not Clonable: " + resourceObject);
                    }
                }
                ++n;
            }
        }
    }

    class ButtonTreeSelectionListener
    implements TreeSelectionListener {
        JButton _button;

        public ButtonTreeSelectionListener(JButton jButton) {
            this._button = jButton;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            JTree jTree = (JTree)treeSelectionEvent.getSource();
            int n = jTree.getSelectionCount();
            this._button.setEnabled(n > 0);
        }
    }
}

