/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceModel;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.IProductObject;
import com.netscape.management.client.topology.InstalledProduct;
import com.netscape.management.client.topology.MergeConfigDialog;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.topology.ServerLocNode;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.topology.TopologyModel;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.URLByteEncoder;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;

public class AdminGroupNode
extends ServerLocNode
implements IMenuInfo,
INodeInfo {
    private static final String MENU_MERGE = "MERGE";
    private static final String MENU_OBJECT_CREATE_CATEGORY = "OBJECT_CREATE_CATEGORY";
    private static final String MENU_CONTEXT_CREATE_CATEGORY = "CONTEXT_CREATE_CATEGORY";
    private boolean _enableCreateMenuCategory;
    private InstalledProduct[] _installedProducts;
    private static RemoteImage _icon = null;
    private static ResourceSet _resource;
    private Vector _changeListeners = new Vector();
    private ConsoleInfo _consoleInfo;
    private String _hostName;
    private String _description;
    private String _groupName;
    private String _installPath;
    private String _adminOS;
    protected NodeData[] _nodeData;
    protected NodeData _nameNodeData;
    protected NodeDataPanel _nodeDataPanel;
    protected IPage _viewInstance;
    private static KeyAdapter _tmpGrabKey;
    private static MouseAdapter _tmpGrabMouse;

    public AdminGroupNode(ServiceLocator serviceLocator, LDAPEntry lDAPEntry) {
        super(serviceLocator);
        _resource = new ResourceSet("com.netscape.management.client.topology.topology");
        _icon = new RemoteImage(_resource.getString("tree", "folderIcon"));
        _icon.setDescription(_resource.getString("tree", "folderIcon-description"));
        this._consoleInfo = (ConsoleInfo)serviceLocator.getConsoleInfo().clone();
        this.initialize(lDAPEntry);
        this._installedProducts = null;
        this.initializeMenuItems();
    }

    private void initialize(LDAPEntry lDAPEntry) {
        String string;
        Object object;
        this.setIcon(_icon);
        if (lDAPEntry == null) {
            Debug.println("ERROR AdminGroupNode.initialize: LDAPEntry is null");
            return;
        }
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        this.setDN(lDAPEntry.getDN());
        this.setName(LDAPUtil.flatting(lDAPEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale())));
        while (enumeration.hasMoreElements()) {
            object = (LDAPAttribute)enumeration.nextElement();
            string = object.getName();
            if (string.equalsIgnoreCase("nsAdminGroupName")) {
                this._groupName = LDAPUtil.flatting(object.getStringValues());
                this.setName(LDAPUtil.flatting(object.getStringValues()));
                continue;
            }
            if (string.equalsIgnoreCase("description")) {
                this._description = LDAPUtil.flatting(object.getStringValues());
                continue;
            }
            if (!string.equalsIgnoreCase("nsConfigRoot")) continue;
            this._installPath = LDAPUtil.flatting(object.getStringValues());
        }
        object = this.getServiceLocator().getAdminServer(this.getDN());
        if (object != null) {
            try {
                string = AdminGroupNode.findAdminURL(this._consoleInfo, (String)object);
                this._consoleInfo.setAdminURL(string);
            }
            catch (Exception exception) {
                this._consoleInfo.setAdminURL("");
                Debug.println(0, "ERROR AdminGroupNode.initialize: can not determine adminURL, possibly corrupted DS config data");
            }
        }
        this._nodeData = new NodeData[]{this._nameNodeData = new NodeData("nsAdminGroupName", _resource.getString("ServerObject", "nsAdminGroupName"), this.getName(), true, true), new NodeData("description", _resource.getString("ServerObject", "description"), this._description, true), new NodeData("nsInstalledLocation", _resource.getString("ServerObject", "nsInstalledLocation"), this._installPath, false)};
    }

    private void initializeMenuItems() {
        this._enableCreateMenuCategory = false;
    }

    private void getInstalledProducts() {
        LDAPSearchResults lDAPSearchResults = this.getApplications();
        if (lDAPSearchResults == null) {
            return;
        }
        Vector<InstalledProduct> vector = new Vector<InstalledProduct>();
        try {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string = LDAPUtil.flatting(lDAPEntry.getAttribute("nsproductname", LDAPUtil.getLDAPAttributeLocale()));
                if (string == null || string.equals("")) {
                    Debug.println("TRACE AdminGroupNode.getInstalledProducts: no value for nsproductname attribute.");
                    continue;
                }
                String string2 = LDAPUtil.flatting(lDAPEntry.getAttribute("nsnickname", LDAPUtil.getLDAPAttributeLocale()));
                if (string2 == null || string2.equals("")) {
                    Debug.println("TRACE AdminGroupNode.getInstalledProducts: no value for nsnickname attribute.");
                    continue;
                }
                String string3 = LDAPUtil.flatting(lDAPEntry.getAttribute("nsservercreationclassname", LDAPUtil.getLDAPAttributeLocale()));
                if (string3 != null && !string3.equals("")) {
                    this._enableCreateMenuCategory = true;
                }
                String string4 = LDAPUtil.flatting(lDAPEntry.getAttribute("description", LDAPUtil.getLDAPAttributeLocale()));
                vector.addElement(new InstalledProduct(string, string2, string3, string4));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vector.size() == 0) {
            Debug.println("TRACE AdminGroupNode.getInstalledProducts: this admin group contains no products: " + this.getDN());
            return;
        }
        this._installedProducts = new InstalledProduct[vector.size()];
        vector.copyInto(this._installedProducts);
    }

    public Vector getServerIDs() {
        Vector<String> vector = new Vector<String>();
        ServiceLocator serviceLocator = this.getServiceLocator();
        LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)serviceLocator.getProductType(this.getDN());
        try {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPSearchResults lDAPSearchResults2 = serviceLocator.getSIE(lDAPEntry.getDN());
                while (lDAPSearchResults2.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = lDAPSearchResults2.next();
                    String string = LDAPUtil.flatting(lDAPEntry2.getAttribute("nsserverid", LDAPUtil.getLDAPAttributeLocale()));
                    if (string == null || string.equals("")) continue;
                    vector.addElement(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public void select(IPage iPage) {
        this._viewInstance = iPage;
        if (!(iPage instanceof ResourcePage)) {
            return;
        }
        ResourcePage resourcePage = (ResourcePage)iPage;
        IResourceObject[] iResourceObjectArray = resourcePage.getSelection();
        ResourceModel resourceModel = (ResourceModel)resourcePage.getModel();
        if (iResourceObjectArray != null && iResourceObjectArray.length == 1) {
            if (this._enableCreateMenuCategory) {
                resourceModel.fireEnableMenuItem(iPage, MENU_OBJECT_CREATE_CATEGORY);
                resourceModel.fireEnableMenuItem(iPage, MENU_CONTEXT_CREATE_CATEGORY);
            } else {
                resourceModel.fireDisableMenuItem(iPage, MENU_OBJECT_CREATE_CATEGORY);
                resourceModel.fireDisableMenuItem(iPage, MENU_CONTEXT_CREATE_CATEGORY);
            }
        } else {
            resourceModel.fireDisableMenuItem(iPage, MENU_OBJECT_CREATE_CATEGORY);
            resourceModel.fireDisableMenuItem(iPage, MENU_CONTEXT_CREATE_CATEGORY);
        }
        resourceModel.fireEnableMenuItem(iPage, MENU_MERGE);
    }

    public void setAdminOS(String string) {
        this._adminOS = string;
    }

    public void reload() {
        Debug.println("rsptime", "Reload Admin Group node ...");
        Vector vector = new Vector();
        this.removeAllChildren();
        super.reload();
        ServiceLocator serviceLocator = this.getServiceLocator();
        if (this._adminOS != null) {
            this._consoleInfo.setAdminOS(this._adminOS);
        }
        LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)serviceLocator.getProductType(this.getDN());
        try {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPSearchResults lDAPSearchResults2 = serviceLocator.getSIE(lDAPEntry.getDN());
                while (lDAPSearchResults2.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = lDAPSearchResults2.next();
                    ServerNode serverNode = new ServerNode(this._consoleInfo, serviceLocator, lDAPEntry2);
                    if (this.searchChildByName(serverNode.getName()) != null) continue;
                    this.add((MutableTreeNode)serverNode);
                }
            }
            this._fLoaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Debug.println("rsptime", "Admin Group node reloaded");
    }

    private boolean isAdminServer(LDAPEntry lDAPEntry) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string;
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String string2 = lDAPAttribute.getName();
            if (!string2.equalsIgnoreCase("cn") || (string = LDAPUtil.flatting(lDAPAttribute.getStringValues())).indexOf("admin") == -1) continue;
            return true;
        }
        return false;
    }

    public static String findAdminURL(ConsoleInfo consoleInfo, String string) {
        Object object;
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        try {
            object = consoleInfo.getLDAPConnection();
            if (object != null) {
                LDAPAttributeSet lDAPAttributeSet;
                string4 = "cn=configuration," + string;
                LDAPEntry lDAPEntry = object.read(string4);
                if (lDAPEntry != null) {
                    lDAPAttributeSet = lDAPEntry.getAttributeSet();
                    Enumeration enumeration = lDAPAttributeSet.getAttributes();
                    while (enumeration.hasMoreElements()) {
                        String string5;
                        LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                        String string6 = lDAPAttribute.getName();
                        if (string6.equalsIgnoreCase("nsServerPort")) {
                            string3 = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                            continue;
                        }
                        if (string6.equalsIgnoreCase("nsServerAddress")) {
                            string2 = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                            continue;
                        }
                        if (!string6.equalsIgnoreCase("nsServerSecurity") || !(string5 = LDAPUtil.flatting(lDAPAttribute.getStringValues())).equalsIgnoreCase("on")) continue;
                        bl = true;
                    }
                }
                if (string2 == null || string2.trim().length() == 0) {
                    string4 = string;
                    lDAPAttributeSet = object.read(string4, new String[]{"serverhostname"});
                    if (lDAPAttributeSet == null) {
                        Debug.println(0, "AdminGroupNode.findAdminURL: could not get serverhostname from " + string);
                        return null;
                    }
                    string2 = LDAPUtil.flatting(lDAPAttributeSet.getAttribute("serverhostname"));
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("AdminGroupNode.findAdminURL: LDAP Error: " + (Object)((Object)lDAPException) + " try to open:" + string4);
            return null;
        }
        object = "http";
        if (bl) {
            object = (String)object + "s";
        }
        object = string2.indexOf(":") != -1 ? (String)object + "://" + "[" + string2 + "]" + ":" + string3 + "/" : (String)object + "://" + string2 + ":" + string3 + "/";
        return object;
    }

    public String[] getMenuCategoryIDs() {
        if (this._installedProducts == null) {
            this.getInstalledProducts();
        }
        if (this._enableCreateMenuCategory) {
            return new String[]{"OBJECT", "CONTEXT", MENU_OBJECT_CREATE_CATEGORY, MENU_CONTEXT_CREATE_CATEGORY};
        }
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("OBJECT")) {
            return new IMenuItem[]{new MenuItemText(MENU_MERGE, _resource.getString("menu", "MergeConfig"), "", true), new MenuItemCategory(MENU_OBJECT_CREATE_CATEGORY, _resource.getString("menu", "CreateServer"), this._enableCreateMenuCategory)};
        }
        if (string.equals("CONTEXT")) {
            return new IMenuItem[]{new MenuItemText(MENU_MERGE, _resource.getString("menu", "MergeConfig"), "", true), new MenuItemCategory(MENU_CONTEXT_CREATE_CATEGORY, _resource.getString("menu", "CreateServer"), this._enableCreateMenuCategory)};
        }
        if (string.equals(MENU_OBJECT_CREATE_CATEGORY) || string.equals(MENU_CONTEXT_CREATE_CATEGORY)) {
            if (this._installedProducts == null) {
                this.getInstalledProducts();
            }
            if (this._installedProducts != null) {
                Vector<MenuItemText> vector = new Vector<MenuItemText>();
                int n = 0;
                while (n < this._installedProducts.length) {
                    String string2 = this._installedProducts[n].getCreationClassName();
                    if (string2 != null && !string2.equals("")) {
                        vector.addElement(new MenuItemText(this._installedProducts[n].getNickname(), this._installedProducts[n].getName(), this._installedProducts[n].getDescription()));
                    }
                    ++n;
                }
                if (vector.size() != 0) {
                    Object[] objectArray = new IMenuItem[vector.size()];
                    vector.copyInto(objectArray);
                    return objectArray;
                }
            }
        }
        return null;
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(MENU_MERGE)) {
            MergeConfigDialog mergeConfigDialog = new MergeConfigDialog(this.getDN(), this._consoleInfo, this, iPage);
            mergeConfigDialog.show();
        } else if (this._installedProducts != null) {
            int n = 0;
            while (n < this._installedProducts.length) {
                if (iMenuItem.getID().equals(this._installedProducts[n].getNickname())) {
                    Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)this._consoleInfo, (String)this._installedProducts[n].getCreationClassName());
                    if (clazz == null) break;
                    try {
                        IProductObject iProductObject = (IProductObject)clazz.newInstance();
                        iProductObject.initialize((ConsoleInfo)this._consoleInfo.clone());
                        CreateThread createThread = new CreateThread(this._consoleInfo, iPage, this.getDN(), iProductObject, _resource);
                        createThread.start();
                        break;
                    }
                    catch (Exception exception) {
                        SuiOptionPane.showMessageDialog((Component)this._consoleInfo.getFrame(), (Object)MessageFormat.format(_resource.getString("ServerRootPromptDialog", "couldNotInstantiate"), clazz.getName(), exception), (String)_resource.getString("ServerRootPromptDialog", "CreateTitle"), (int)0);
                        ModalDialogUtil.sleep();
                        ModalDialogUtil.raise(iPage.getFramework().getJFrame());
                        return;
                    }
                }
                ++n;
            }
        }
    }

    private synchronized void reloadModel(IPage iPage) {
        IResourceModel iResourceModel;
        if (iPage instanceof ResourcePage && (iResourceModel = ((ResourcePage)iPage).getModel()) instanceof TopologyModel) {
            TopologyModel topologyModel = (TopologyModel)iResourceModel;
            try {
                Thread.sleep(500L);
                topologyModel.refreshTree(iPage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Component getCustomPanel() {
        this._nodeDataPanel = new NodeDataPanel(this.getIcon(), this.getName(), this);
        this._nodeDataPanel.setHelpTopic("admin", "topology-groupnode");
        return this._nodeDataPanel;
    }

    public void unselect(IPage iPage) {
        this._nodeDataPanel = null;
    }

    public void replaceNodeDataValue(NodeData nodeData) {
        int n = 0;
        while (n < this._nodeData.length) {
            if (this._nodeData[n].getName().equals(nodeData.getName())) {
                this._nodeData[n].setValue(nodeData.getValue());
                return;
            }
            ++n;
        }
    }

    public int getNodeDataCount() {
        return this._nodeData.length;
    }

    public NodeData getNodeData(int n) {
        return this._nodeData[n];
    }

    public void actionNodeDataChanged(NodeData nodeData) {
        this.replaceNodeDataValue(nodeData);
        String string = this.getDN();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(nodeData.getID(), (String)nodeData.getValue());
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        LDAPConnection lDAPConnection = this.getServiceLocator().getConnection();
        if (nodeData.getID().equals("nsAdminGroupName")) {
            ResourcePage resourcePage;
            this.setName((String)nodeData.getValue());
            this._nameNodeData.setValue(nodeData.getValue());
            this._nodeDataPanel.setTitle((String)nodeData.getValue());
            if (this._viewInstance != null && this._viewInstance instanceof ResourcePage && (resourcePage = (ResourcePage)this._viewInstance).getTreeModel() instanceof ResourceModel) {
                ((ResourceModel)resourcePage.getTreeModel()).fireTreeNodeChanged(this);
            }
        }
        try {
            lDAPConnection.modify(string, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 16) {
                try {
                    lDAPModification = new LDAPModification(0, lDAPAttribute);
                    lDAPConnection.modify(string, lDAPModification);
                }
                catch (LDAPException lDAPException2) {
                    Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException2));
                }
            }
            Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.removeElement(changeListener);
    }

    public LDAPSearchResults getApplications() {
        LDAPSearchResults lDAPSearchResults = null;
        String string = "(ObjectClass=nsApplication)";
        try {
            LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
            if (lDAPConnection != null) {
                lDAPSearchResults = lDAPConnection.search(this.getDN(), 1, string, null, false);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ERROR AdminGroupNode.getApplications: LDAP search failed: " + string);
            return null;
        }
        return lDAPSearchResults;
    }

    protected String[] getLegacyServerList(IPage iPage, String string) {
        String string2 = this._consoleInfo.getAdminURL();
        if (string2 == null || string2.equals("")) {
            Debug.println("ERROR AdminGroupNode.getLegacyServerList: admin URL is not available.");
            return null;
        }
        String string3 = new String(string2 + "admin-serv/tasks/operation/listOldServers?" + "oldServerRoot=" + URLByteEncoder.encodeUTF8(string));
        Debug.println("TRACE AdminGroupNode.getLegacyServerList: queryString = " + string3);
        try {
            URL uRL = new URL(string3);
            AdmTask admTask = new AdmTask(uRL, this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            Cursor cursor = iPage.getFramework().getCursor();
            iPage.getFramework().setCursor(Cursor.getPredefinedCursor(3));
            int n = admTask.exec();
            iPage.getFramework().setCursor(cursor);
            if (n == 0) {
                Debug.println("TRACE AdminGroupNode.getLegacyServerList: CGI succeeded!");
                String string4 = (String)admTask.getResult("SR");
                if (string4 == null || string4.equals("")) {
                    Debug.println("TRACE AdminGroupNode.getLegacyServerList: no servers found");
                    return null;
                }
                Vector<String> vector = new Vector<String>();
                StringReader stringReader = new StringReader(string4);
                StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
                streamTokenizer.wordChars(95, 95);
                int n2 = streamTokenizer.nextToken();
                while (n2 != -1) {
                    if (n2 == -3) {
                        Debug.println("TRACE AdminGroupNode.getLegacyServerList: server token = " + streamTokenizer.sval);
                        vector.addElement(new String(streamTokenizer.sval));
                    } else {
                        Debug.println("ERROR AdminGroupNode.getLegacyServerList: unexpected server value");
                    }
                    n2 = streamTokenizer.nextToken();
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            Debug.println("ERROR AdminGroupNode.getLegacyServerList: CGI status = " + n);
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println("ERROR AdminGroupNode.getLegacyServerList: Bad URL: " + malformedURLException);
            return null;
        }
        catch (Exception exception) {
            Debug.println("ERROR AdminGroupNode.getLegacyServerList: exception: " + exception);
            return null;
        }
    }

    private synchronized void setGrabAllInput(IPage iPage, boolean bl) {
        JFrame jFrame = iPage.getFramework().getJFrame();
        Component component = jFrame.getGlassPane();
        if (bl) {
            component.addKeyListener(_tmpGrabKey);
            component.addMouseListener(_tmpGrabMouse);
            component.setVisible(true);
        } else {
            component.removeKeyListener(_tmpGrabKey);
            component.removeMouseListener(_tmpGrabMouse);
            component.setVisible(false);
        }
    }

    private synchronized void setBusyIndicator(IPage iPage, boolean bl, String string) {
        this.setGrabAllInput(iPage, bl);
        if (!(iPage instanceof ResourcePage)) {
            return;
        }
        ResourcePage resourcePage = (ResourcePage)iPage;
        IResourceObject[] iResourceObjectArray = resourcePage.getSelection();
        ResourceModel resourceModel = (ResourceModel)resourcePage.getModel();
        if (bl) {
            iPage.getFramework().setCursor(Cursor.getPredefinedCursor(3));
            resourceModel.fireChangeStatusItemState(null, "StatusItemText", string);
            resourceModel.fireChangeStatusItemState(null, "StatusItemProgress", StatusItemProgress.STATE_BUSY);
        } else {
            iPage.getFramework().setCursor(Cursor.getPredefinedCursor(0));
            resourceModel.fireChangeStatusItemState(null, "StatusItemText", string);
            resourceModel.fireChangeStatusItemState(null, "StatusItemProgress", new Integer(0));
        }
    }

    static {
        _tmpGrabKey = new KeyAdapter(){};
        _tmpGrabMouse = new MouseAdapter(){};
    }

    class CreateThread
    extends Thread {
        ConsoleInfo _consoleInfo;
        IPage _viewInstance;
        String _currentDN;
        IProductObject _productHandle;
        ResourceSet _resource;

        public CreateThread(ConsoleInfo consoleInfo, IPage iPage, String string, IProductObject iProductObject, ResourceSet resourceSet) {
            this._consoleInfo = consoleInfo;
            this._viewInstance = iPage;
            this._currentDN = string;
            this._productHandle = iProductObject;
            this._resource = resourceSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block4: {
                    try {
                        AdminGroupNode.this.setBusyIndicator(this._viewInstance, true, this._resource.getString("status", "creatingServer"));
                        if (!this._productHandle.createNewInstance(this._currentDN)) break block4;
                        AdminGroupNode.this.setBusyIndicator(this._viewInstance, false, "");
                        AdminGroupNode.this.setBusyIndicator(this._viewInstance, true, this._resource.getString("status", "refreshingTopology"));
                        AdminGroupNode.this.reloadModel(this._viewInstance);
                        AdminGroupNode.this.syncTaskSIEData(this._consoleInfo);
                    }
                    catch (Exception exception) {
                        Object var3_2 = null;
                        AdminGroupNode.this.setBusyIndicator(this._viewInstance, false, "");
                        return;
                    }
                }
                Object var3_1 = null;
                AdminGroupNode.this.setBusyIndicator(this._viewInstance, false, "");
                return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                AdminGroupNode.this.setBusyIndicator(this._viewInstance, false, "");
                throw throwable;
            }
        }
    }
}

