/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.security.CertificateInfoPanels;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Frame;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import netscape.ldap.LDAPDN;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

class ViewCertificateDialog
extends AbstractDialog
implements SuiConstants {
    private JTabbedPane infoPane = new JTabbedPane();
    private ResourceSet _resource = new ResourceSet("com.netscape.management.client.security.securityResource");
    private JSplitPane certInfoView;
    private static final String digits = "0123456789abcdef";

    private String i18n(String string) {
        return this._resource.getString("ViewCertificateDialog", string);
    }

    public ViewCertificateDialog(Frame frame, X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        super(frame, "", true, 1);
        this.setTitle(this._resource.getString("CertificateDetailDialog", "title"));
        this.getContentPane().add(this.infoPane);
        this.setCertificate(x509Certificate, validityStatus);
        this.setMinimumSize(400, 400);
        if (frame == null) {
            ModalDialogUtil.setCenteredDialog(this);
        }
        this.pack();
    }

    protected void okInvoked() {
        this.setVisible(false);
    }

    private void extractNameFromDN(String string, Hashtable hashtable) {
        Debug.println(6, "ViewCertificateDialog.extractNameFromDN: dn = " + string);
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    Debug.println(6, "ViewCertificateDialog.extractNameFromDN RDN: " + stringArray[n]);
                    int n2 = stringArray[n].indexOf(61);
                    String string2 = stringArray[n].substring(0, n2);
                    String string3 = stringArray[n].substring(n2 + 1, stringArray[n].length());
                    hashtable.put(string2.trim(), string3.trim());
                } else {
                    Debug.println(6, "ViewCertificateDialog.extractNameFromDN: ERROR - Unable to read RDN");
                }
                ++n;
            }
        } else {
            Debug.println(6, "ViewCertificateDialog.extractNameFromDN: ERROR - Unable to read DN");
        }
    }

    private String hexify(byte[] byArray) {
        if (byArray.length == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(digits.charAt(byArray[n] >> 4 & 0xF));
            stringBuffer.append(digits.charAt(byArray[n] & 0xF));
            if (n != byArray.length) {
                stringBuffer.append(':');
            } else {
                stringBuffer.append('0');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setCertificate(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            Object object;
            hashtable.put("SUBJECT_DN", x509Certificate.getSubjectDN().toString());
            hashtable.put("ISSUER_DN", x509Certificate.getIssuerDN().toString());
            hashtable.put("SERIAL", x509Certificate.getSerialNumber().toString());
            hashtable.put("VERSION", Integer.toString(x509Certificate.getVersion()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
            hashtable.put("BEFOREDATE", simpleDateFormat.format(x509Certificate.getNotBefore()));
            hashtable.put("AFTERDATE", simpleDateFormat.format(x509Certificate.getNotAfter()));
            hashtable.put("SIGNATURE", x509Certificate.getSigAlgName());
            hashtable.put("KEYTYPE", x509Certificate.getPublicKey().getAlgorithm());
            Hashtable hashtable2 = new Hashtable();
            Hashtable hashtable3 = new Hashtable();
            this.extractNameFromDN(x509Certificate.getSubjectDN().toString(), hashtable2);
            this.extractNameFromDN(x509Certificate.getIssuerDN().toString(), hashtable3);
            hashtable.put("SUBJECT", hashtable2);
            hashtable.put("ISSUER", hashtable3);
            Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
            Enumeration enumeration = validityStatus.getReasons();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                object = (SSLCertificateApprovalCallback.ValidityItem)enumeration.nextElement();
                String string = "";
                switch (object.getReason()) {
                    case -8178: {
                        string = this.i18n("BAD_KEY");
                        break;
                    }
                    case -8182: {
                        string = this.i18n("BAD_SIGNATURE");
                        break;
                    }
                    case -8156: {
                        string = this.i18n("CA_CERT_INVALID");
                        break;
                    }
                    case -8080: {
                        string = this.i18n("CERT_NOT_IN_NAME_SPACE");
                        break;
                    }
                    case -8077: {
                        string = this.i18n("CERT_STATUS_SERVER_ERROR");
                        break;
                    }
                    case -8162: {
                        string = this.i18n("EXPIRED_ISSUER_CERTIFICATE");
                        break;
                    }
                    case -8101: {
                        string = this.i18n("INADEQUATE_CERT_TYPE");
                        break;
                    }
                    case -8102: {
                        string = this.i18n("INADEQUATE_KEY_USAGE");
                        break;
                    }
                    case -8155: {
                        string = this.i18n("PATH_LEN_CONSTRAINT_INVALID");
                        break;
                    }
                    case -8180: {
                        string = this.i18n("REVOKED_CERTIFICATE");
                        break;
                    }
                    case -8179: {
                        string = this.i18n("UNKNOWN_ISSUER");
                        break;
                    }
                    case -8171: {
                        string = this.i18n("UNTRUSTED_CERT");
                        break;
                    }
                    case -8172: {
                        string = this.i18n("UNTRUSTED_ISSUER");
                        break;
                    }
                    case -12276: {
                        string = this.i18n("BAD_CERT_DOMAIN");
                        break;
                    }
                    default: {
                        string = this.i18n("UNKOWN");
                    }
                }
                hashtable4.put(Integer.toString(object.getReason()), string);
                Debug.println("ViewCertificateDialog.getCertificate: ERROR = " + object.getReason() + ":" + string);
            }
            hashtable.put("REASONS", hashtable4);
            object = new CertificateInfoPanels(hashtable);
            this.infoPane.add(this._resource.getString("CertificateDetailDialog", "generalTitle"), ((CertificateInfoPanels)object).getGeneralInfo());
            this.infoPane.add(this._resource.getString("CertificateDetailDialog", "detailTitle"), ((CertificateInfoPanels)object).getDetailInfo());
            Debug.println(9, hashtable.toString());
        }
        catch (Exception exception) {
            SecurityUtil.printException("ViewCertificateDialog::setCertificate(...)", exception);
        }
    }
}

