/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CACertificatePane;
import com.netscape.management.client.security.CRLCertificatePane;
import com.netscape.management.client.security.CertificateList;
import com.netscape.management.client.security.CertificateListPane;
import com.netscape.management.client.security.Parser;
import com.netscape.management.client.security.PromptTokenPasswordDialog;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.security.ServerCertificatePane;
import com.netscape.management.client.security.SetTokenPwdDialog;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CertificateDialog
extends AbstractDialog
implements SuiConstants {
    JComboBox securityDevice;
    String defaultSecurityDevice;
    String password = "";
    PromptTokenPasswordDialog pwdPrompt = null;
    boolean promptForPWD = false;
    JButton changePwd;
    SetTokenPwdDialog setTokenPwdDialog;
    JTabbedPane certTabs;
    ServerCertificatePane serverCertificatePane;
    CACertificatePane caCertificatePane;
    CRLCertificatePane crlCertificatePane;
    CertificateList certList = null;
    String trusted;
    String revoked;
    String server;
    String _sie;
    ConsoleInfo _consoleInfo;
    boolean _initFail = false;
    Frame parentFrame;

    void getCertList() {
        try {
            if (this.pwdPrompt == null) {
                this.pwdPrompt = new PromptTokenPasswordDialog((Component)this, this.securityDevice.getSelectedItem().toString());
            } else {
                this.pwdPrompt.setToken(this.securityDevice.getSelectedItem().toString());
            }
            if (this.promptForPWD) {
                this.pwdPrompt.setPassword("");
                this.pwdPrompt.setVisible(true);
                this.password = this.pwdPrompt.getPassword();
                this.promptForPWD = false;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("formop", "LIST_CERTIFICATE");
            hashtable.put("sie", this._sie);
            hashtable.put("tokenname", this.securityDevice.getSelectedItem().toString());
            hashtable.put("keypwd", this.password);
            AdmTask admTask = new AdmTask(new URL(this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            admTask.setArguments(hashtable);
            admTask.exec();
            Debug.println(admTask.getResultString().toString());
            if (!SecurityUtil.showError(admTask)) {
                this.certList = new CertificateList(admTask.getResultString().toString());
            }
        }
        catch (Exception exception) {
            SecurityUtil.printException("CertificateDialog::getCertList()", exception);
        }
        if (this.certList.needInitInternalToken()) {
            this.setTokenPwdDialog.setVisible(true);
        }
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    void showVisibleCertTab() {
        this.certTabs.remove(this.caCertificatePane);
        this.certTabs.remove(this.crlCertificatePane);
        if (this.securityDevice.getSelectedItem().toString().equals(this.defaultSecurityDevice)) {
            this.certTabs.addTab(this.trusted, this.caCertificatePane);
            this.certTabs.addTab(this.revoked, this.crlCertificatePane);
        }
        SwingUtilities.getRoot(this).validate();
        SwingUtilities.getRoot(this).repaint();
    }

    public CertificateDialog(Frame frame, ConsoleInfo consoleInfo, String string) {
        this(frame, consoleInfo, string, "");
    }

    public void show() {
        if (!this.setTokenPwdDialog.isCancel()) {
            super.show();
        }
    }

    private Vector getSecurityDeviceList() {
        Vector<Object> vector = new Vector<Object>();
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("formop", "LIST_TOKEN");
            hashtable.put("sie", this._sie);
            AdmTask admTask = new AdmTask(new URL(this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            admTask.setArguments(hashtable);
            admTask.exec();
            if (!SecurityUtil.showError(admTask)) {
                Parser parser = new Parser(admTask.getResultString().toString());
                Hashtable hashtable2 = new Hashtable();
                while (parser.hasMoreElement()) {
                    String string = parser.nextToken();
                    if (!string.equals("<TOKENLIST>")) continue;
                    hashtable2 = parser.getTokenObject(string);
                    break;
                }
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.endsWith("_TOKEN")) continue;
                    Hashtable hashtable3 = (Hashtable)hashtable2.get(string);
                    Enumeration enumeration2 = hashtable3.keys();
                    while (enumeration2.hasMoreElements()) {
                        vector.addElement(enumeration2.nextElement());
                    }
                }
            }
        }
        catch (Exception exception) {
            SecurityUtil.printException("CertificateDialog::getSecurityDeviceList()", exception);
            vector.addElement(this.defaultSecurityDevice);
        }
        return vector;
    }

    protected final void refresh() {
        this.getCertList();
        this.serverCertificatePane.setCertData(this.certList.getServerCerts());
        this.caCertificatePane.setCertData(this.certList.getCACerts());
        this.crlCertificatePane.setCertData(this.certList.getCRLCerts());
    }

    protected void helpInvoked() {
        ((CertificateListPane)this.certTabs.getSelectedComponent()).helpInvoked();
    }

    public CertificateDialog(Frame frame, ConsoleInfo consoleInfo, String string, String string2) {
        super(frame, "", true, 12, 0);
        this.parentFrame = frame;
        this._sie = string;
        this._consoleInfo = consoleInfo;
        this.getContentPane().setLayout(new GridBagLayout());
        ResourceSet resourceSet = new ResourceSet("com.netscape.management.client.security.securityResource");
        this.setTitle(resourceSet.getString("CertificateDialog", "title") + " " + string);
        this.trusted = resourceSet.getString("CertificateDialog", "trustedTabLabel");
        this.revoked = resourceSet.getString("CertificateDialog", "revokedTabLabel");
        this.server = resourceSet.getString("CertificateDialog", "serverTabLabel");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("CHANGE_PASSWORD")) {
                    new SetTokenPwdDialog(CertificateDialog.this, CertificateDialog.this._consoleInfo, CertificateDialog.this._sie, false, CertificateDialog.this.securityDevice.getSelectedItem().toString()).setVisible(true);
                }
            }
        };
        this.changePwd = JButtonFactory.create(resourceSet.getString("CertificateDialog", "changePasswordLabel"), actionListener, "CHANGE_PASSWORD");
        this.changePwd.setToolTipText(resourceSet.getString("CertificateDialog", "changePassword_tt"));
        this.changePwd.registerKeyboardAction(actionListener, "CHANGE_PASSWORD", KeyStroke.getKeyStroke(10, 0), 0);
        JLabel jLabel = new JLabel(resourceSet.getString("CertificateDialog", "tokenDialog"));
        this.securityDevice = new JComboBox(this.getSecurityDeviceList());
        this.securityDevice.setEditable(false);
        jLabel.setLabelFor(this.securityDevice);
        this.defaultSecurityDevice = resourceSet.getString("CertificateDialog", "defaultSecurityDevice");
        if (string2.length() == 0 || string2 == null) {
            this.securityDevice.setSelectedItem(this.defaultSecurityDevice);
        } else {
            this.securityDevice.setSelectedItem(this.defaultSecurityDevice);
            if (!this.securityDevice.getSelectedItem().toString().equals(this.defaultSecurityDevice)) {
                this.promptForPWD = true;
            }
        }
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("CHANGE_SECURITY_DEVICE")) {
                    CertificateDialog.this.refresh();
                    if (CertificateDialog.this.securityDevice.getSelectedItem().toString().equals(CertificateDialog.this.defaultSecurityDevice)) {
                        CertificateDialog.this.changePwd.setEnabled(true);
                    } else {
                        CertificateDialog.this.changePwd.setEnabled(false);
                    }
                }
            }
        };
        this.securityDevice.setActionCommand("CHANGE_SECURITY_DEVICE");
        this.securityDevice.addActionListener(actionListener2);
        this.setTokenPwdDialog = new SetTokenPwdDialog(this, consoleInfo, string, true, this.defaultSecurityDevice);
        try {
            this.getCertList();
        }
        catch (Exception exception) {
            SecurityUtil.printException("CertificateDialog::CertificateDialog(...)", exception);
            this._initFail = true;
            return;
        }
        this.certTabs = new JTabbedPane(1);
        this.serverCertificatePane = new ServerCertificatePane(this.certList.getServerCerts(), consoleInfo, string, this.securityDevice.getSelectedItem().toString(), this);
        this.serverCertificatePane.setParentFrame(this.getParentFrame());
        this.caCertificatePane = new CACertificatePane(this.certList.getCACerts(), consoleInfo, string, this.securityDevice.getSelectedItem().toString(), this);
        this.caCertificatePane.setParentFrame(this.getParentFrame());
        this.crlCertificatePane = new CRLCertificatePane(this.certList.getCRLCerts(), consoleInfo, string, this);
        this.certTabs.addTab(this.server, this.serverCertificatePane);
        this.showVisibleCertTab();
        int n = 0;
        GridBagUtil.constrain(this.getContentPane(), jLabel, 0, n, 1, 1, 0.0, 0.0, 11, 0, 0, 0, 6, 6);
        GridBagUtil.constrain(this.getContentPane(), this.securityDevice, 1, n, 1, 1, 1.0, 0.0, 11, 2, 0, 0, 6, 6);
        GridBagUtil.constrain(this.getContentPane(), this.changePwd, 2, n, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 6, 0);
        GridBagUtil.constrain(this.getContentPane(), this.certTabs, 0, ++n, 3, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        this.setMinimumSize(200, 200);
        this.pack();
    }

    public void setVisisble(boolean bl) {
        if (!this._initFail) {
            super.setVisible(bl);
        }
    }
}

