/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.util.JButtonFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public class PopupMenuButton
extends JButton {
    private JPopupMenu _popup;

    public PopupMenuButton(String string, JPopupMenu jPopupMenu) {
        super(string);
        JButtonFactory.initArrowButton(this, 2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuButton.this.showPopup();
            }
        }, "");
        this._popup = jPopupMenu;
        this.installKeyboardActions();
    }

    public JPopupMenu getPopupMenu() {
        return this._popup;
    }

    private void showPopup() {
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        if (this.getParent() != null) {
            this._popup.show(this.getParent(), point.x + dimension.width, point.y);
        }
    }

    protected void installKeyboardActions() {
        this.registerKeyboardAction(new HidePopupAction(), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.registerKeyboardAction(new SelectNextItemAction(), KeyStroke.getKeyStroke(40, 0, false), 2);
        this.registerKeyboardAction(new SelectPreviousItemAction(), KeyStroke.getKeyStroke(38, 0, false), 2);
        this.registerKeyboardAction(new ShowPopupAction(), KeyStroke.getKeyStroke(39, 0, false), 2);
        this.registerKeyboardAction(new ReturnAction(), KeyStroke.getKeyStroke(10, 0, false), 2);
        this.registerKeyboardAction(new ReturnAction(), KeyStroke.getKeyStroke(32, 0, false), 2);
    }

    private MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        int n3 = menuElementArray.length;
        while (n2 < n3) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        while (n2 >= 0) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            --n2;
        }
        return null;
    }

    private class SelectPreviousItemAction
    implements ActionListener {
        private SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block4: {
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block3;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block4;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block3;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = PopupMenuButton.this.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                    if (menuElementArray3[menuElementArray.length] == null) break block3;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block3;
                }
                MenuElement[] menuElementArray4 = menuElement.getSubElements();
                int n = 0;
                int n2 = menuElementArray4.length;
                while (n < n2) {
                    if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                        MenuElement menuElement2 = PopupMenuButton.this.previousEnabledChild(menuElementArray4, n - 1);
                        if (menuElement2 == null) {
                            menuElement2 = PopupMenuButton.this.previousEnabledChild(menuElementArray4, menuElementArray4.length - 1);
                        }
                        if (menuElement2 == null) break;
                        menuElementArray[menuElementArray.length - 1] = menuElement2;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    private class SelectNextItemAction
    implements ActionListener {
        private SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block4: {
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block3;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block4;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block3;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = PopupMenuButton.this.nextEnabledChild(menuElementArray2, 0);
                    if (menuElementArray3[menuElementArray.length] == null) break block3;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block3;
                }
                MenuElement[] menuElementArray4 = menuElement.getSubElements();
                int n = 0;
                int n2 = menuElementArray4.length;
                while (n < n2) {
                    if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                        MenuElement menuElement2 = PopupMenuButton.this.nextEnabledChild(menuElementArray4, n + 1);
                        if (menuElement2 == null) {
                            menuElement2 = PopupMenuButton.this.nextEnabledChild(menuElementArray4, 0);
                        }
                        if (menuElement2 == null) break;
                        menuElementArray[menuElementArray.length - 1] = menuElement2;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    private class ReturnAction
    implements ActionListener {
        private ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!PopupMenuButton.this._popup.isVisible()) {
                PopupMenuButton.this.showPopup();
            } else {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 0) {
                    MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                    if (menuElement instanceof JMenu) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                        menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    } else if (menuElement instanceof JMenuItem) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        ((JMenuItem)menuElement).doClick(0);
                        ((JMenuItem)menuElement).setArmed(false);
                    }
                }
            }
        }
    }

    private class HidePopupAction
    implements ActionListener {
        private HidePopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PopupMenuButton.this._popup.setVisible(false);
        }
    }

    private class ShowPopupAction
    implements ActionListener {
        private ShowPopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!PopupMenuButton.this._popup.isVisible()) {
                PopupMenuButton.this.showPopup();
            }
        }
    }
}

