/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import com.netscape.management.client.ace.IACITab;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;

class RightsTab
implements IACITab,
UIConstants {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    private static String KEYWORD_ALLOW = "allow";
    private static String KEYWORD_DENY = "deny";
    private static String KEYWORD_ALL = "all";
    private static String KEYWORD_PROXY = "proxy";
    private static String KEYWORD_IMPORT = "import";
    private static String KEYWORD_EXPORT = "export";
    private static String[] RIGHTS = new String[]{"read", "compare", "search", "selfwrite", "write", "delete", "add", KEYWORD_PROXY, KEYWORD_IMPORT, KEYWORD_EXPORT};
    private static int TAB_POSITION = 1;
    private static String ALL_COMMAND = "ALL";
    private static String NONE_COMMAND = "NONE";
    private DefaultTableModel rightsTableModel;
    private JTable rightsTable;
    private JButton allButton;
    private JButton noneButton;
    private JPanel p = new JPanel();
    private boolean isInitialized = false;
    private boolean _isModDnSupported;

    RightsTab() {
    }

    private static String i18n(String string) {
        return i18n.getString("right", string);
    }

    public void initialize(JFrame jFrame, LDAPConnection lDAPConnection, String string, LDAPConnection lDAPConnection2, String string2) {
        this._isModDnSupported = false;
        try {
            LDAPSchema lDAPSchema = new LDAPSchema();
            lDAPSchema.fetchSchema(lDAPConnection);
            this._isModDnSupported = lDAPSchema.getAttribute("modDNEnabledSuffixes") != null;
        }
        catch (LDAPException lDAPException) {
            Debug.println("RightsTab.initialize: exception fetching the schema: " + (Object)((Object)lDAPException));
        }
    }

    public ACIAttribute[] aciChanged(ACIAttribute[] aCIAttributeArray, String string) throws Exception {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        String string2 = null;
        int n = 0;
        while (n < aCIAttributeArray.length) {
            object2 = aCIAttributeArray[n];
            if (((ACIAttribute)object2).getName().equalsIgnoreCase(KEYWORD_ALLOW)) {
                string2 = ((ACIAttribute)object2).getValue();
                bl = true;
                vector.addElement(object2);
            } else if (((ACIAttribute)object2).getName().equalsIgnoreCase(KEYWORD_DENY)) {
                string2 = ((ACIAttribute)object2).getValue();
                bl = false;
                vector.addElement(object2);
            }
            ++n;
        }
        if (string2 == null) {
            this.checkAll();
            return null;
        }
        object2 = new Vector();
        string2 = string2.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "( ),\n");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!this.isValidRightString((String)object)) {
                Debug.println("RightsTab: can not edit visually, unsupported=" + (String)object);
                throw new Exception(i18n.getString("ed", "visualUnsupported"));
            }
            ((Vector)object2).addElement(object);
        }
        object = this.rightsTable.getModel();
        int n2 = object.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            boolean bl2 = !bl;
            String string3 = (String)object.getValueAt(n3, 1);
            if (string3.equalsIgnoreCase(KEYWORD_PROXY)) {
                if (((Vector)object2).contains(KEYWORD_PROXY)) {
                    bl2 = bl;
                } else if (((Vector)object2).contains(KEYWORD_ALL) && !bl) {
                    bl2 = false;
                }
            } else if (string3.equalsIgnoreCase(KEYWORD_IMPORT)) {
                if (((Vector)object2).contains(KEYWORD_IMPORT)) {
                    bl2 = bl;
                } else if (((Vector)object2).contains(KEYWORD_ALL) && !bl) {
                    bl2 = false;
                }
            } else if (string3.equalsIgnoreCase(KEYWORD_EXPORT)) {
                if (((Vector)object2).contains(KEYWORD_EXPORT)) {
                    bl2 = bl;
                } else if (((Vector)object2).contains(KEYWORD_ALL) && !bl) {
                    bl2 = false;
                }
            } else if (((Vector)object2).contains(KEYWORD_ALL) || ((Vector)object2).contains(string3)) {
                bl2 = bl;
            }
            object.setValueAt(new Boolean(bl2), n3, 0);
            ++n3;
        }
        return ACIAttribute.toArray(vector);
    }

    private boolean isValidRightString(String string) {
        int n = 0;
        while (n < RIGHTS.length) {
            if (!this._isModDnSupported && (string.equalsIgnoreCase(KEYWORD_EXPORT) || string.equalsIgnoreCase(KEYWORD_IMPORT))) {
                return false;
            }
            if (RIGHTS[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return KEYWORD_ALL.equalsIgnoreCase(string);
    }

    public JComponent getComponent() {
        this.rightsTableModel = this.createTableModel();
        this.rightsTable = new Table((TableModel)this.rightsTableModel, true);
        this.rightsTable.getAccessibleContext().setAccessibleDescription(RightsTab.i18n("info"));
        this.p.setPreferredSize(new Dimension(480, 260));
        return this.p;
    }

    public int getPreferredPosition() {
        return TAB_POSITION;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.allButton = ButtonFactory.createButton(RightsTab.i18n("all"), buttonActionListener, ALL_COMMAND);
        this.allButton.setToolTipText(RightsTab.i18n("all_tt"));
        gridBagLayout.setConstraints(this.allButton, gridBagConstraints);
        jPanel.add(this.allButton);
        this.noneButton = ButtonFactory.createButton(RightsTab.i18n("none"), buttonActionListener, NONE_COMMAND);
        this.noneButton.setToolTipText(RightsTab.i18n("none_tt"));
        gridBagLayout.setConstraints(this.noneButton, gridBagConstraints);
        jPanel.add(this.noneButton);
        ButtonFactory.resizeButtons(this.allButton, this.noneButton);
        return jPanel;
    }

    private DefaultTableModel createTableModel() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }
        };
        defaultTableModel.addColumn("");
        defaultTableModel.addColumn(RightsTab.i18n("columnName"));
        defaultTableModel.addColumn(RightsTab.i18n("columnDesc"));
        int n = 0;
        while (n < RIGHTS.length) {
            if (this._isModDnSupported || RIGHTS[n] != KEYWORD_IMPORT && RIGHTS[n] != KEYWORD_EXPORT) {
                defaultTableModel.addRow(new Object[]{new Boolean(false), RIGHTS[n], RightsTab.i18n(RIGHTS[n])});
            }
            ++n;
        }
        return defaultTableModel;
    }

    public String getTitle() {
        return RightsTab.i18n("title");
    }

    public void tabSelected() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.p.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel();
        jLabel.setText(RightsTab.i18n("info"));
        jLabel.setLabelFor(this.rightsTable);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.p.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.rightsTable.setSelectionBackground(this.rightsTable.getBackground());
        this.rightsTable.setSelectionForeground(this.rightsTable.getForeground());
        TableColumn tableColumn = this.rightsTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn.setResizable(false);
        JScrollPane jScrollPane = new JScrollPane(this.rightsTable);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.p.add(jScrollPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        JPanel jPanel = this.createButtonPanel();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.p.add(jPanel);
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("ace-rights");
    }

    public void okInvoked() {
    }

    public void cancelInvoked() {
    }

    public StringBuffer createACI(StringBuffer stringBuffer) {
        int n;
        String string = stringBuffer.toString();
        if (string.indexOf("acl") != -1 && (n = string.indexOf("\";")) != -1) {
            int n2 = this.rightsTableModel.getRowCount();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuffer stringBuffer2 = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                Boolean bl5 = (Boolean)this.rightsTableModel.getValueAt(n3, 0);
                String string2 = (String)this.rightsTableModel.getValueAt(n3, 1);
                if (string2.equalsIgnoreCase(KEYWORD_PROXY)) {
                    bl2 = bl5;
                } else if (string2.equalsIgnoreCase(KEYWORD_IMPORT)) {
                    bl3 = bl5;
                } else if (string2.equalsIgnoreCase(KEYWORD_EXPORT)) {
                    bl4 = bl5;
                } else if (bl5.booleanValue()) {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(",");
                    }
                    stringBuffer2.append((String)this.rightsTableModel.getValueAt(n3, 1));
                } else {
                    bl = false;
                }
                ++n3;
            }
            if (bl) {
                stringBuffer2 = new StringBuffer(KEYWORD_ALL);
            }
            if (bl2) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(KEYWORD_PROXY);
            }
            if (bl3) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(KEYWORD_IMPORT);
            }
            if (bl4) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(KEYWORD_EXPORT);
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.insert(n + 2, "\n" + KEYWORD_ALLOW + " (" + stringBuffer2 + ")");
            } else {
                stringBuffer.insert(n + 2, "\n" + KEYWORD_DENY + " (" + KEYWORD_ALL + ")");
            }
            return stringBuffer;
        }
        System.err.println("ACI ERROR: unable to encode rights");
        return stringBuffer;
    }

    private void checkAll() {
        this.setAllState(true);
    }

    private void checkNone() {
        this.setAllState(false);
    }

    private void setAllState(boolean bl) {
        int n = this.rightsTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                String string = (String)this.rightsTableModel.getValueAt(n2, 1);
                if (!(string.equalsIgnoreCase(KEYWORD_PROXY) || string.equalsIgnoreCase(KEYWORD_IMPORT) || string.equalsIgnoreCase(KEYWORD_EXPORT))) {
                    this.rightsTableModel.setValueAt(new Boolean(bl), n2, 0);
                }
            } else {
                this.rightsTableModel.setValueAt(new Boolean(bl), n2, 0);
            }
            ++n2;
        }
        this.rightsTableModel.fireTableDataChanged();
    }

    public ACIAttribute[] getSupportedAttributes() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < RIGHTS.length) {
            stringBuffer.append(RIGHTS[n]);
            stringBuffer.append("|");
            ++n;
        }
        stringBuffer.append(KEYWORD_ALL);
        return new ACIAttribute[]{new ACIAttribute(KEYWORD_ALLOW, "", "(" + stringBuffer.toString() + ")"), new ACIAttribute(KEYWORD_ALLOW, "", "(" + KEYWORD_ALL + ")"), new ACIAttribute(KEYWORD_DENY, "", "(" + stringBuffer.toString() + ")"), new ACIAttribute(KEYWORD_DENY, "", "(" + KEYWORD_ALL + ")")};
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(ALL_COMMAND)) {
                RightsTab.this.checkAll();
            } else if (string.equals(NONE_COMMAND)) {
                RightsTab.this.checkNone();
            }
        }
    }
}

