/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import com.netscape.management.client.ace.ACIParser;
import com.netscape.management.client.ace.HostTab;
import com.netscape.management.client.ace.IACITab;
import com.netscape.management.client.ace.RightsTab;
import com.netscape.management.client.ace.TargetTab;
import com.netscape.management.client.ace.TimeTab;
import com.netscape.management.client.ace.UGTab;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.ErrorDialog;
import com.netscape.management.client.components.FontFactory;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

class ACIEditor
extends GenericDialog {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    private static ImageIcon warningIcon = new RemoteImage("com/netscape/management/client/images/warn16.gif");
    private static String KEYWORD_ACLNAME = "acl";
    private static String KEYWORD_VERSION = "version";
    private static String DEFAULT_VERSION = "3.0";
    private static String MANUAL_MODE = "MANUAL";
    private static String VISUAL_MODE;
    private static String displayMode;
    private static char ERASE_CHAR;
    private String aciVersion = DEFAULT_VERSION;
    private Vector tabVector = new Vector();
    private JTabbedPane tabbedPane = null;
    private JFrame parentFrame = null;
    private JTextField aciNameField = new JTextField();
    private LDAPConnection aciLdc;
    private LDAPConnection ugLdc;
    private String aciDN = null;
    private String currentACI = null;
    private String unusedACI = null;
    private String ugDN = null;
    private CardLayout panelCardLayout = null;
    private JPanel contentPanel = null;
    private JButton modeButton = null;
    private JTextArea textArea = null;
    private boolean isInitialized = false;
    static /* synthetic */ Class class$com$netscape$management$client$ace$IACITab;
    static /* synthetic */ Class class$javax$swing$JDialog;

    private static String i18n(String string) {
        return i18n.getString("ed", string);
    }

    public ACIEditor(JFrame jFrame, String string, LDAPConnection lDAPConnection, String string2, LDAPConnection lDAPConnection2, String string3, String string4) {
        super(jFrame, "", 11, 0);
        this.parentFrame = jFrame;
        this.aciLdc = lDAPConnection;
        this.ugLdc = lDAPConnection2;
        this.aciDN = string2;
        this.ugDN = string3;
        this.currentACI = string4;
        this.tabVector = this.createDefaultTabs();
        String string5 = MessageFormat.format(ACIEditor.i18n("title"), string);
        this.setTitle(string5);
        this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(ACIEditor.i18n("description"), string));
    }

    public void show() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.tabVector = this.orderTabs(this.tabVector);
            if (this.currentACI == null || this.currentACI.length() == 0) {
                displayMode = VISUAL_MODE;
            }
            this.setButtonComponent(this.createButtonPanel());
            this.contentPanel = this.createContentPanel();
            String string = displayMode;
            displayMode = "";
            this.setDisplayMode(string, false);
            this.getContentPane().add(this.contentPanel);
            this.setMinimumSize(this.getPreferredSize());
        }
        super.show();
    }

    public String getACI() {
        String string = this.createACI();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != '\n') {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String createACI() {
        String string;
        if (this.getDisplayMode().equals(VISUAL_MODE)) {
            StringBuffer stringBuffer = this.createACI(new StringBuffer());
            Enumeration enumeration = this.tabVector.elements();
            while (enumeration.hasMoreElements()) {
                IACITab iACITab = (IACITab)enumeration.nextElement();
                stringBuffer = iACITab.createACI(stringBuffer);
            }
            string = stringBuffer.toString();
        } else {
            string = this.textArea.getText();
        }
        Debug.println("ACI: " + string);
        return string;
    }

    public int getACITabCount() {
        return this.tabVector.size();
    }

    public IACITab getACITab(int n) {
        return (IACITab)this.tabVector.elementAt(n);
    }

    public void addACITab(IACITab iACITab) {
        this.tabVector.addElement(iACITab);
    }

    public void removeACITab(int n) {
        this.tabVector.removeElementAt(n);
    }

    private Vector createDefaultTabs() {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(new UGTab());
        vector.addElement(new RightsTab());
        vector.addElement(new TargetTab());
        vector.addElement(new HostTab());
        vector.addElement(new TimeTab());
        String string = "cn=ACIEditor, " + LDAPUtil.getAdminGlobalParameterEntry();
        try {
            LDAPEntry lDAPEntry = this.aciLdc.read(string, new String[]{"nsClassName"});
            Debug.println("DN: " + lDAPEntry.getDN());
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                String string2 = lDAPAttribute.getName();
                Debug.println("\t" + string2 + ":");
                Enumeration enumeration2 = lDAPAttribute.getStringValues();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    Debug.println("\t\t" + string3);
                    ConsoleInfo consoleInfo = Console.getConsoleInfo();
                    Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)consoleInfo, (String)string3);
                    if (!clazz.isInstance(class$com$netscape$management$client$ace$IACITab == null ? ACIEditor.class$("com.netscape.management.client.ace.IACITab") : class$com$netscape$management$client$ace$IACITab)) continue;
                    vector.addElement(clazz);
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("Cannot read tab extension DN: " + string);
            Debug.println("LDAP exception code: " + lDAPException.getLDAPResultCode());
        }
        return vector;
    }

    private Vector orderTabs(Vector vector) {
        Vector<IACITab> vector2 = new Vector<IACITab>();
        int n = 0;
        while (n < 11) {
            if (n == 10) {
                n = -1;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                IACITab iACITab = (IACITab)enumeration.nextElement();
                if (iACITab.getPreferredPosition() != n) continue;
                vector2.addElement(iACITab);
            }
            if (n == -1) {
                n = 10;
            }
            ++n;
        }
        return vector2;
    }

    private JPanel createButtonPanel() {
        String string;
        String string2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        if (displayMode.equals(VISUAL_MODE)) {
            string2 = ACIEditor.i18n("manual");
            string = ACIEditor.i18n("manual_tt");
        } else {
            string2 = ACIEditor.i18n("visual");
            string = ACIEditor.i18n("visual_tt");
        }
        this.modeButton = ButtonFactory.createButton(string2, new ManualActionListener(), "CMD");
        this.modeButton.setToolTipText(string);
        JButton jButton = ButtonFactory.createButton(ACIEditor.i18n("visual"), null, null);
        JButton jButton2 = ButtonFactory.createButton(ACIEditor.i18n("manual"), null, null);
        Dimension dimension = jButton.getPreferredSize();
        Dimension dimension2 = jButton2.getPreferredSize();
        int n = (int)Math.max(dimension.getHeight(), dimension2.getHeight());
        int n2 = (int)Math.max(dimension.getWidth(), dimension2.getWidth());
        this.modeButton.setPreferredSize(new Dimension(n2, n));
        jPanel.add((Component)this.modeButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel();
        this.panelCardLayout = new CardLayout();
        jPanel.setLayout(this.panelCardLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.add(MANUAL_MODE, this.createManualPanel());
        jPanel.add(VISUAL_MODE, this.createVisualPanel());
        return jPanel;
    }

    private void setDisplayMode(String string, boolean bl) {
        if (string.equals(MANUAL_MODE)) {
            if (displayMode.equals(VISUAL_MODE)) {
                this.currentACI = this.createACI();
            }
            this.textArea.setText(this.currentACI);
        } else if (string.equals(VISUAL_MODE)) {
            if (displayMode.equals(MANUAL_MODE)) {
                this.currentACI = this.textArea.getText();
            }
            try {
                ACIAttribute[] aCIAttributeArray = ACIAttribute.toArray(ACIParser.getACIAttributes(this.currentACI));
                this.setVisualMode(aCIAttributeArray);
                if (aCIAttributeArray.length > 0 && !this.checkVisualConversion(aCIAttributeArray)) {
                    throw new Exception(ACIEditor.i18n("visualUnsupported"));
                }
            }
            catch (Exception exception) {
                this.setDisplayMode(MANUAL_MODE, false);
                if (!bl) {
                    return;
                }
                String string2 = ACIEditor.i18n("visualFailedTitle");
                String string3 = ACIEditor.i18n("visualFailedMsg");
                String string4 = null;
                String string5 = exception.getMessage();
                ErrorDialog errorDialog = new ErrorDialog(this, string2, string3, string4, string5, 1, 1);
                errorDialog.setVisible(true);
                return;
            }
        }
        this.panelCardLayout.show(this.contentPanel, string);
        displayMode = string;
        ButtonFactory.setButtonText(this.modeButton, string == MANUAL_MODE ? ACIEditor.i18n("visual") : ACIEditor.i18n("manual"));
        this.modeButton.setToolTipText(string == MANUAL_MODE ? ACIEditor.i18n("visual_tt") : ACIEditor.i18n("manual_tt"));
    }

    private void setVisualMode(ACIAttribute[] aCIAttributeArray) throws Exception {
        ACIAttribute aCIAttribute;
        int n;
        IACITab iACITab;
        ACIAttribute[] aCIAttributeArray2 = this.aciChanged(aCIAttributeArray, this.currentACI);
        StringBuffer stringBuffer = new StringBuffer(this.currentACI);
        ACIEditor.eraseACI(stringBuffer, aCIAttributeArray2);
        Enumeration enumeration = this.tabVector.elements();
        while (enumeration.hasMoreElements()) {
            iACITab = (IACITab)enumeration.nextElement();
            aCIAttributeArray2 = iACITab.aciChanged(aCIAttributeArray, this.currentACI);
            ACIEditor.eraseACI(stringBuffer, aCIAttributeArray2);
        }
        iACITab = (IACITab)this.tabVector.elementAt(this.tabbedPane.getSelectedIndex());
        iACITab.tabSelected();
        if (aCIAttributeArray.length > 0 && (n = (aCIAttribute = aCIAttributeArray[aCIAttributeArray.length - 1]).getEndIndex()) > 0) {
            stringBuffer.setLength(n + 1);
        }
        this.unusedACI = stringBuffer.toString();
    }

    private boolean equalStrings(String string, String string2) {
        if (string != null) {
            return string.equals(string2);
        }
        return string2 == null;
    }

    private boolean checkVisualConversion(ACIAttribute[] aCIAttributeArray) {
        if (this.unusedACI != null) {
            int n = 0;
            while (n < this.unusedACI.length()) {
                if (this.unusedACI.charAt(n) != ERASE_CHAR) {
                    Debug.println("ACIEditor.checkVisualConversion: conversion failed unusedACI=" + this.unusedACI);
                    return false;
                }
                ++n;
            }
        }
        String string = displayMode;
        displayMode = VISUAL_MODE;
        String string2 = this.getACI();
        displayMode = string;
        ACIAttribute[] aCIAttributeArray2 = ACIAttribute.toArray(ACIParser.getACIAttributes(string2));
        if (aCIAttributeArray.length != aCIAttributeArray2.length) {
            Debug.println("ACIEditor.checkVisualConversion: conversion failed, attr arrays size mismatch");
            return false;
        }
        int n = 0;
        while (n < aCIAttributeArray.length) {
            if (!this.equalStrings(aCIAttributeArray[n].getName(), aCIAttributeArray2[n].getName())) {
                Debug.println("ACIEditor.checkVisualConversion: conversion failed, attribute name mismatch " + aCIAttributeArray[n].getName() + " v.s. " + aCIAttributeArray2[n].getName());
                return false;
            }
            if (!this.equalStrings(aCIAttributeArray[n].getOperator(), aCIAttributeArray2[n].getOperator())) {
                Debug.println("ACIEditor.checkVisualConversion: conversion failed for " + aCIAttributeArray[n].getName() + " operator mismatch " + aCIAttributeArray[n].getOperator() + " v.s. " + aCIAttributeArray2[n].getOperator());
                return false;
            }
            ++n;
        }
        return true;
    }

    private static void eraseACI(StringBuffer stringBuffer, ACIAttribute[] aCIAttributeArray) {
        if (aCIAttributeArray == null) {
            return;
        }
        int n = 0;
        while (n < aCIAttributeArray.length) {
            ACIEditor.eraseACI(stringBuffer, aCIAttributeArray[n].getStartIndex(), aCIAttributeArray[n].getEndIndex());
            ++n;
        }
    }

    private static void eraseACI(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            stringBuffer.setCharAt(n3, ERASE_CHAR);
            ++n3;
        }
    }

    private String getDisplayMode() {
        return displayMode;
    }

    private JPanel createManualPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(ACIEditor.i18n("manualLabel"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.textArea = new JTextArea();
        this.textArea.setFont(FontFactory.getFont("DATA_FIXED"));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        jPanel.add((Component)new JScrollPane(this.textArea), gridBagConstraints);
        jLabel.setLabelFor(this.textArea);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        warningIcon.setDescription(ACIEditor.i18n("warning-icon-description"));
        JLabel jLabel2 = new JLabel(ACIEditor.i18n("warning"), warningIcon, 2);
        jLabel2.setLabelFor(jPanel);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        JButton jButton = ButtonFactory.createButton(ACIEditor.i18n("syntax"), new SyntaxActionListener(), "");
        jButton.setToolTipText(ACIEditor.i18n("syntax_tt"));
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel createVisualPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        JLabel jLabel = new JLabel();
        jLabel.setText(ACIEditor.i18n("aciLabel"));
        jLabel.setLabelFor(this.aciNameField);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.aciNameField.setFont(FontFactory.getFont("DATA_FIXED"));
        this.aciNameField.setBorder(UIManager.getBorder("TextField.border"));
        jPanel.add((Component)this.aciNameField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.tabbedPane = this.createTabbedPane();
        jPanel.add((Component)this.tabbedPane, gridBagConstraints);
        return jPanel;
    }

    public ACIAttribute[] aciChanged(ACIAttribute[] aCIAttributeArray, String string) {
        String string2;
        this.aciNameField.setText("");
        this.aciVersion = DEFAULT_VERSION;
        Vector<ACIAttribute> vector = new Vector<ACIAttribute>();
        ACIAttribute aCIAttribute = ACIAttribute.getAttribute(KEYWORD_ACLNAME, aCIAttributeArray);
        if (aCIAttribute != null) {
            string2 = aCIAttribute.getValue();
            this.aciNameField.setText(string2);
            vector.addElement(aCIAttribute);
        }
        if ((aCIAttribute = ACIAttribute.getAttribute(KEYWORD_VERSION, aCIAttributeArray)) != null) {
            this.aciVersion = string2 = aCIAttribute.getValue();
            vector.addElement(aCIAttribute);
        }
        return ACIAttribute.toArray(vector);
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        Enumeration enumeration = this.tabVector.elements();
        while (enumeration.hasMoreElements()) {
            IACITab iACITab = (IACITab)enumeration.nextElement();
            iACITab.initialize(this.parentFrame, this.aciLdc, this.aciDN, this.ugLdc, this.ugDN);
            jTabbedPane.addTab(iACITab.getTitle(), iACITab.getComponent());
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                IACITab iACITab = (IACITab)ACIEditor.this.tabVector.elementAt(n);
                iACITab.tabSelected();
            }
        });
        return jTabbedPane;
    }

    public StringBuffer createACI(StringBuffer stringBuffer) {
        String string = this.aciNameField.getText();
        if (string.length() == 0) {
            string = i18n.getString("mgr", "nonameACI");
        }
        stringBuffer.append("(" + KEYWORD_VERSION + " " + this.aciVersion + ";\n");
        stringBuffer.append(KEYWORD_ACLNAME + " \"" + string + "\";\n;)");
        if (this.unusedACI != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.unusedACI, String.valueOf(ERASE_CHAR), false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = ACIEditor.balanceParenthesis(stringTokenizer.nextToken()) + " ";
                if (!stringBuffer.toString().endsWith("\n;)")) continue;
                int n = stringBuffer.length() - 3;
                stringBuffer.insert(n, string2);
            }
        }
        return stringBuffer;
    }

    private static String balanceParenthesis(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            if (string.charAt(n3) == '(') {
                ++n2;
            }
            if (string.charAt(n3) == ')') {
                ++n;
            }
            --n3;
        }
        if (n > n2) {
            return ACIEditor.balanceParenthesis("(" + string);
        }
        if (n2 > n) {
            return ACIEditor.balanceParenthesis(string + ")");
        }
        return string;
    }

    protected void helpInvoked() {
        if (displayMode == VISUAL_MODE) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n >= 0) {
                IACITab iACITab = (IACITab)this.tabVector.elementAt(n);
                iACITab.helpInvoked();
            }
        } else {
            ConsoleHelp.showContextHelp("ace-manual");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        displayMode = VISUAL_MODE = "VISUAL";
        ERASE_CHAR = (char)126;
    }

    class ManualActionListener
    implements ActionListener {
        ManualActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ACIEditor.this.getDisplayMode();
            if (string.equals(VISUAL_MODE)) {
                ACIEditor.this.setDisplayMode(MANUAL_MODE, true);
            } else {
                ACIEditor.this.setDisplayMode(VISUAL_MODE, true);
            }
        }
    }

    class SyntaxActionListener
    implements ActionListener {
        final String ACI_ALL = "(targetattr=\"*\")(version 3.0; acl \"Allow Everyone\"; allow (all) (userdn = \"ldap:///anyone\") ;)";

        SyntaxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LDAPAttribute lDAPAttribute = null;
            LDAPAttribute lDAPAttribute2 = null;
            LDAPModification lDAPModification = null;
            boolean bl = false;
            try {
                LDAPEntry lDAPEntry = ACIEditor.this.aciLdc.read(ACIEditor.this.aciDN, new String[]{"aci"});
                if (lDAPEntry != null) {
                    lDAPAttribute = lDAPEntry.getAttribute("aci");
                }
                lDAPAttribute2 = new LDAPAttribute("aci");
                lDAPAttribute2.addValue("(targetattr=\"*\")(version 3.0; acl \"Allow Everyone\"; allow (all) (userdn = \"ldap:///anyone\") ;)");
                lDAPAttribute2.addValue(ACIEditor.this.getACI());
                lDAPModification = new LDAPModification(2, lDAPAttribute2);
                try {
                    ACIEditor.this.aciLdc.modify(ACIEditor.this.aciDN, lDAPModification);
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    bl = false;
                    Debug.println("ACI Write Error: " + lDAPException.getLDAPResultCode());
                    Debug.println("Message: " + lDAPException.getLDAPErrorMessage());
                }
                try {
                    lDAPModification = lDAPAttribute != null ? new LDAPModification(2, lDAPAttribute) : new LDAPModification(1, lDAPAttribute2);
                    ACIEditor.this.aciLdc.modify(ACIEditor.this.aciDN, lDAPModification);
                }
                catch (LDAPException lDAPException) {
                    Debug.println("ACI Replace Error: " + lDAPException.getLDAPResultCode());
                }
                Container container = SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = ACIEditor.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, ACIEditor.this.contentPanel);
                if (bl) {
                    String string = ACIEditor.i18n("syntaxPassedTitle");
                    String string2 = ACIEditor.i18n("syntaxPassedMsg");
                    JOptionPane.showMessageDialog(container, string2, string, 1);
                } else {
                    String string = ACIEditor.i18n("syntaxFailedTitle");
                    String string3 = ACIEditor.i18n("syntaxFailedMsg");
                    JOptionPane.showMessageDialog(container, string3, string, 0);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println("ACI Read Error: " + lDAPException.getLDAPResultCode());
            }
        }
    }
}

