/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.Framework;
import com.netscape.management.client.UIPermissions;
import com.netscape.management.client.ace.ACIManager;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.AbstractPreferencesTab;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

class UIPermissionsPreferencesTab
extends AbstractPreferencesTab {
    private UIPermissions uip = null;
    private Vector permissionIDs = new Vector();
    private Table permissionTable = null;
    private DefaultTableModel permissionTableModel = null;
    private JButton permissionButton = null;
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.default");
    private static boolean isRestartRequired = false;
    private boolean isTabCreated = false;

    private static String i18n(String string) {
        return resource.getString("permTab", string);
    }

    public UIPermissionsPreferencesTab() {
        this.setTitle(UIPermissionsPreferencesTab.i18n("title"));
    }

    public void initialize(JFrame jFrame) {
        super.initialize(jFrame);
        this.isTabCreated = false;
    }

    public void tabSelected() {
        if (!this.isTabCreated) {
            this.isTabCreated = true;
            this.setRestartRequired(isRestartRequired);
            this.setComponent(this.createTabPanel());
        }
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("preferences-uipermissions");
    }

    protected JPanel createTabPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.permissionTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.permissionTableModel.addColumn(UIPermissionsPreferencesTab.i18n("nameColumn"));
        this.permissionTableModel.addColumn(UIPermissionsPreferencesTab.i18n("descriptionColumn"));
        JFrame jFrame = this.getFrame();
        if (jFrame instanceof Framework) {
            this.uip = ((Framework)jFrame).getUIPermissions();
            Enumeration enumeration = this.uip.getPermissionIDs();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.permissionIDs.addElement(string);
                this.permissionTableModel.addRow(new String[]{this.uip.getName(string), this.uip.getDescription(string)});
            }
        }
        this.permissionTable = new Table((TableModel)this.permissionTableModel, true);
        this.permissionTable.setToolTipText(UIPermissionsPreferencesTab.i18n("table_tt"));
        this.permissionTable.setSelectionMode(0);
        int n = (int)this.permissionTable.getPreferredScrollableViewportSize().getWidth();
        int n2 = this.permissionTable.getRowHeight() * 10;
        this.permissionTable.setPreferredScrollableViewportSize(new Dimension(n, n2));
        ListSelectionModel listSelectionModel = this.permissionTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UIPermissionsPreferencesTab.this.enableButtons();
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = Table.createScrollPaneForTable(this.permissionTable);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this.permissionButton = JButtonFactory.create(UIPermissionsPreferencesTab.i18n("accessButton"), new PermissionActionListener(), "permissions");
        this.permissionButton.setToolTipText(UIPermissionsPreferencesTab.i18n("accessButton_tt"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(this.permissionButton, gridBagConstraints);
        jPanel.add(this.permissionButton);
        this.enableButtons();
        return jPanel;
    }

    private void enableButtons() {
        ListSelectionModel listSelectionModel = this.permissionTable.getSelectionModel();
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            bl = this.uip.hasPermission((String)this.permissionIDs.elementAt(n));
        }
        this.permissionButton.setEnabled(bl);
    }

    private void requireRestart() {
        isRestartRequired = true;
        this.setRestartRequired(isRestartRequired);
    }

    class PermissionActionListener
    implements ActionListener {
        PermissionActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = UIPermissionsPreferencesTab.this.permissionTable.getSelectedRow();
            if (n != -1) {
                ConsoleInfo consoleInfo = Console.getConsoleInfo();
                String string = (String)UIPermissionsPreferencesTab.this.permissionIDs.elementAt(n);
                ACIManager aCIManager = new ACIManager(UIPermissionsPreferencesTab.super.getFrame(), UIPermissionsPreferencesTab.this.uip.getName(string), UIPermissionsPreferencesTab.this.uip.getPermissionDN(string));
                aCIManager.show();
                if (!aCIManager.isCancel()) {
                    UIPermissionsPreferencesTab.this.requireRestart();
                }
            }
        }
    }
}

