/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.AbstractPreferencesTab;
import com.netscape.management.client.preferences.FilePreferenceManager;
import com.netscape.management.client.preferences.LDAPPreferenceManager;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SettingsPreferencesTab
extends AbstractPreferencesTab {
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.default");
    private static ResourceSet helpResource = new ResourceSet("com.netscape.management.client.help");
    private JButton clearButton;
    private JRadioButton storeDirectoryRadio;
    private JRadioButton storeDiskRadio;
    private static boolean isRestartRequired = false;
    private boolean clearPressed = false;
    private boolean isTabCreated = false;

    private static String i18n(String string) {
        return resource.getString("settingsTab", string);
    }

    public SettingsPreferencesTab() {
        this.setTitle(SettingsPreferencesTab.i18n("title"));
    }

    public void initialize(JFrame jFrame) {
        super.initialize(jFrame);
        this.isTabCreated = false;
    }

    public void tabSelected() {
        if (!this.isTabCreated) {
            this.isTabCreated = true;
            this.setRestartRequired(isRestartRequired);
            this.setComponent(this.createTabPanel());
        }
    }

    protected JPanel createTabPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        boolean bl = Console.canSetLocalPreferencesFlag();
        boolean bl2 = Console.getLocalPreferencesFlag();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(SettingsPreferencesTab.i18n("where")));
        jPanel2.setEnabled(bl);
        GridBagUtil.constrain(jPanel, jPanel2, 0, 0, 1, 1, 1.0, 0.0, 18, 2, 0, 0, 9, 0);
        this.storeDirectoryRadio = new JRadioButton(UITools.getDisplayLabel(SettingsPreferencesTab.i18n("remote")));
        this.storeDirectoryRadio.setSelected(!bl2);
        this.storeDirectoryRadio.setEnabled(bl);
        buttonGroup.add(this.storeDirectoryRadio);
        GridBagUtil.constrain(jPanel2, this.storeDirectoryRadio, 0, 0, 1, 1, 1.0, 0.0, 18, 2, 0, 6, 0, 6);
        this.storeDiskRadio = new JRadioButton(UITools.getDisplayLabel(SettingsPreferencesTab.i18n("local")));
        this.storeDiskRadio.setSelected(bl2);
        this.storeDiskRadio.setEnabled(bl);
        buttonGroup.add(this.storeDiskRadio);
        GridBagUtil.constrain(jPanel2, this.storeDiskRadio, 0, 1, 1, 1, 1.0, 0.0, 18, 2, 0, 6, 6, 6);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagUtil.constrain(jPanel, jPanel3, 0, 2, 1, 1, 1.0, 0.0, 18, 2, 0, 0, 9, 0);
        this.clearButton = JButtonFactory.create(SettingsPreferencesTab.i18n("reset"), new ClearButtonListener(), "RESET");
        this.clearButton.setToolTipText(SettingsPreferencesTab.i18n("resetDescription"));
        GridBagUtil.constrain(jPanel3, this.clearButton, 0, 0, 1, 1, 0.0, 0.0, 18, 0, 0, 6, 6, 6);
        JLabel jLabel = new JLabel(SettingsPreferencesTab.i18n("resetDescription"));
        jLabel.setLabelFor(this.clearButton);
        GridBagUtil.constrain(jPanel3, jLabel, 1, 0, 1, 1, 1.0, 0.0, 17, 0, 0, 6, 6, 6);
        GridBagUtil.constrain(jPanel, new JPanel(), 0, 3, 1, 1, 1.0, 1.0, 18, 1, 0, 6, 6, 6);
        return jPanel;
    }

    public void okInvoked() {
        boolean bl = Console.getLocalPreferencesFlag();
        Console.setLocalPreferencesFlag(!this.storeDirectoryRadio.isSelected());
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager("Console", "4.0");
        Preferences preferences = preferenceManager.getPreferences("General");
        if (bl != this.storeDiskRadio.isSelected()) {
            if (this.storeDiskRadio.isSelected()) {
                this.copyPreferences(preferenceManager, new FilePreferenceManager("Console", "4.0"));
            } else {
                ConsoleInfo consoleInfo = Console.getConsoleInfo();
                LDAPPreferenceManager lDAPPreferenceManager = new LDAPPreferenceManager(consoleInfo.getLDAPConnection(), consoleInfo.getUserPreferenceDN(), "Console", "4.0");
                this.copyPreferences(preferenceManager, lDAPPreferenceManager);
            }
        }
        if (this.clearPressed) {
            PreferenceManager.clearAllPreferences();
            isRestartRequired = true;
        }
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("preferences-settings");
    }

    public void copyPreferences(PreferenceManager preferenceManager, PreferenceManager preferenceManager2) {
        String[] stringArray = preferenceManager.getPreferencesList();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (!string.equals("Login")) {
                    Preferences preferences = preferenceManager2.getPreferences(string);
                    Preferences preferences2 = preferenceManager.getPreferences(string);
                    Enumeration enumeration = preferences2.getNames();
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        Object object = preferences2.get(e);
                        preferences.set((String)e, (String)object);
                    }
                }
                ++n;
            }
            preferenceManager2.savePreferences();
        }
    }

    class ClearButtonListener
    implements ActionListener {
        ClearButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsPreferencesTab.this.setRestartRequired(true);
            SettingsPreferencesTab.this.clearPressed = true;
        }
    }
}

