/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IMenuItemCategory;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;

class MenuData {
    String _categoryID = null;
    IMenuItem _item = null;
    IMenuInfo _menuInfo = null;

    MenuData(String string, IMenuItem iMenuItem, IMenuInfo iMenuInfo) {
        this.setCategoryID(string);
        this.setIMenuItem(iMenuItem);
        this.setIMenuInfo(iMenuInfo);
    }

    String getCategoryID() {
        return this._categoryID;
    }

    IMenuItem getIMenuItem() {
        return this._item;
    }

    IMenuInfo getIMenuInfo() {
        return this._menuInfo;
    }

    void setCategoryID(String string) {
        this._categoryID = string;
    }

    void setIMenuItem(IMenuItem iMenuItem) {
        this._item = iMenuItem;
    }

    void setIMenuInfo(IMenuInfo iMenuInfo) {
        this._menuInfo = iMenuInfo;
    }

    public static Vector createMenuData(IMenuInfo iMenuInfo, ActionListener actionListener) {
        Vector<MenuData> vector = new Vector<MenuData>();
        String[] stringArray = iMenuInfo.getMenuCategoryIDs();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                IMenuItem[] iMenuItemArray = iMenuInfo.getMenuItems(stringArray[n]);
                if (iMenuItemArray != null) {
                    int n2 = 0;
                    while (n2 < iMenuItemArray.length) {
                        if (actionListener != null) {
                            iMenuItemArray[n2].removeActionListener(actionListener);
                            iMenuItemArray[n2].addActionListener(actionListener);
                        }
                        vector.addElement(new MenuData(stringArray[n], iMenuItemArray[n2], iMenuInfo));
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    public static IMenuItem findIMenuItem(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MenuData menuData = (MenuData)enumeration.nextElement();
            if (!string.equals(menuData.getIMenuItem().getID())) continue;
            return menuData.getIMenuItem();
        }
        return null;
    }

    public static IMenuInfo findIMenuInfo(Vector vector, IMenuItem iMenuItem) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MenuData menuData = (MenuData)enumeration.nextElement();
            if (iMenuItem != menuData.getIMenuItem()) continue;
            return menuData.getIMenuInfo();
        }
        return null;
    }

    public static void enableMenuItem(Vector vector, String string, boolean bl) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            IMenuItem iMenuItem;
            MenuData menuData = (MenuData)enumeration.nextElement();
            if (!string.equals(menuData.getIMenuItem().getID()) || !((iMenuItem = menuData.getIMenuItem()).getComponent() instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)iMenuItem.getComponent();
            abstractButton.setEnabled(bl);
        }
    }

    public static void addVectors(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    public static Vector createMenuDataByID(Vector vector, Vector vector2) {
        Vector<MenuData> vector3 = new Vector<MenuData>();
        Enumeration enumeration = vector2.elements();
        block0: while (enumeration.hasMoreElements()) {
            MenuData menuData = (MenuData)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                MenuData menuData2 = (MenuData)enumeration2.nextElement();
                if (!menuData2.getIMenuItem().getID().equals(menuData.getIMenuItem().getID()) || !menuData2.getCategoryID().equals(menuData.getCategoryID())) continue;
                vector3.addElement(menuData2);
                continue block0;
            }
        }
        return vector3;
    }

    public static void substractVectors(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.removeElement(enumeration.nextElement());
        }
    }

    public static JMenu getMenu(JPopupMenu jPopupMenu, String string) {
        JMenu jMenu = null;
        int n = 0;
        while (n < jPopupMenu.getComponentCount()) {
            JMenu jMenu2;
            Component component = jPopupMenu.getComponentAtIndex(n);
            if (component instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)((Object)component)).getID())) {
                jMenu = (JMenu)((IMenuItemCategory)((Object)component)).getComponent();
                break;
            }
            if (component instanceof JMenu && (jMenu2 = MenuData.getMenu((JMenu)component, string)) != null) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    public static JMenu getMenu(JMenu jMenu, String string) {
        JMenu jMenu2 = null;
        int n = 0;
        while (n < jMenu.getMenuComponentCount()) {
            JMenu jMenu3;
            Component component = jMenu.getMenuComponent(n);
            if (component instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)((Object)component)).getID())) {
                jMenu2 = (JMenu)((IMenuItemCategory)((Object)component)).getComponent();
                break;
            }
            if (component instanceof JMenu && (jMenu3 = MenuData.getMenu((JMenu)component, string)) != null) {
                jMenu2 = jMenu3;
                break;
            }
            ++n;
        }
        return jMenu2;
    }

    public static JMenu getMenu(JMenuBar jMenuBar, String string) {
        JMenu jMenu = null;
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu2;
            JMenu jMenu3 = jMenuBar.getMenu(n);
            if (jMenu3 instanceof IMenuItemCategory && string.equals(((IMenuItemCategory)((Object)jMenu3)).getID())) {
                jMenu = (JMenu)((IMenuItemCategory)((Object)jMenu3)).getComponent();
                break;
            }
            if (jMenu3 instanceof JMenu && (jMenu2 = MenuData.getMenu(jMenu3, string)) != null) {
                jMenu = jMenu2;
                break;
            }
            ++n;
        }
        return jMenu;
    }

    public static boolean removeMenuItem(JMenu jMenu, IMenuItem iMenuItem) {
        boolean bl = false;
        int n = 0;
        while (n < jMenu.getMenuComponentCount()) {
            Component component = jMenu.getMenuComponent(n);
            if (component instanceof IMenuItem && component == iMenuItem) {
                jMenu.remove(n);
                bl = true;
                break;
            }
            if (component instanceof JMenu && MenuData.removeMenuItem((JMenu)component, iMenuItem)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }
}

