/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ButtonBar;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminOperation;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.DialogFrame;
import com.netscape.management.admserv.panel.IAdminOperationListener;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SNMPStatusPanel
extends PluginConfigPanel {
    ConsoleInfo _target;
    ConsoleInfo _consoleInfo;
    Hashtable _statusTable = new Hashtable();
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nAgentOn = _resource.getString("status", "AgentOn");
    static String _i18nAgentOff = _resource.getString("status", "AgentOff");
    static String _i18nAgentUnknown = _resource.getString("status", "AgentUnknown");
    static String _i18nOn = _resource.getString("status", "On");
    static String _i18nOff = _resource.getString("status", "Off");
    static String _i18nUnknown = _resource.getString("status", "Unknown");
    static String _i18nMasterAgent = _resource.getString("status", "MasterAgent");
    static String _i18nStatus = _resource.getString("status", "Status");
    static String _i18nCheckStatusButton = _resource.getString("status", "CheckStatus");
    static String _i18nRestartButton = _resource.getString("status", "Restart");
    static String _i18nStopButton = _resource.getString("status", "Stop");
    static String _i18nDialogTitleStop = _resource.getString("status", "DialogStopAgent");
    static String _i18nDialogTitleRestart = _resource.getString("status", "DialogRestartAgent");
    static String _i18nDialogTitleStatus = _resource.getString("status", "DialogStatusAgent");
    static String _i18nCheckStatusToolTip = _resource.getString("status", "CheckStatusToolTip");
    static String _i18nRestartToolTip = _resource.getString("status", "RestartToolTip");
    static String _i18nStopToolTip = _resource.getString("status", "StopToolTip");
    static Help _help;
    static String _cmdStatus;
    static String _cmdRestart;
    static String _cmdStop;
    JLabel _lblStatus;
    ButtonBar _buttons;
    String _agentColumn;
    ActionListener _btnListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(_cmdStatus)) {
                SNMPStatusPanel.this.checkStatus(SNMPStatusPanel.this._target, false);
            } else if (string.equals(_cmdRestart)) {
                SNMPStatusPanel.this.restart(SNMPStatusPanel.this._target);
            } else if (string.equals(_cmdStop)) {
                SNMPStatusPanel.this.stop(SNMPStatusPanel.this._target);
            } else {
                Debug.println((String)("SNMPStatusPanel: Unknown acction command " + string));
            }
        }
    };

    public SNMPStatusPanel(String string, ConsoleInfo consoleInfo) {
        super(string);
        this._target = this._consoleInfo = consoleInfo;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makePanel(), "North");
        _help = new Help(_resource);
        this.updateStatus();
    }

    public void showHelp() {
        _help.contextHelp("SNMPStatusHelp");
    }

    void updateStatus() {
        this._lblStatus.setVisible(true);
        this.validate();
        String string = (String)this._target.get("SERVER_NAME");
        String string2 = (String)this._statusTable.get(string);
        String string3 = string2 = string2 == null ? _i18nUnknown : string2;
        if (string2.equals(_i18nOn)) {
            this._lblStatus.setText(_i18nAgentOn);
        } else if (string2.equals(_i18nOff)) {
            this._lblStatus.setText(_i18nAgentOff);
        } else {
            this._lblStatus.setText(_i18nAgentUnknown);
        }
    }

    void updateStatus(String string) {
        String string2 = (String)this._statusTable.get(string);
        String string3 = string2 = string2 == null ? _i18nUnknown : string2;
        if (string2.equals(_i18nOn)) {
            this._lblStatus.setText(_i18nAgentOn);
        } else if (string2.equals(_i18nOff)) {
            this._lblStatus.setText(_i18nAgentOff);
        } else {
            this._lblStatus.setText(_i18nAgentUnknown);
        }
    }

    public void initialize() throws ConfigPanelException {
        this.checkStatus(this._consoleInfo, true);
    }

    public IConfigDataModel getDataModel() {
        return null;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) throws ValidationException {
        if (iConfigDataModel != null) {
            this._target = iConfigDataModel instanceof CGISNMPSetup ? ((CGISNMPSetup)iConfigDataModel).getConsoleInfo() : this._consoleInfo;
            this.updateStatus();
        }
    }

    public void resetContent() throws ConfigPanelException {
    }

    public void applyChanges() throws ValidationException {
    }

    public void registerEditComponents(EditMonitor editMonitor) {
    }

    protected JComponent makePanel() {
        JPanel jPanel = new JPanel();
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this._lblStatus = new JLabel(_i18nAgentUnknown);
        gBC.setInsets(10, 0, 10, 0);
        gBC.setGrid(0, 0, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._lblStatus, gBC);
        gBC.setInsets(10, 0, 10, 0);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)new JLabel(), gBC);
        this._buttons = new ButtonBar(new String[]{_cmdStatus, _cmdRestart, _cmdStop}, new String[]{_i18nCheckStatusButton, _i18nRestartButton, _i18nStopButton}, new String[]{_i18nCheckStatusToolTip, _i18nRestartToolTip, _i18nStopToolTip}, false);
        this._buttons.addActionListener(this._btnListener);
        this._buttons.setBorder(new EmptyBorder(0, 10, 0, 0));
        gBC.setInsets(10, 0, 10, 0);
        gBC.setGrid(1, 1, 1, 1);
        gBC.setSpace(1.0, 0.0, 12, 2);
        jPanel.add((Component)this._buttons, gBC);
        return jPanel;
    }

    protected void checkStatus(ConsoleInfo consoleInfo, boolean bl) {
        String string = "admin-serv/tasks/Operation/SNMPControl?ACTION=STATUS";
        AdminOperation adminOperation = new AdminOperation(consoleInfo, string);
        StatusCheckListener statusCheckListener = new StatusCheckListener(adminOperation);
        String string2 = _resource.getString("status", "checkstatus-SendRequest");
        if (string2 == null) {
            string2 = _i18nDialogTitleStatus + " ...";
        }
        adminOperation.monitorOperation(string2, statusCheckListener);
        if (bl || adminOperation.getDialog() != null || adminOperation.getFrame() != null) {
            return;
        }
        String string3 = _i18nDialogTitleStatus;
        DialogFrame dialogFrame = new DialogFrame(this, string3, adminOperation.getPanel());
        ((Component)((Object)dialogFrame)).setVisible(true);
        dialogFrame.dispose();
        ModalDialogUtil.sleep();
    }

    protected void restart(ConsoleInfo consoleInfo) {
        String string = "admin-serv/tasks/Operation/SNMPControl?ACTION=RESTART";
        AdminOperation adminOperation = new AdminOperation(consoleInfo, string);
        StopStartListener stopStartListener = new StopStartListener(adminOperation, false);
        String string2 = _resource.getString("status", "restart-SendRequest");
        if (string2 == null) {
            string2 = _i18nDialogTitleRestart + " ...";
        }
        adminOperation.monitorOperation(string2, stopStartListener);
        String string3 = _i18nDialogTitleRestart;
        DialogFrame dialogFrame = new DialogFrame(this, string3, adminOperation.getPanel());
        ((Component)((Object)dialogFrame)).setVisible(true);
        dialogFrame.dispose();
        ModalDialogUtil.sleep();
        this.checkStatus(consoleInfo, false);
    }

    protected void stop(ConsoleInfo consoleInfo) {
        String string = "admin-serv/tasks/Operation/SNMPControl?ACTION=STOP";
        AdminOperation adminOperation = new AdminOperation(consoleInfo, string);
        StopStartListener stopStartListener = new StopStartListener(adminOperation, true);
        String string2 = _resource.getString("status", "stop-SendRequest");
        if (string2 == null) {
            string2 = _i18nDialogTitleStop + " ...";
        }
        adminOperation.monitorOperation(string2, stopStartListener);
        String string3 = _i18nDialogTitleStop;
        DialogFrame dialogFrame = new DialogFrame(this, string3, adminOperation.getPanel());
        ((Component)((Object)dialogFrame)).setVisible(true);
        dialogFrame.dispose();
        ModalDialogUtil.sleep();
        this.checkStatus(consoleInfo, false);
    }

    static {
        _cmdStatus = "status";
        _cmdRestart = "restart";
        _cmdStop = "stop";
    }

    class StopStartListener
    implements IAdminOperationListener {
        AdminOperation _op;
        boolean _stop;

        public StopStartListener(AdminOperation adminOperation, boolean bl) {
            this._op = adminOperation;
            this._stop = bl;
        }

        public void cgiRequestCompleted(ConsoleInfo consoleInfo) {
            String string = _i18nUnknown;
            if (this._op.getResultStatus() == 0) {
                string = this._stop ? _i18nOff : _i18nOn;
            }
            String string2 = (String)consoleInfo.get("SERVER_NAME");
            SNMPStatusPanel.this._statusTable.put(string2, string);
            SNMPStatusPanel.this.updateStatus(string2);
        }
    }

    class StatusCheckListener
    implements IAdminOperationListener {
        AdminOperation _op;

        public StatusCheckListener(AdminOperation adminOperation) {
            this._op = adminOperation;
        }

        public void cgiRequestCompleted(ConsoleInfo consoleInfo) {
            Object object;
            String string = _i18nUnknown;
            if (this._op.getResultStatus() == 0) {
                object = this._op.getResultData();
                String string2 = (String)((Hashtable)object).get("status");
                if (string2 == null) {
                    Debug.println((String)"status attr missing");
                } else {
                    string = string2.equalsIgnoreCase("ON") ? _i18nOn : _i18nOff;
                }
            }
            object = (String)consoleInfo.get("SERVER_NAME");
            SNMPStatusPanel.this._statusTable.put(object, string);
            SNMPStatusPanel.this.updateStatus((String)object);
        }
    }
}

