/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.FilteredInputDocument;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGIAggregateDataModel;
import com.netscape.management.admserv.panel.CGIDataModel;
import com.netscape.management.admserv.panel.CGIServerSetup;
import com.netscape.management.admserv.panel.FilterEditList;
import com.netscape.management.admserv.panel.HostEditList;
import com.netscape.management.admserv.panel.IPAddrEditList;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.HostException;
import com.netscape.management.client.util.IPAddressValidator;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class NetworkConfigPanel
extends PluginConfigPanel
implements SuiConstants {
    IConfigDataModel _configData;
    private boolean _unixServer;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nProcessGroupbox = _resource.getString("network", "ProcessGroupbox");
    static String _i18nIPAddr;
    static String _i18nHost;
    static String _i18nPort;
    static String _i18nServerUID;
    static String _i18nMsgBadPortFormat;
    static String _i18nConnectGroupbox;
    static String _i18nHostNameFilter;
    static String _i18nIPAddrFilter;
    static String _i18nEditHostDialog;
    static String _i18nEditIPAddrDialog;
    static String _i18nMsgEnterHost;
    static String _i18nMsgCanUseWildcards;
    static String _i18nMsgEnterIPAddr;
    static String _i18nMsgEnterIPv6Addr;
    static String _i18nMsgEnterIPv4IPv6Addr;
    static String _i18nHostFormat;
    static String _i18nIPAddrFormat;
    static String _i18nAddHostDialog;
    static String _i18nAddIPAddrDialog;
    static String _i18nPortRange;
    static String _i18nFilterChoice;
    static String _i18nIPAddressToolTip;
    static String _i18nPortToolTip;
    static String _i18nUIDToolTip;
    static String _i18nHostListToolTip;
    static String _i18nIPListToolTip;
    Help _help;
    JLabel _lblPort;
    JLabel _lblAddress;
    JLabel _lblServerUID;
    JTextField _txtPort;
    JTextField _txtAddress;
    JTextField _txtServerUID;
    FilterEditList _hostList;
    FilterEditList _ipList;
    JComboBox _filterChoice;
    JPanel _filterList;
    ActionListener _filterChoiceListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if ((String)NetworkConfigPanel.this._filterChoice.getSelectedItem() == _i18nHostNameFilter) {
                NetworkConfigPanel.this._card.show(NetworkConfigPanel.this._filterList, "hostList");
            } else {
                NetworkConfigPanel.this._card.show(NetworkConfigPanel.this._filterList, "ipList");
            }
        }
    };
    CardLayout _card;

    public NetworkConfigPanel(String string, IConfigDataModel iConfigDataModel, boolean bl) {
        super(string);
        this._configData = iConfigDataModel;
        this._unixServer = bl;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("networkHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) {
        this._configData = iConfigDataModel;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws RemoteRequestException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        if (this._configData instanceof CGIDataModel) {
            ((CGIDataModel)this._configData).setDialogParent(this.getParent());
        } else if (this._configData instanceof CGIAggregateDataModel) {
            ((CGIAggregateDataModel)this._configData).setDialogParent(this.getParent());
        }
        this.setPanelContent(this._configData);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ValidationException {
        this.validateData();
        this.getPanelContent(this._configData);
    }

    public void validateData() throws ValidationException {
        try {
            int n = Integer.parseInt(this._txtPort.getText());
            if (n < 1 || n > 65535) {
                throw new ValidationException("", _i18nPortRange);
            }
        }
        catch (Exception exception) {
            throw new ValidationException(_i18nPort + this._txtPort.getText(), _i18nPortRange);
        }
        this.validateIPAddress(this.getAddress());
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor(this._txtPort);
        editMonitor.monitor(this._txtAddress);
        if (this._unixServer) {
            editMonitor.monitor(this._txtServerUID);
        }
        this._hostList.addListDataListener(editMonitor);
        this._ipList.addListDataListener(editMonitor);
    }

    public void validateIPAddress(String string) throws ValidationException {
        if (string.length() == 0) {
            return;
        }
        IPAddressValidator iPAddressValidator = new IPAddressValidator(string, true);
        try {
            iPAddressValidator.validate();
        }
        catch (HostException hostException) {
            String string2;
            switch (hostException.getResultCode()) {
                case 1: {
                    string2 = _i18nMsgEnterIPAddr;
                    break;
                }
                case 2: {
                    string2 = _i18nMsgEnterIPv6Addr;
                    break;
                }
                case 3: {
                    string2 = _i18nMsgEnterIPv4IPv6Addr;
                    break;
                }
                default: {
                    string2 = _i18nMsgEnterIPAddr;
                }
            }
            throw new ValidationException("", string2);
        }
    }

    public void setPanelContent(IConfigDataModel iConfigDataModel) {
        String string = iConfigDataModel.getAttribute("configuration.nsserverport");
        this.setPort(string);
        this._lblPort.setText(_i18nPort);
        this._txtPort.setEnabled(true);
        String string2 = iConfigDataModel.getAttribute("configuration.nsserveraddress");
        this.setAddress(string2);
        this._lblAddress.setText(_i18nIPAddr);
        this._txtAddress.setEnabled(true);
        if (this._unixServer) {
            this.setServerUID(iConfigDataModel.getAttribute("configuration.nssuitespotuser"));
        }
        this._hostList.setList(CGIServerSetup.parseFilterList(iConfigDataModel.getAttribute("configuration.nsadminaccesshosts")));
        this._ipList.setList(CGIServerSetup.parseFilterList(iConfigDataModel.getAttribute("configuration.nsadminaccessaddresses")));
    }

    public void getPanelContent(IConfigDataModel iConfigDataModel) throws ValidationException {
        iConfigDataModel.setAttribute("configuration.nsserverport", this._txtPort.getText());
        iConfigDataModel.setAttribute("configuration.nsserveraddress", this.getAddress());
        iConfigDataModel.setAttribute("configuration.nsadminaccesshosts", CGIServerSetup.encodeFilterList(this._hostList.getList()));
        iConfigDataModel.setAttribute("configuration.nsadminaccessaddresses", CGIServerSetup.encodeFilterList(this._ipList.getList()));
        if (this._unixServer) {
            iConfigDataModel.setAttribute("configuration.nssuitespotuser", this.getServerUID());
        }
    }

    protected JComponent makeConfigPanel() {
        JPanel jPanel = new JPanel();
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this.createProcessGroup(), gBC);
        gBC.setInsets(12, 0, 0, 0);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(1.0, 1.0, 17, 1);
        jPanel.add((Component)this.createConnectGroup(), gBC);
        return jPanel;
    }

    private JPanel createProcessGroup() {
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BaseConfigPanel.createGroupBorder(_i18nProcessGroupbox));
        this._lblPort = new JLabel(_i18nPort);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblPort, gBC);
        this._txtPort = new JTextField(6);
        ((JTextComponent)this._txtPort).setDocument(FilteredInputDocument.allowDigitsOnly());
        gBC.setInsets(0, 9, 0, 0);
        gBC.setGrid(1, 0, 1, 1);
        gBC.setSpace(0.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtPort, gBC);
        this._lblPort.setLabelFor(this._txtPort);
        this._lblPort.setToolTipText(_i18nPortToolTip);
        this._txtPort.setToolTipText(_i18nPortToolTip);
        JLabel jLabel = new JLabel("");
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(2, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)jLabel, gBC);
        this._lblAddress = new JLabel(_i18nIPAddr);
        gBC.setInsets(6, 0, 0, 0);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblAddress, gBC);
        this._txtAddress = new JTextField(16);
        ((JTextComponent)this._txtAddress).setDocument(FilteredInputDocument.allowIPandIPv6AddressOnly());
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, 1, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtAddress, gBC);
        this._lblAddress.setLabelFor(this._txtAddress);
        this._lblAddress.setToolTipText(_i18nIPAddressToolTip);
        this._txtAddress.setToolTipText(_i18nIPAddressToolTip);
        if (!this._unixServer) {
            return jPanel;
        }
        this._lblServerUID = new JLabel(_i18nServerUID);
        gBC.setInsets(6, 0, 0, 0);
        gBC.setGrid(0, 2, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblServerUID, gBC);
        this._txtServerUID = new JTextField(16);
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, 2, 2, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtServerUID, gBC);
        this._lblServerUID.setLabelFor(this._txtServerUID);
        this._lblServerUID.setToolTipText(_i18nUIDToolTip);
        this._txtServerUID.setToolTipText(_i18nUIDToolTip);
        return jPanel;
    }

    private JPanel createConnectGroup() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BaseConfigPanel.createGroupBorder(_i18nConnectGroupbox));
        this._filterChoice = new JComboBox();
        this._filterChoice.addItem(_i18nHostNameFilter);
        this._filterChoice.addItem(_i18nIPAddrFilter);
        this._filterChoice.addActionListener(this._filterChoiceListener);
        this._filterChoice.setToolTipText(_i18nFilterChoice);
        this._card = new CardLayout();
        this._filterList = new JPanel(this._card);
        this._hostList = new HostEditList();
        this._hostList.getAccessibleContext().setAccessibleDescription(_i18nHostListToolTip);
        this._hostList.setToolTipText(_i18nHostListToolTip);
        this._ipList = new IPAddrEditList();
        this._ipList.getAccessibleContext().setAccessibleDescription(_i18nIPListToolTip);
        this._ipList.setToolTipText(_i18nIPListToolTip);
        this._filterList.add((Component)this._hostList, "hostList");
        this._filterList.add((Component)this._ipList, "ipList");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this._filterChoice, "West");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this._filterList, "Center");
        return jPanel;
    }

    private JPanel createHostRestrictGroup() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._hostList = new HostEditList();
        jPanel.add((Component)this._hostList, "North");
        return jPanel;
    }

    private JPanel createIPRestrictGroup() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._ipList = new IPAddrEditList();
        jPanel.add((Component)this._ipList, "North");
        return jPanel;
    }

    public void setPort(String string) {
        this._txtPort.setText(string != null ? string : "");
    }

    public String getPort() {
        String string = this._txtPort.getText();
        return string;
    }

    public void setAddress(String string) {
        this._txtAddress.setText(string != null ? string : "");
    }

    public String getAddress() {
        String string = this._txtAddress.getText();
        return string;
    }

    public void setServerUID(String string) {
        this._txtServerUID.setText(string != null ? string : "");
        if (string != null) {
            this._txtServerUID.setEnabled(string.equals("root"));
        }
    }

    public String getServerUID() {
        String string = this._txtServerUID.getText();
        return string;
    }

    static {
        _i18nPort = _resource.getString("network", "Port");
        _i18nHost = _resource.getString("network", "Host");
        _i18nIPAddr = _resource.getString("network", "IPAddr");
        _i18nMsgCanUseWildcards = _resource.getString("network", "MsgCanUseWildcards");
        _i18nServerUID = _resource.getString("network", "ServerUID");
        _i18nMsgBadPortFormat = _resource.getString("network", "MsgBadPortFormat");
        _i18nConnectGroupbox = _resource.getString("network", "ConnectGroupbox");
        _i18nHostNameFilter = _resource.getString("network", "HostNameFilter");
        _i18nIPAddrFilter = _resource.getString("network", "IPAddrFilter");
        _i18nEditHostDialog = _resource.getString("network", "EditHostDialog");
        _i18nEditIPAddrDialog = _resource.getString("network", "EditIPAddrDialog");
        _i18nMsgEnterHost = _resource.getString("network", "MsgEnterHost");
        _i18nMsgEnterIPAddr = _resource.getString("network", "MsgEnterIPAddr");
        _i18nMsgEnterIPv6Addr = _resource.getString("network", "MsgEnterIPv6Addr");
        _i18nMsgEnterIPv4IPv6Addr = _resource.getString("network", "MsgEnterIPv4IPv6Addr");
        _i18nHostFormat = _resource.getString("network", "HostFormat");
        _i18nIPAddrFormat = _resource.getString("network", "IPAddrFormat");
        _i18nAddHostDialog = _resource.getString("network", "AddHostDialog");
        _i18nAddIPAddrDialog = _resource.getString("network", "AddIPAddrDialog");
        _i18nPortRange = _resource.getString("common", "PortRange");
        _i18nFilterChoice = _resource.getString("network", "ToolTipFilterChoice");
        _i18nIPAddressToolTip = _resource.getString("network", "IPAddressToolTip");
        _i18nPortToolTip = _resource.getString("network", "PortToolTip");
        _i18nUIDToolTip = _resource.getString("network", "serverUIDToolTip");
        _i18nHostListToolTip = _resource.getString("network", "HostListToolTip");
        _i18nIPListToolTip = _resource.getString("network", "IPListToolTip");
    }
}

