/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.EditableList;
import com.netscape.management.admserv.panel.ManagerEditPanel;
import com.netscape.management.admserv.panel.SNMPManagerPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ManagerList
extends EditableList {
    ManagerEditPanel _editPanel;
    JPanel _detailsPanel;
    JLabel _lblDetailsManager;
    JLabel _lblDetailsPort;
    JLabel _lblDetailsCommunity;
    Vector _managers;
    int _editEntryIdx = -1;
    static String _i18nEditMgr = EditableList._resource.getString("snmpmgr", "EditMgrToolTip");
    static String _i18nAddMgr = EditableList._resource.getString("snmpmgr", "AddMgrToolTip");
    static String _i18nRemoveMgr = EditableList._resource.getString("snmpmgr", "RemoveMgrToolTip");

    public ManagerList(Vector vector) {
        this.setManagers(vector);
    }

    public void setManagers(Vector vector) {
        this._managers = vector;
        this.setList(this.getManagerNames(this._managers));
    }

    Vector getManagerNames(Vector vector) {
        Vector vector2 = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Hashtable hashtable = (Hashtable)vector.elementAt(n);
            vector2.addElement(hashtable.get("mananger"));
            ++n;
        }
        return vector2;
    }

    public JPanel getEditPanel() {
        this._editPanel = new ManagerEditPanel();
        JTextField[] jTextFieldArray = this._editPanel.getTextComponents();
        this.setEditPanelInitalFocusComponent(jTextFieldArray[0]);
        this.setEditPanelCommitOnEnterComponents(jTextFieldArray);
        return this._editPanel;
    }

    public String getEditTitle() {
        return SNMPManagerPanel._i18nEditDialogTitle;
    }

    public String getAddTitle() {
        return SNMPManagerPanel._i18nAddDialogTitle;
    }

    public String getEditToolTip() {
        return _i18nEditMgr;
    }

    public String getAddToolTip() {
        return _i18nAddMgr;
    }

    public String getRemoveToolTip() {
        return _i18nRemoveMgr;
    }

    public ResourceSet getHelpResourceSet() {
        return SNMPManagerPanel._resource;
    }

    public String getHelpToken() {
        return "editSNMPManagerHelp";
    }

    public void validateEdit() throws ValidationException {
        String string = this._editPanel.getManager();
        if (string.length() == 0) {
            throw new ValidationException(SNMPManagerPanel._i18nManager, SNMPManagerPanel._i18nMsgEnterManager);
        }
        int n = this.findManager(string);
        if (n >= 0) {
            if (this._editEntryIdx == -1) {
                throw new ValidationException(SNMPManagerPanel._i18nManager, SNMPManagerPanel._i18nMsgEntryExists);
            }
            if (n != this._editEntryIdx) {
                throw new ValidationException(SNMPManagerPanel._i18nManager, SNMPManagerPanel._i18nMsgCanNotRename);
            }
        }
    }

    public JPanel getDetailsPanel() {
        this._detailsPanel = this.createDetailsPanel();
        return this._detailsPanel;
    }

    public String getDetailsTitle() {
        return SNMPManagerPanel._i18nDetailsGroupbox;
    }

    private JPanel createDetailsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GBC gBC = new GBC();
        JLabel jLabel = new JLabel(SNMPManagerPanel._i18nManager);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(0.0, 0.0, 18, 1);
        jPanel.add((Component)jLabel, gBC);
        this._lblDetailsManager = new JLabel(" ");
        gBC.setInsets(0, 10, 0, 0);
        gBC.setGrid(1, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 18, 2);
        jPanel.add((Component)this._lblDetailsManager, gBC);
        jLabel = new JLabel(SNMPManagerPanel._i18nPort);
        gBC.setInsets(10, 0, 0, 0);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(0.0, 0.0, 18, 2);
        jPanel.add((Component)jLabel, gBC);
        this._lblDetailsPort = new JLabel(" ");
        gBC.setInsets(10, 10, 0, 0);
        gBC.setGrid(1, 1, 1, 1);
        gBC.setSpace(1.0, 0.0, 18, 2);
        jPanel.add((Component)this._lblDetailsPort, gBC);
        jLabel = new JLabel(SNMPManagerPanel._i18nCommunity);
        gBC.setInsets(10, 0, 0, 0);
        gBC.setGrid(0, 2, 1, 1);
        gBC.setSpace(0.0, 0.0, 18, 2);
        jPanel.add((Component)jLabel, gBC);
        this._lblDetailsCommunity = new JLabel(" ");
        gBC.setInsets(10, 10, 0, 0);
        gBC.setGrid(1, 2, 1, 1);
        gBC.setSpace(1.0, 0.0, 18, 2);
        jPanel.add((Component)this._lblDetailsCommunity, gBC);
        return jPanel;
    }

    public void setEditPanelParameters(String string) {
        if (string == null) {
            this._editPanel.setCommunity("public");
            this._editPanel.setPort("162");
            this._editPanel.setManager("");
            this._editEntryIdx = -1;
        } else {
            int n = this.findManager(string);
            if (n >= 0) {
                this._editEntryIdx = n;
                Hashtable hashtable = (Hashtable)this._managers.elementAt(n);
                String string2 = (String)hashtable.get("mananger");
                String string3 = (String)hashtable.get("port");
                String string4 = (String)hashtable.get("community");
                this._editPanel.setManager(string2);
                this._editPanel.setPort(string3);
                this._editPanel.setCommunity(string4);
            } else {
                Debug.println((String)("ERROR: Manager not found: " + string));
            }
        }
    }

    public String getEditPanelItem() {
        return this._editPanel.getManager();
    }

    private int findManager(String string) {
        return CGISNMPSetup.findEntry(this._managers, "mananger", string);
    }

    public void createItem(String string) {
        this._managers.addElement(CGISNMPSetup.createManagerEntry(new String(string), new String(this._editPanel.getPort()), new String(this._editPanel.getCommunity())));
    }

    public void removeItem(String string) {
        int n = this.findManager(string);
        if (n >= 0) {
            this._managers.removeElementAt(n);
        } else {
            Debug.println((String)("ERROR: Manager not found: " + string));
        }
    }

    public void updateItem(String string, boolean bl) {
        int n = this.findManager(string);
        if (n >= 0) {
            Hashtable hashtable = CGISNMPSetup.createManagerEntry(new String(this._editPanel.getManager()), new String(this._editPanel.getPort()), new String(this._editPanel.getCommunity()));
            this._managers.setElementAt(hashtable, n);
        } else {
            Debug.println((String)("ERROR: Manager not found: " + string));
        }
    }

    private void dumpData() {
        if (this._managers.size() == 0) {
            Debug.println((String)"No entries");
            return;
        }
        int n = 0;
        while (n < this._managers.size()) {
            Hashtable hashtable = (Hashtable)this._managers.elementAt(n);
            String string = (String)hashtable.get("mananger");
            String string2 = (String)hashtable.get("port");
            String string3 = (String)hashtable.get("community");
            Debug.print((String)(n + "=[" + string + " " + string2 + " " + string3 + "] "));
            ++n;
        }
        Debug.println((String)"");
    }

    public void selectItem(String string) {
        if (string == null) {
            this._lblDetailsManager.setText("");
            this._lblDetailsPort.setText("");
            this._lblDetailsCommunity.setText("");
            return;
        }
        int n = this.findManager(string);
        if (n >= 0) {
            Hashtable hashtable = (Hashtable)this._managers.elementAt(n);
            String string2 = (String)hashtable.get("mananger");
            String string3 = (String)hashtable.get("port");
            String string4 = (String)hashtable.get("community");
            this._lblDetailsManager.setText(string2);
            this._lblDetailsPort.setText(string3);
            this._lblDetailsCommunity.setText(string4);
        } else {
            Debug.println((String)("ERROR: Manager not found: " + string));
        }
    }
}

