/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGILoggingSetup;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleByteTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LoggingConfigPanel
extends PluginConfigPanel {
    IConfigDataModel _configData;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nLogFile = _resource.getString("logging", "LogFile");
    static String _i18nErrorLogGroupbox;
    static String _i18nAccessLogGroupbox;
    Help _help;
    public static final int topInset = 12;
    public static final int rghtColInset = 6;
    JLabel _lblAccessFile;
    JLabel _lblErrorFile;
    JTextField _txtAccessFile;
    JTextField _txtErrorFile;

    public LoggingConfigPanel(String string, ConsoleInfo consoleInfo) {
        super(string);
        this._configData = new CGILoggingSetup(consoleInfo);
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("loggingHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) {
        this._configData = iConfigDataModel;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws ConfigPanelException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this.setPanelContent(this._configData);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ValidationException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor(this._txtAccessFile);
        editMonitor.monitor(this._txtErrorFile);
    }

    public void setPanelContent(IConfigDataModel iConfigDataModel) {
        String string = iConfigDataModel.getAttribute("configuration.nsaccesslog");
        this._txtAccessFile.setText(string == null ? "" : string);
        string = iConfigDataModel.getAttribute("configuration.nserrorlog");
        this._txtErrorFile.setText(string == null ? "" : string);
    }

    public void getPanelContent(IConfigDataModel iConfigDataModel) throws ValidationException {
        iConfigDataModel.setAttribute("configuration.nsaccesslog", this._txtAccessFile.getText());
        iConfigDataModel.setAttribute("configuration.nserrorlog", this._txtErrorFile.getText());
    }

    private JPanel makeConfigPanel() {
        JPanel jPanel = new JPanel();
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this._lblAccessFile = new JLabel(_i18nLogFile);
        this._txtAccessFile = new SingleByteTextField(16);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this.createLogGroup(_i18nAccessLogGroupbox, this._lblAccessFile, this._txtAccessFile), gBC);
        this._lblErrorFile = new JLabel(_i18nLogFile);
        this._txtErrorFile = new SingleByteTextField(16);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this.createLogGroup(_i18nErrorLogGroupbox, this._lblErrorFile, this._txtErrorFile), gBC);
        return jPanel;
    }

    private JPanel createLogGroup(String string, JLabel jLabel, JTextField jTextField) {
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BaseConfigPanel.createGroupBorder(string));
        jLabel.setFont(BaseConfigPanel.getLabelFont());
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(0.0, 0.0, 17, 0);
        jPanel.add((Component)jLabel, gBC);
        gBC.setInsets(0, 6, 0, 0);
        gBC.setGrid(1, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)jTextField, gBC);
        return jPanel;
    }

    static {
        _i18nAccessLogGroupbox = _resource.getString("logging", "AccessLogGroupbox");
        _i18nErrorLogGroupbox = _resource.getString("logging", "ErrorLogGroupbox");
    }
}

