/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv;

import com.netscape.management.admserv.AdminServer;
import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.panel.AdminConfigPanel;
import com.netscape.management.admserv.panel.DialogFrame;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.admserv.panel.RestartOperation;
import com.netscape.management.admserv.panel.StopOperation;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class AdminServerNode
extends ResourceObject
implements IMenuInfo {
    public static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.admserv");
    public static Icon _icon = new RemoteImage(_resource.getString("admin", "smallIcon"));
    public static String _i18nMenuConfig;
    public static String _i18nMenuRestart;
    public static String _i18nMenuStop;
    public static String _i18nDescrMenuConfig;
    public static String _i18nDescrMenuRestart;
    public static String _i18nDescrMenuStop;
    public static String _i18nStopTask;
    public static String _i18nAckStop;
    public static String MENU_CONFIG;
    public static String MENU_RESTART;
    public static String MENU_STOP;
    private BaseConfigPanel _configPanel;
    private boolean _menuConfigEnabled;
    private boolean _menuRestartEnabled;
    private boolean _menuStopEnabled;
    private ConsoleInfo _consoleInfo;

    public AdminServerNode(ConsoleInfo consoleInfo, String[] stringArray) {
        super(AdminServer._resource.getString("admin", "title"));
        this._consoleInfo = consoleInfo;
        this._menuConfigEnabled = this.findTask("task.ServerSetup", stringArray);
        this._menuRestartEnabled = this.findTask("task.Restart", stringArray);
        this._menuStopEnabled = this.findTask("task.Stop", stringArray);
        ((DefaultMutableTreeNode)((Object)this)).setAllowsChildren(true);
    }

    private boolean findTask(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Icon getIcon() {
        return _icon;
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("OBJECT") || string.equals("CONTEXT")) {
            return new IMenuItem[]{new MenuItemSeparator(), new MenuItemText(MENU_CONFIG, _i18nMenuConfig, _i18nDescrMenuConfig, this._menuConfigEnabled), new MenuItemText(MENU_RESTART, _i18nMenuRestart, _i18nDescrMenuRestart, this._menuRestartEnabled), new MenuItemText(MENU_STOP, _i18nMenuStop, _i18nDescrMenuStop, this._menuStopEnabled)};
        }
        return null;
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iPage instanceof ResourcePage) {
            if (iMenuItem.getID().equals(MENU_CONFIG)) {
                ResourcePage resourcePage = (ResourcePage)iPage;
                this._configPanel = null;
                resourcePage.setCustomPanel(this.getCustomPanel());
            } else if (iMenuItem.getID().equals(MENU_STOP)) {
                ResourcePage resourcePage = (ResourcePage)iPage;
                int n = SuiOptionPane.showConfirmDialog((Component)resourcePage, (Object)_i18nAckStop, (String)_i18nStopTask, (int)0);
                if (n != 0) {
                    return;
                }
                StopOperation stopOperation = new StopOperation(this._consoleInfo);
                stopOperation.monitorOperation("");
                String string = AdminServer._resource.getString("taskName", "stop");
                DialogFrame dialogFrame = new DialogFrame((Component)resourcePage, string, stopOperation.getPanel());
                ((Component)((Object)dialogFrame)).setVisible(true);
                dialogFrame.dispose();
                ModalDialogUtil.sleep();
            } else if (iMenuItem.getID().equals(MENU_RESTART)) {
                ResourcePage resourcePage = (ResourcePage)iPage;
                if (!this.canRestartFromConsole((JPanel)resourcePage)) {
                    return;
                }
                RestartOperation restartOperation = new RestartOperation(this._consoleInfo);
                restartOperation.monitorOperation("");
                String string = AdminServer._resource.getString("taskName", "restart");
                DialogFrame dialogFrame = new DialogFrame((Component)resourcePage, string, restartOperation.getPanel());
                ((Component)((Object)dialogFrame)).setVisible(true);
                dialogFrame.dispose();
                ModalDialogUtil.sleep();
            } else {
                Debug.println((String)("Not Yet Implemented: " + iMenuItem));
            }
        }
    }

    private boolean canRestartFromConsole(JPanel jPanel) {
        IRestartControl iRestartControl = (IRestartControl)this._consoleInfo.get("RESTART_CONTROL");
        if (iRestartControl != null) {
            if (!iRestartControl.canRestartFromConsole()) {
                String string = AdminServer._resource.getString("restart", "canNotRestart");
                SuiOptionPane.showMessageDialog((Component)jPanel, (Object)string, (String)this.getName(), (int)0);
                return false;
            }
        } else {
            Debug.println((String)"RestartOperation: restart activator not in ConsoleInfo");
        }
        return true;
    }

    public Component getCustomPanel() {
        if (!this._menuConfigEnabled) {
            return null;
        }
        if (this._configPanel == null || !this._configPanel.isInitialized()) {
            this._configPanel = new BaseConfigPanel(new AdminConfigPanel(this._consoleInfo));
        }
        return this._configPanel;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return false;
    }

    static {
        ((RemoteImage)_icon).setDescription(_resource.getString("admin", "smallIcon-description"));
        _i18nMenuConfig = _resource.getString("menu", "Config");
        _i18nMenuRestart = _resource.getString("menu", "Restart");
        _i18nMenuStop = _resource.getString("menu", "Stop");
        _i18nDescrMenuConfig = _resource.getString("menuDescription", "ConfigAdmin");
        _i18nDescrMenuRestart = _resource.getString("menuDescription", "RestartAdmin");
        _i18nDescrMenuStop = _resource.getString("menuDescription", "StopAdmin");
        _i18nAckStop = _resource.getString("stop", "ack");
        _i18nStopTask = _resource.getString("taskName", "stop");
        MENU_CONFIG = "CONFIG";
        MENU_RESTART = "RESTART";
        MENU_STOP = "STOP";
    }
}

