/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Logger {
    public static final int FATAL = Integer.MIN_VALUE;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int DEBUG = 4;
    static FieldPosition position = new FieldPosition(1);
    protected boolean custom = true;
    protected Writer sink = defaultSink;
    String path;
    protected String name;
    protected static Writer defaultSink = new PrintWriter(System.err);
    protected static Hashtable loggers = new Hashtable(5);
    private int level = 2;
    protected boolean timestamp = true;
    protected boolean timestampRaw = false;
    protected String timestampFormat = "yyyy-MM-dd HH:mm:ss";
    protected SimpleDateFormat timestampFormatter = new SimpleDateFormat(this.timestampFormat);

    public synchronized void close() {
        this.sink = null;
        loggers.remove(this.getName());
    }

    public abstract void flush();

    protected String formatTimestamp(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        this.formatTimestamp(l, stringBuffer);
        return stringBuffer.toString();
    }

    protected void formatTimestamp(long l, StringBuffer stringBuffer) {
        if (!this.timestamp) {
            return;
        }
        if (this.timestampRaw) {
            stringBuffer.append(Long.toString(l));
            return;
        }
        Date date = new Date(l);
        this.timestampFormatter.format(date, stringBuffer, position);
    }

    public static Logger getLogger(String string) {
        return (Logger)loggers.get(string);
    }

    public static Enumeration getLoggerNames() {
        return loggers.keys();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getTimestampFormat() {
        if (this.timestampRaw) {
            return "msec";
        }
        return this.timestampFormat;
    }

    public int getVerbosityLevel() {
        return this.level;
    }

    public boolean isOpen() {
        return this.sink != null;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public final void log(String string) {
        this.log(string, 3);
    }

    public final void log(String string, int n) {
        if (this.matchVerbosityLevel(n)) {
            this.realLog(string);
        }
    }

    public static void log(String string, String string2) {
        Logger logger = Logger.getLogger(string);
        if (logger != null) {
            logger.log(string2);
        }
    }

    public static void log(String string, String string2, int n) {
        Logger logger = Logger.getLogger(string);
        if (logger != null) {
            logger.log(string2, n);
        }
    }

    public final void log(String string, Throwable throwable, int n) {
        if (this.matchVerbosityLevel(n)) {
            this.realLog(string, throwable);
        }
    }

    public boolean matchVerbosityLevel(int n) {
        return n <= this.getVerbosityLevel();
    }

    public void open() {
        if (this.path == null) {
            return;
        }
        try {
            File file = new File(this.path);
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            this.sink = new FileWriter(this.path);
        }
        catch (IOException iOException) {
            System.err.print("Unable to open log file: " + this.path + "! ");
            System.err.println(" Using stderr as the default.");
            this.sink = defaultSink;
        }
    }

    public static void putLogger(Logger logger) {
        loggers.put(logger.getName(), logger);
    }

    protected abstract void realLog(String var1);

    protected abstract void realLog(String var1, Throwable var2);

    public static void removeLogger(Logger logger) {
        loggers.remove(logger.getName());
    }

    public void setCustomOutput(String string) {
        if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            this.custom = true;
        } else if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            this.custom = false;
        }
    }

    public static void setDefaultSink(Writer writer) {
        defaultSink = writer;
    }

    public void setName(String string) {
        this.name = string;
        Logger.putLogger(this);
    }

    public void setPath(String string) {
        if (File.separatorChar == '/') {
            this.path = string.replace('\\', '/');
        } else if (File.separatorChar == '\\') {
            this.path = string.replace('/', '\\');
        }
    }

    public void setTimestamp(String string) {
        if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            this.timestamp = true;
        } else if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            this.timestamp = false;
        }
    }

    public void setTimestampFormat(String string) {
        if (string.equalsIgnoreCase("msec")) {
            this.timestampRaw = true;
        } else {
            this.timestampRaw = false;
            this.timestampFormat = string;
            this.timestampFormatter = new SimpleDateFormat(this.timestampFormat);
        }
    }

    public void setVerbosityLevel(int n) {
        this.level = n;
    }

    public void setVerbosityLevel(String string) {
        if ("warning".equalsIgnoreCase(string)) {
            this.level = 2;
        } else if ("fatal".equalsIgnoreCase(string)) {
            this.level = Integer.MIN_VALUE;
        } else if ("error".equalsIgnoreCase(string)) {
            this.level = 1;
        } else if ("information".equalsIgnoreCase(string)) {
            this.level = 3;
        } else if ("debug".equalsIgnoreCase(string)) {
            this.level = 4;
        }
    }
}

