/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.TagCache;
import org.apache.jasper.compiler.TagGeneratorBase;
import org.apache.jasper.compiler.TagLibraries;

public class TagBeginGenerator
extends TagGeneratorBase
implements ServiceMethodPhase {
    String prefix;
    String shortTagName;
    Hashtable attrs;
    TagLibraryInfo tli;
    TagInfo ti;
    TagAttributeInfo[] attributes;
    String baseVarName;
    String thVarName;
    TagCache tc;
    TagData tagData;
    Mark start;
    TagLibraries libraries;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$BodyTag;

    public TagBeginGenerator(Mark mark, String string, String string2, Hashtable hashtable, TagLibraryInfo tagLibraryInfo, TagInfo tagInfo, TagLibraries tagLibraries, Stack stack, Hashtable hashtable2) throws JasperException {
        this.setTagHandlerStack(stack);
        this.setTagVarNumbers(hashtable2);
        this.prefix = string;
        this.shortTagName = string2;
        this.attrs = hashtable;
        this.tli = tagLibraryInfo;
        this.ti = tagInfo;
        this.attributes = tagInfo.getAttributes();
        this.baseVarName = this.getTagVarName(string, string2);
        this.thVarName = "_jspx_th_" + this.baseVarName;
        this.start = mark;
        this.libraries = tagLibraries;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String convertString(Class clazz, String string, ServletWriter servletWriter, String string2) throws JasperException {
        if (clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TagBeginGenerator.class$("java.lang.String")))) {
            return servletWriter.quoteString(string);
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.valueOf(string).toString();
        }
        if (clazz == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = TagBeginGenerator.class$("java.lang.Boolean")))) {
            return "new Boolean(" + Boolean.valueOf(string).toString() + ")";
        }
        if (clazz == Byte.TYPE) {
            return "((byte)" + Byte.valueOf(string).toString() + ")";
        }
        if (clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = TagBeginGenerator.class$("java.lang.Byte")))) {
            return "new Byte((byte)" + Byte.valueOf(string).toString() + ")";
        }
        if (clazz == Character.TYPE) {
            if (string.length() > 1) {
                char c = string.charAt(0);
                return "((char) " + c + ")";
            }
            throw new NumberFormatException(Constants.getString("jsp.error.bad_string_char", new Object[0]));
        }
        if (clazz == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = TagBeginGenerator.class$("java.lang.Character")))) {
            if (string.length() > 1) {
                char c = string.charAt(0);
                return "new Character((char) " + c + ")";
            }
            throw new NumberFormatException(Constants.getString("jsp.error.bad_string_Character", new Object[0]));
        }
        if (clazz == Double.TYPE) {
            return Double.valueOf(string).toString();
        }
        if (clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = TagBeginGenerator.class$("java.lang.Double")))) {
            return "new Double(" + Double.valueOf(string).toString() + ")";
        }
        if (clazz == Float.TYPE) {
            return String.valueOf(Float.valueOf(string).toString()) + "f";
        }
        if (clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = TagBeginGenerator.class$("java.lang.Float")))) {
            return "new Float(" + Float.valueOf(string).toString() + "f)";
        }
        if (clazz == Integer.TYPE) {
            return Integer.valueOf(string).toString();
        }
        if (clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = TagBeginGenerator.class$("java.lang.Integer")))) {
            return "new Integer(" + Integer.valueOf(string).toString() + ")";
        }
        if (clazz == Long.TYPE) {
            return String.valueOf(Long.valueOf(string).toString()) + "l";
        }
        if (clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = TagBeginGenerator.class$("java.lang.Long")))) {
            return "new Long(" + Long.valueOf(string).toString() + "l)";
        }
        throw new CompileException(this.start, Constants.getString("jsp.error.unable.to_convert_string", new Object[]{clazz.getName(), string2}));
    }

    public void generate(ServletWriter servletWriter, Class clazz) throws JasperException {
        this.generateServiceMethodStatements(servletWriter);
    }

    public void generateServiceMethodStatements(ServletWriter servletWriter) throws JasperException {
        TagGeneratorBase.TagVariableData tagVariableData = this.topTag();
        String string = tagVariableData == null ? null : tagVariableData.tagHandlerInstanceName;
        String string2 = "_jspx_eval_" + this.baseVarName;
        TagBeginGenerator tagBeginGenerator = this;
        tagBeginGenerator.getClass();
        this.tagBegin(new TagGeneratorBase.TagVariableData(tagBeginGenerator, this.thVarName, string2));
        servletWriter.println("/* ----  " + this.prefix + ":" + this.shortTagName + " ---- */");
        servletWriter.println(String.valueOf(this.ti.getTagClassName()) + " " + this.thVarName + " = new " + this.ti.getTagClassName() + "();");
        this.generateSetters(servletWriter, string);
        VariableInfo[] variableInfoArray = this.ti.getVariableInfo(this.tagData);
        this.declareVariables(servletWriter, variableInfoArray, true, false, 1);
        servletWriter.println("try {");
        servletWriter.pushIndent();
        servletWriter.println("int " + string2 + " = " + this.thVarName + ".doStartTag();");
        boolean bl = (class$javax$servlet$jsp$tagext$BodyTag != null ? class$javax$servlet$jsp$tagext$BodyTag : (class$javax$servlet$jsp$tagext$BodyTag = TagBeginGenerator.class$("javax.servlet.jsp.tagext.BodyTag"))).isAssignableFrom(this.tc.getTagHandlerClass());
        this.declareVariables(servletWriter, variableInfoArray, false, true, 1);
        if (bl) {
            servletWriter.println("if (" + string2 + " == Tag.EVAL_BODY_INCLUDE)");
            servletWriter.pushIndent();
            servletWriter.println("throw new JspTagException(\"Since tag handler " + this.tc.getTagHandlerClass() + " implements BodyTag, it can't return Tag.EVAL_BODY_INCLUDE\");");
            servletWriter.popIndent();
        } else {
            servletWriter.println("if (" + string2 + " == BodyTag.EVAL_BODY_TAG)");
            servletWriter.pushIndent();
            servletWriter.println("throw new JspTagException(\"Since tag handler " + this.tc.getTagHandlerClass() + " does not implement BodyTag, it can't return BodyTag.EVAL_BODY_TAG\");");
            servletWriter.popIndent();
        }
        servletWriter.println("if (" + string2 + " != Tag.SKIP_BODY) {");
        servletWriter.pushIndent();
        if (bl) {
            servletWriter.println("try {");
            servletWriter.pushIndent();
            servletWriter.println("if (" + string2 + " != Tag.EVAL_BODY_INCLUDE) {");
            servletWriter.pushIndent();
            servletWriter.println("out = pageContext.pushBody();");
            servletWriter.println(String.valueOf(this.thVarName) + ".setBodyContent((BodyContent) out);");
            servletWriter.popIndent();
            servletWriter.println("}");
            servletWriter.println(String.valueOf(this.thVarName) + ".doInitBody();");
        }
        servletWriter.println("do {");
        servletWriter.pushIndent();
        this.declareVariables(servletWriter, variableInfoArray, true, true, 0);
        this.declareVariables(servletWriter, variableInfoArray, false, true, 1);
    }

    private final void generateSetters(ServletWriter servletWriter, String string) throws JasperException {
        servletWriter.println(String.valueOf(this.thVarName) + ".setPageContext(pageContext);");
        servletWriter.println(String.valueOf(this.thVarName) + ".setParent(" + string + ");");
        if (this.attributes.length != 0) {
            int n = 0;
            while (n < this.attributes.length) {
                String string2 = (String)this.attrs.get(this.attributes[n].getName());
                if (string2 != null) {
                    String string3 = this.attributes[n].getName();
                    Method method = this.tc.getSetterMethod(string3);
                    if (method == null) {
                        throw new CompileException(this.start, Constants.getString("jsp.error.unable.to_find_method", new Object[]{string3}));
                    }
                    Class<?>[] classArray = method.getParameterTypes();
                    string2 = this.attributes[n].canBeRequestTime() ? (JspUtil.isExpression(string2) ? JspUtil.getExpr(string2) : this.convertString(classArray[0], string2, servletWriter, string3)) : this.convertString(classArray[0], string2, servletWriter, string3);
                    servletWriter.println(String.valueOf(this.thVarName) + "." + method.getName() + "(" + string2 + ");");
                }
                ++n;
            }
        }
    }

    public void init(JspCompilationContext jspCompilationContext) throws JasperException {
        this.validate();
        this.tc = this.libraries.getTagCache(this.prefix, this.shortTagName);
        if (this.tc == null) {
            this.tc = new TagCache(this.shortTagName);
            ClassLoader classLoader = jspCompilationContext.getClassLoader();
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(this.ti.getTagClassName());
            }
            catch (Exception exception) {
                throw new CompileException(this.start, Constants.getString("jsp.error.unable.loadclass", new Object[]{this.ti.getTagClassName(), exception.getMessage()}));
            }
            this.tc.setTagHandlerClass(clazz);
            this.libraries.putTagCache(this.prefix, this.shortTagName, this.tc);
        }
    }

    void validate() throws JasperException {
        Hashtable hashtable = (Hashtable)this.attrs.clone();
        int n = 0;
        while (n < this.attributes.length) {
            if (this.attributes[n].isRequired() && hashtable.get(this.attributes[n].getName()) == null) {
                throw new CompileException(this.start, Constants.getString("jsp.error.missing_attribute", new Object[]{this.attributes[n].getName(), this.shortTagName}));
            }
            ++n;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.attributes.length) {
                if (string.equals(this.attributes[n2].getName())) {
                    bl = true;
                    if (this.attributes[n2].canBeRequestTime() && JspUtil.isExpression((String)hashtable.get(string))) {
                        hashtable.put(string, TagData.REQUEST_TIME_VALUE);
                    }
                }
                ++n2;
            }
            if (bl) continue;
            throw new CompileException(this.start, Constants.getString("jsp.error.bad_attribute", new Object[]{string}));
        }
        this.tagData = new TagData(hashtable);
        if (!this.ti.isValid(this.tagData)) {
            throw new CompileException(this.start, Constants.getString("jsp.error.invalid_attributes"));
        }
    }
}

