/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CoreElement;
import org.apache.jasper.compiler.DelegatingListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.TagLibraries;

public class Parser {
    private JspReader reader;
    private ParseEventListener listener;
    CharArrayWriter caw;
    Mark tmplStart;
    Mark tmplStop;
    String currentFile;
    static final Vector coreElements = new Vector();

    static {
        coreElements.addElement(new Directive());
        coreElements.addElement(new Include());
        coreElements.addElement(new Forward());
        coreElements.addElement(new Comment());
        coreElements.addElement(new Declaration());
        coreElements.addElement(new Expression());
        coreElements.addElement(new Scriptlet());
        coreElements.addElement(new Bean());
        coreElements.addElement(new GetProperty());
        coreElements.addElement(new SetProperty());
        coreElements.addElement(new Tag());
        coreElements.addElement(new Plugin());
        coreElements.addElement(new QuoteEscape());
    }

    public Parser(JspReader jspReader, ParseEventListener parseEventListener) {
        this.reader = jspReader;
        this.listener = new DelegatingListener(parseEventListener, new Action(){

            public void execute(Mark mark, Mark mark2) throws JasperException {
                Parser.this.flushCharData(mark, mark2);
            }
        });
        this.caw = new CharArrayWriter();
        this.currentFile = jspReader.mark().getFile();
    }

    void flushCharData(Mark mark, Mark mark2) throws JasperException {
        char[] cArray = this.caw.toCharArray();
        if (cArray.length != 0) {
            this.listener.handleCharData(mark, mark2, this.caw.toCharArray());
        }
        this.caw = new CharArrayWriter();
    }

    public void parse() throws JasperException {
        this.parse(null);
    }

    public void parse(String string) throws JasperException {
        this.parse(string, null);
    }

    public void parse(String string, Class[] classArray) throws JasperException {
        boolean bl = false;
        while (this.reader.hasMoreInput()) {
            Object object;
            if (string != null && this.reader.matches(string)) {
                return;
            }
            if (!this.reader.mark().getFile().equals(this.currentFile)) {
                this.flushCharData(this.tmplStart, this.tmplStop);
                this.currentFile = this.reader.mark().getFile();
                this.tmplStart = this.reader.mark();
            }
            Enumeration enumeration = coreElements.elements();
            if (classArray != null) {
                Vector<Object> vector = new Vector<Object>();
                while (enumeration.hasMoreElements()) {
                    object = (CoreElement)enumeration.nextElement();
                    int n = 0;
                    while (n < classArray.length) {
                        if (object.getClass().equals(classArray[n])) {
                            vector.addElement(object);
                        }
                        ++n;
                    }
                }
                enumeration = vector.elements();
            }
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                object = (CoreElement)enumeration.nextElement();
                Mark mark = this.reader.mark();
                if (!object.accept(this.listener, this.reader, this)) continue;
                Constants.message("jsp.message.accepted", new Object[]{object.getClass().getName(), mark}, 4);
                bl2 = true;
                bl = false;
                break;
            }
            if (bl2) continue;
            if (!bl) {
                this.tmplStart = this.reader.mark();
                bl = true;
            }
            object = this.reader.nextContent();
            this.tmplStop = this.reader.mark();
            this.caw.write((String)object, 0, ((String)object).length());
        }
        this.flushCharData(this.tmplStart, this.tmplStop);
    }

    public static interface Action {
        public void execute(Mark var1, Mark var2) throws JasperException;
    }

    static final class Directive
    implements CoreElement {
        private static final String OPEN_DIRECTIVE = "<%@";
        private static final String CLOSE_DIRECTIVE = "%>";
        static final String[] directives = new String[]{"page", "include", "taglib"};
        private static final JspUtil.ValidAttribute[] pageDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType")};
        private static final JspUtil.ValidAttribute[] includeDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] tagDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri", true), new JspUtil.ValidAttribute("prefix", true)};

        Directive() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (!jspReader.matches(OPEN_DIRECTIVE)) {
                return false;
            }
            String string = OPEN_DIRECTIVE;
            String string2 = CLOSE_DIRECTIVE;
            Mark mark = jspReader.mark();
            jspReader.advance(string.length());
            jspReader.skipSpaces();
            String string3 = null;
            int n = 0;
            while (n < directives.length) {
                if (jspReader.matches(directives[n])) {
                    string3 = directives[n];
                    break;
                }
                ++n;
            }
            if (string3 == null) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.invalid.directive"));
            }
            jspReader.advance(string3.length());
            Hashtable hashtable = jspReader.parseTagAttributes();
            if (string3.equals("page")) {
                JspUtil.checkAttributes("Page directive", hashtable, pageDvalidAttrs, mark);
            } else if (string3.equals("include")) {
                JspUtil.checkAttributes("Include directive", hashtable, includeDvalidAttrs, mark);
            } else if (string3.equals("taglib")) {
                JspUtil.checkAttributes("Taglib directive", hashtable, tagDvalidAttrs, mark);
            }
            jspReader.skipSpaces();
            if (!jspReader.matches(string2)) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{string}));
            }
            jspReader.advance(string2.length());
            Mark mark2 = jspReader.mark();
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleDirective(string3, mark, mark2, hashtable);
            return true;
        }
    }

    static final class Include
    implements CoreElement {
        private static final String OPEN_INCLUDE = "<jsp:include";
        private static final String CLOSE_INCLUDE_NO_BODY = "/>";
        private static final String CLOSE_INCLUDE_BODY = ">";
        private static final String CLOSE_INCLUDE = "</jsp:include>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};

        Include() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean accept(ParseEventListener var1_1, JspReader var2_2, Parser var3_3) throws JasperException {
            block4: {
                block7: {
                    block5: {
                        block6: {
                            if (!var2_2.matches("<jsp:include")) break block4;
                            var4_4 = new Hashtable<K, V>();
                            var5_5 = var2_2.mark();
                            var2_2.advance("<jsp:include".length());
                            var6_6 = var2_2.parseTagAttributes();
                            JspUtil.checkAttributes("Include", var6_6, Include.validAttributes, var5_5);
                            var2_2.skipSpaces();
                            if (var2_2.matches("/>")) break block5;
                            if (!var2_2.matches(">")) {
                                throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:include"}));
                            }
                            var2_2.advance(">".length());
                            var2_2.skipSpaces();
                            if (var2_2.matches("</jsp:include>")) break block6;
                            var2_2.skipSpaces();
                            if (var2_2.matches("<jsp:param")) ** GOTO lbl28
                            throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.paramexpected"));
lbl-1000:
                            // 1 sources

                            {
                                var2_2.parsePluginParamTag(var4_4);
                                var2_2.skipSpaces();
                                if (!var2_2.matches("/>")) {
                                    throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:param"}));
                                }
                                var2_2.advance("/>".length());
                                var2_2.skipSpaces();
lbl28:
                                // 2 sources

                                ** while (var2_2.matches((String)"<jsp:param"))
                            }
                        }
                        if (!var2_2.matches("</jsp:include>")) {
                            throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:include"}));
                        }
                        var2_2.advance("</jsp:include>".length());
                        break block7;
                    }
                    var2_2.advance("/>".length());
                }
                var7_7 = var2_2.mark();
                var1_1.setTemplateInfo(var3_3.tmplStart, var3_3.tmplStop);
                var1_1.handleInclude(var5_5, var7_7, var6_6, var4_4);
                return true;
            }
            return false;
        }
    }

    static final class Forward
    implements CoreElement {
        private static final String OPEN_FORWARD = "<jsp:forward";
        private static final String CLOSE_FORWARD_NO_BODY = "/>";
        private static final String CLOSE_FORWARD_BODY = ">";
        private static final String CLOSE_FORWARD = "</jsp:forward>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};

        Forward() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean accept(ParseEventListener var1_1, JspReader var2_2, Parser var3_3) throws JasperException {
            block4: {
                block7: {
                    block5: {
                        block6: {
                            if (!var2_2.matches("<jsp:forward")) break block4;
                            var4_4 = var2_2.mark();
                            var2_2.advance("<jsp:forward".length());
                            var5_5 = var2_2.parseTagAttributes();
                            var6_6 = new Hashtable<K, V>();
                            JspUtil.checkAttributes("Forward", var5_5, Forward.validAttributes, var4_4);
                            var2_2.skipSpaces();
                            if (var2_2.matches("/>")) break block5;
                            if (!var2_2.matches(">")) {
                                throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:forward"}));
                            }
                            var2_2.advance(">".length());
                            var2_2.skipSpaces();
                            if (var2_2.matches("</jsp:forward>")) break block6;
                            var2_2.skipSpaces();
                            if (var2_2.matches("<jsp:param")) ** GOTO lbl28
                            throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.paramexpected"));
lbl-1000:
                            // 1 sources

                            {
                                var2_2.parsePluginParamTag(var6_6);
                                var2_2.skipSpaces();
                                if (!var2_2.matches("/>")) {
                                    throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:param"}));
                                }
                                var2_2.advance("/>".length());
                                var2_2.skipSpaces();
lbl28:
                                // 2 sources

                                ** while (var2_2.matches((String)"<jsp:param"))
                            }
                        }
                        if (!var2_2.matches("</jsp:forward>")) {
                            throw new ParseException(var2_2.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"<jsp:forward"}));
                        }
                        var2_2.advance("</jsp:forward>".length());
                        break block7;
                    }
                    var2_2.advance("/>".length());
                }
                var7_7 = var2_2.mark();
                var1_1.setTemplateInfo(var3_3.tmplStart, var3_3.tmplStop);
                var1_1.handleForward(var4_4, var7_7, var5_5, var6_6);
                return true;
            }
            return false;
        }
    }

    static final class Comment
    implements CoreElement {
        private static final String OPEN_COMMENT = "<%--";
        private static final String CLOSE_COMMENT = "--%>";

        Comment() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_COMMENT)) {
                jspReader.advance(OPEN_COMMENT.length());
                Mark mark = jspReader.mark();
                Mark mark2 = jspReader.skipUntil(CLOSE_COMMENT);
                if (mark2 == null) {
                    throw new ParseException(Constants.getString("jsp.error.unterminated", new Object[]{OPEN_COMMENT}));
                }
                parser.flushCharData(parser.tmplStart, parser.tmplStop);
                return true;
            }
            return false;
        }
    }

    static final class Declaration
    implements CoreElement {
        private static final String OPEN_DECL = "<%!";
        private static final String CLOSE_DECL = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Declaration() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            Mark mark;
            String string = null;
            Hashtable hashtable = null;
            if (!jspReader.matches(OPEN_DECL)) {
                return false;
            }
            String string2 = OPEN_DECL;
            String string3 = CLOSE_DECL;
            jspReader.advance(string2.length());
            Mark mark2 = jspReader.mark();
            if (string != null) {
                hashtable = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(string)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                jspReader.advance(string.length());
                jspReader.skipSpaces();
                JspUtil.checkAttributes("Declaration", hashtable, validAttributes, mark2);
            }
            if ((mark = jspReader.skipUntil(string3)) == null) {
                throw new ParseException(Constants.getString("jsp.error.unterminated", new Object[]{string2}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleDeclaration(mark2, mark, hashtable);
            return true;
        }
    }

    static final class Expression
    implements CoreElement {
        private static final String OPEN_EXPR = "<%=";
        private static final String CLOSE_EXPR = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Expression() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            Mark mark;
            String string = null;
            Hashtable hashtable = null;
            if (!jspReader.matches(OPEN_EXPR)) {
                return false;
            }
            String string2 = OPEN_EXPR;
            String string3 = CLOSE_EXPR;
            jspReader.advance(string2.length());
            Mark mark2 = jspReader.mark();
            if (string != null) {
                hashtable = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(string)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                jspReader.advance(string.length());
                jspReader.skipSpaces();
                JspUtil.checkAttributes("Expression", hashtable, validAttributes, mark2);
            }
            if ((mark = jspReader.skipUntil(string3)) == null) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{string2}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleExpression(mark2, mark, hashtable);
            return true;
        }
    }

    static final class Scriptlet
    implements CoreElement {
        private static final String OPEN_SCRIPTLET = "<%";
        private static final String CLOSE_SCRIPTLET = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Scriptlet() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            Mark mark;
            String string = null;
            Hashtable hashtable = null;
            if (!jspReader.matches(OPEN_SCRIPTLET)) {
                return false;
            }
            String string2 = OPEN_SCRIPTLET;
            String string3 = CLOSE_SCRIPTLET;
            jspReader.advance(string2.length());
            Mark mark2 = jspReader.mark();
            if (string != null) {
                hashtable = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(string)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                jspReader.advance(string.length());
                jspReader.skipSpaces();
                JspUtil.checkAttributes("Scriptlet", hashtable, validAttributes, mark2);
            }
            if ((mark = jspReader.skipUntil(string3)) == null) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{string2}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleScriptlet(mark2, mark, hashtable);
            return true;
        }
    }

    static final class Bean
    implements CoreElement {
        private static final String OPEN_BEAN = "<jsp:useBean";
        private static final String CLOSE_BEAN = "/>";
        private static final String CLOSE_BEAN_2 = "</jsp:useBean>";
        private static final String CLOSE_BEAN_3 = ">";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id"), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName")};

        Bean() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_BEAN)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_BEAN.length());
                Hashtable hashtable = jspReader.parseTagAttributesBean();
                JspUtil.checkAttributes("useBean", hashtable, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches(CLOSE_BEAN)) {
                    if (!jspReader.matches(CLOSE_BEAN_3)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"useBean"}));
                    }
                    jspReader.advance(CLOSE_BEAN_3.length());
                    Mark mark2 = jspReader.mark();
                    parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                    parseEventListener.handleBean(mark, mark2, hashtable);
                    int n = jspReader.size;
                    parser.parse(CLOSE_BEAN_2);
                    if (n != jspReader.size) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.usebean.notinsamefile"));
                    }
                    if (!jspReader.matches(CLOSE_BEAN_2)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_BEAN}));
                    }
                    jspReader.advance(CLOSE_BEAN_2.length());
                    parseEventListener.handleBeanEnd(mark, mark2, hashtable);
                    return true;
                }
                jspReader.advance(CLOSE_BEAN.length());
                Mark mark3 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleBean(mark, mark3, hashtable);
                parseEventListener.handleBeanEnd(mark, mark3, hashtable);
                return true;
            }
            return false;
        }
    }

    static final class GetProperty
    implements CoreElement {
        private static final String OPEN_GETPROPERTY = "<jsp:getProperty";
        private static final String CLOSE_GETPROPERTY = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};

        GetProperty() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_GETPROPERTY)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_GETPROPERTY.length());
                Hashtable hashtable = jspReader.parseTagAttributes();
                JspUtil.checkAttributes("getProperty", hashtable, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches(CLOSE_GETPROPERTY)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_GETPROPERTY}));
                }
                jspReader.advance(CLOSE_GETPROPERTY.length());
                Mark mark2 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleGetProperty(mark, mark2, hashtable);
                return true;
            }
            return false;
        }
    }

    static final class SetProperty
    implements CoreElement {
        private static final String OPEN_SETPROPERTY = "<jsp:setProperty";
        private static final String CLOSE_SETPROPERTY = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value"), new JspUtil.ValidAttribute("param")};

        SetProperty() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_SETPROPERTY)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_SETPROPERTY.length());
                Hashtable hashtable = jspReader.parseTagAttributes();
                JspUtil.checkAttributes("setProperty", hashtable, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches(CLOSE_SETPROPERTY)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_SETPROPERTY}));
                }
                jspReader.advance(CLOSE_SETPROPERTY.length());
                Mark mark2 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleSetProperty(mark, mark2, hashtable);
                return true;
            }
            return false;
        }
    }

    static final class Tag
    implements CoreElement {
        private static final String CLOSE_1 = "/>";
        private static final String CLOSE = ">";

        Tag() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            TagLibraries tagLibraries;
            if (jspReader.peekChar() != 60) {
                return false;
            }
            Mark mark = jspReader.mark();
            jspReader.nextChar();
            String string = jspReader.parseToken(false);
            int n = string.indexOf(58);
            if (n == -1) {
                jspReader.reset(mark);
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = "";
            if (++n < string.length()) {
                string3 = string.substring(n);
            }
            if (!(tagLibraries = parseEventListener.getTagLibraries()).isUserDefinedTag(string2, string3)) {
                jspReader.reset(mark);
                return false;
            }
            if (string3 == null) {
                throw new ParseException(mark, "Nothing after the :");
            }
            TagLibraryInfo tagLibraryInfo = tagLibraries.getTagLibInfo(string2);
            TagInfo tagInfo = tagLibraryInfo.getTag(string3);
            if (tagInfo == null) {
                throw new ParseException(mark, "Unable to locate TagInfo for " + string);
            }
            String string4 = tagInfo.getBodyContent();
            Hashtable hashtable = jspReader.parseTagAttributes();
            jspReader.skipSpaces();
            Mark mark2 = null;
            Object var15_15 = null;
            if (jspReader.matches(CLOSE_1) || string4.equalsIgnoreCase("EMPTY")) {
                if (!jspReader.matches(CLOSE_1)) {
                    throw new ParseException(mark, "Body is supposed to be empty for " + string);
                }
                jspReader.advance(CLOSE_1.length());
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleTagBegin(mark, jspReader.mark(), hashtable, string2, string3, tagLibraryInfo, tagInfo);
                parseEventListener.handleTagEnd(mark, jspReader.mark(), string2, string3, hashtable, tagLibraryInfo, tagInfo);
                return true;
            }
            if (!jspReader.matches(CLOSE)) throw new ParseException(mark, "Unterminated user-defined tag");
            jspReader.advance(CLOSE.length());
            mark2 = jspReader.mark();
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleTagBegin(mark, mark2, hashtable, string2, string3, tagLibraryInfo, tagInfo);
            if (!string4.equalsIgnoreCase("TAGDEPENDENT") && !string4.equalsIgnoreCase("JSP")) throw new ParseException(mark, "Internal Error: Invalid BODY_CONTENT type");
            String string5 = "</" + string + CLOSE;
            parser.parse(string5);
            try {
                jspReader.advance(string5.length());
            }
            catch (ParseException parseException) {
                throw new ParseException(mark, Constants.getString("jsp.error.unterminated.user.tag", new Object[]{JspUtil.escapeXml(string5)}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleTagEnd(parser.tmplStop, jspReader.mark(), string2, string3, hashtable, tagLibraryInfo, tagInfo);
            return true;
        }
    }

    static final class Plugin
    implements CoreElement {
        private static final String OPEN_PLUGIN = "<jsp:plugin";
        private static final String END_OPEN_PLUGIN = ">";
        private static final String CLOSE_PLUGIN = "</jsp:plugin>";
        private static final String OPEN_PARAMS = "<jsp:params>";
        private static final String CLOSE_PARAMS = "</jsp:params>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final String OPEN_FALLBACK = "<jsp:fallback>";
        private static final String CLOSE_FALLBACK = "</jsp:fallback>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height"), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width"), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};

        Plugin() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_PLUGIN)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_PLUGIN.length());
                Hashtable hashtable = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(END_OPEN_PLUGIN)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.plugin.notclosed"));
                }
                jspReader.advance(END_OPEN_PLUGIN.length());
                jspReader.skipSpaces();
                Hashtable hashtable2 = null;
                String string = null;
                JspUtil.checkAttributes("plugin", hashtable, validAttributes, mark);
                if (jspReader.matches(OPEN_PARAMS)) {
                    hashtable2 = new Hashtable();
                    boolean bl = false;
                    jspReader.advance(OPEN_PARAMS.length());
                    while (jspReader.hasMoreInput()) {
                        jspReader.skipSpaces();
                        if (jspReader.matches(CLOSE_PARAMS)) {
                            bl = true;
                            jspReader.advance(CLOSE_PARAMS.length());
                            break;
                        }
                        if (!jspReader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.paramexpected"));
                        }
                        jspReader.parsePluginParamTag(hashtable2);
                        jspReader.skipSpaces();
                        if (!jspReader.matches(CLOSE_INDIVIDUAL_PARAM)) {
                            throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.closeindividualparam"));
                        }
                        jspReader.advance(CLOSE_INDIVIDUAL_PARAM.length());
                    }
                    if (!bl) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.closeparams"));
                    }
                    jspReader.skipSpaces();
                }
                if (jspReader.matches(OPEN_FALLBACK)) {
                    jspReader.advance(OPEN_FALLBACK.length());
                    jspReader.skipSpaces();
                    Mark mark2 = jspReader.mark();
                    Mark mark3 = jspReader.skipUntil(CLOSE_FALLBACK);
                    string = new String(jspReader.getChars(mark2, mark3));
                    jspReader.skipSpaces();
                }
                if (!jspReader.matches(CLOSE_PLUGIN)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_PLUGIN}));
                }
                jspReader.advance(CLOSE_PLUGIN.length());
                Mark mark4 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handlePlugin(mark, mark4, hashtable, hashtable2, string);
                return true;
            }
            return false;
        }
    }

    static final class QuoteEscape
    implements CoreElement {
        private static String QUOTED_START_TAG = "<\\%";
        private static String QUOTED_END_TAG = "%\\>";
        private static String START_TAG = "<%";
        private static String END_TAG = "%>";
        private static final String APOS = "&apos;";
        private static final String QUOTE = "&quote;";

        QuoteEscape() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            try {
                Mark mark = jspReader.mark();
                if (jspReader.matches(QUOTED_START_TAG)) {
                    jspReader.advance(QUOTED_START_TAG.length());
                    Mark mark2 = jspReader.mark();
                    parser.caw.write(START_TAG);
                    parser.flushCharData(mark, mark2);
                    return true;
                }
                if (jspReader.matches(APOS)) {
                    jspReader.advance(APOS.length());
                    Mark mark3 = jspReader.mark();
                    parser.caw.write("'");
                    parser.flushCharData(mark, mark3);
                    return true;
                }
                if (jspReader.matches(QUOTE)) {
                    jspReader.advance(QUOTE.length());
                    Mark mark4 = jspReader.mark();
                    parser.caw.write("\"");
                    parser.flushCharData(mark, mark4);
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new JasperException(iOException);
            }
            return false;
        }
    }
}

