/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletConfig;
import com.iplanet.server.http.servlet.WebAppConfig;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.util.XmlNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletException;

public class WServletConfig
extends NSServletConfig {
    private String className;
    private String jspFile;
    private int loadOnStartup;
    private HashMap roleRefs;

    public WServletConfig(WebApplication webApplication, String string, String string2, String string3, XmlNode xmlNode) throws ServletException {
        this._servletName = string;
        this._context = webApplication;
        this._props = new Properties();
        this.className = string2;
        if (string2 == null) {
            this.className = string;
        }
        this.jspFile = string3;
        this.loadOnStartup = Integer.MIN_VALUE;
        if (string3 != null || xmlNode == null) {
            return;
        }
        Iterator iterator = xmlNode.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (xmlNode2.getName().equals("init-param")) {
                WebAppConfig.setParams(xmlNode2, this._props);
                continue;
            }
            if (xmlNode2.getName().equals("load-on-startup")) {
                this.loadOnStartup = xmlNode.getInt("load-on-startup", 0);
                continue;
            }
            if (xmlNode2.getName().equals("icon") || xmlNode2.getName().equals("display-name") || xmlNode2.getName().equals("description")) continue;
            if (xmlNode2.getName().equals("security-role-ref")) {
                this.setupSecurityRoleRef(xmlNode2);
                continue;
            }
            if (xmlNode2.getName().equals("servlet-name")) continue;
            xmlNode2.getName().equals("servlet-class");
        }
    }

    String getClassName() {
        return this.className;
    }

    String getJspFile() {
        return this.jspFile;
    }

    int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    String lookupSecurityRoleRef(String string) {
        if (this.roleRefs != null) {
            return (String)this.roleRefs.get(string);
        }
        return null;
    }

    void setupSecurityRoleRef(XmlNode xmlNode) throws ServletException {
        if (this.roleRefs == null) {
            this.roleRefs = new HashMap();
        }
        XmlNode xmlNode2 = xmlNode.findChildNode("role-name");
        XmlNode xmlNode3 = xmlNode.findChildNode("role-link");
        if (xmlNode2 == null || xmlNode3 == null) {
            throw WebAppConfig.configException(xmlNode, "security-role-ref must have role-name and role-link elements");
        }
        String string = xmlNode2.getString();
        String string2 = xmlNode3.getString();
        if (string != null && string.length() > 0 && string2 != null) {
            this.roleRefs.put(string, string2);
        }
    }
}

