/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSHttpServletRequest;
import com.iplanet.server.http.servlet.NSHttpServletResponse;
import com.iplanet.server.http.servlet.NSServletRunner;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.NSServletWrapper;
import com.iplanet.server.http.servlet.WRequestDispatcher;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.servlet.WServletEntity;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.SlashUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class WNamedDispatcher
extends WRequestDispatcher {
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private NSServletRunner runner;
    private WServletEntity se;

    WNamedDispatcher(NSServletRunner nSServletRunner, WServletContext wServletContext, WServletEntity wServletEntity) {
        super(wServletContext);
        this.se = wServletEntity;
        this.runner = nSServletRunner;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        NSHttpServletRequest nSHttpServletRequest = this.getHttpServletRequest(2, servletRequest);
        NSHttpServletResponse nSHttpServletResponse = this.getHttpServletResponse(servletResponse);
        NSServletSession nSServletSession = this.checkNativeSession(2, nSHttpServletRequest);
        this.prepareDispatch(2, nSHttpServletRequest, nSHttpServletResponse);
        this.saveNativeSessionStatus(nSServletSession);
        nSServletSession.startResponse();
        nSHttpServletResponse.clearOutputStream();
        int n = this.service(nSHttpServletRequest, nSHttpServletResponse, nSServletSession);
        this.restoreDispatchState(2, nSHttpServletRequest, nSHttpServletResponse);
        if (n != 0) {
            this.restoreNativeSessionStatus(nSServletSession);
            this.handleIncludeForwardException(nSHttpServletRequest);
            LogUtil.logWarning((String)_res.getProp("servlet.WNamedDispatcher.msg_forwardFailed"));
            throw new ServletException(_res.getProp("servlet.WNamedDispatcher.msg_forwardFailed"));
        }
        boolean bl = true;
        nSHttpServletResponse.flushOutputStream(true);
        nSHttpServletResponse.markOutputStreamClosed();
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        NSHttpServletRequest nSHttpServletRequest = this.getHttpServletRequest(1, servletRequest);
        NSHttpServletResponse nSHttpServletResponse = this.getHttpServletResponse(servletResponse);
        NSServletSession nSServletSession = this.checkNativeSession(1, nSHttpServletRequest);
        this.prepareDispatch(1, nSHttpServletRequest, nSHttpServletResponse);
        nSServletSession.startResponse();
        boolean bl = false;
        nSHttpServletResponse.flushOutputStream(false);
        this.saveNativeSessionStatus(nSServletSession);
        int n = this.service(nSHttpServletRequest, nSHttpServletResponse, nSServletSession);
        this.restoreDispatchState(1, nSHttpServletRequest, nSHttpServletResponse);
        if (n != 0) {
            this.restoreNativeSessionStatus(nSServletSession);
            this.handleIncludeForwardException(nSHttpServletRequest);
            LogUtil.logWarning((String)_res.getProp("servlet.WNamedDispatcher.msg_includeFailed"));
            throw new ServletException(_res.getProp("servlet.WNamedDispatcher.msg_includeFailed"));
        }
    }

    private int service(NSHttpServletRequest nSHttpServletRequest, NSHttpServletResponse nSHttpServletResponse, NSServletSession nSServletSession) {
        WebApplication webApplication = (WebApplication)this.se.getServletConfig().getServletContext();
        if (this.se.getServletConfig().getJspFile() != null) {
            String string = this.se.getServletConfig().getJspFile();
            if (string.length() == 0 || string.charAt(0) != '/') {
                string = "/" + string;
            }
            String string2 = SlashUtil.de_slashes((String)(String.valueOf(this._context.getContextPath()) + string));
            LogUtil.TRACE((int)5, (String)("WNamedDispatcher service : uriPath = " + string2));
            boolean bl = nSServletSession.internalRedirect(string2, true);
            return bl ? 0 : -1;
        }
        NSServletWrapper nSServletWrapper = webApplication.getServletWrapper(this.se.getServletConfig().getServletName());
        if (nSServletWrapper == null) {
            try {
                nSServletWrapper = this.se.loadAndInitServlet();
            }
            catch (ServletException servletException) {
                nSHttpServletRequest.setStoredException((Exception)((Object)servletException));
                return -1;
            }
        }
        nSHttpServletRequest.setServletWrapper(nSServletWrapper);
        int n = this.runner.invokeServletService(nSHttpServletRequest._getRequestURI(), nSServletWrapper, nSHttpServletRequest, nSHttpServletResponse, nSServletSession, webApplication, false);
        return n;
    }
}

