/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSHttpServletRequest;
import com.iplanet.server.http.servlet.NSHttpServletResponse;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.WRequestDispatcher;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class NSRequestDispatcher
extends WRequestDispatcher {
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private String _uri;

    public NSRequestDispatcher(String string, WServletContext wServletContext) {
        super(wServletContext);
        this._uri = string;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("forward (): uri=" + this._uri));
        }
        NSHttpServletRequest nSHttpServletRequest = this.getHttpServletRequest(2, servletRequest);
        NSHttpServletResponse nSHttpServletResponse = this.getHttpServletResponse(servletResponse);
        NSServletSession nSServletSession = this.checkNativeSession(2, nSHttpServletRequest);
        this.prepareDispatch(2, nSHttpServletRequest, nSHttpServletResponse);
        nSHttpServletResponse.clearOutputStream();
        this.saveNativeSessionStatus(nSServletSession);
        nSServletSession.startResponse();
        boolean bl = nSServletSession.internalRedirect(this._uri, true);
        this.restoreDispatchState(2, nSHttpServletRequest, nSHttpServletResponse);
        if (!bl) {
            this.restoreNativeSessionStatus(nSServletSession);
            this.handleIncludeForwardException(nSHttpServletRequest);
            LogUtil.logWarning((String)_res.getProp("servlet.NSRequestDispatcher.msg_forwardFailed"));
            throw new ServletException(_res.getProp("servlet.NSRequestDispatcher.msg_forwardFailed"));
        }
        boolean bl2 = true;
        nSHttpServletResponse.flushOutputStream(true);
        nSHttpServletResponse.markOutputStreamClosed();
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("include (): uri=" + this._uri));
        }
        NSHttpServletRequest nSHttpServletRequest = this.getHttpServletRequest(1, servletRequest);
        NSHttpServletResponse nSHttpServletResponse = this.getHttpServletResponse(servletResponse);
        NSServletSession nSServletSession = this.checkNativeSession(1, nSHttpServletRequest);
        nSServletSession.startResponse();
        boolean bl = false;
        nSHttpServletResponse.flushOutputStream(false);
        this.saveNativeSessionStatus(nSServletSession);
        this.prepareDispatch(1, nSHttpServletRequest, nSHttpServletResponse);
        boolean bl2 = nSServletSession.internalRedirect(this._uri, true);
        this.restoreDispatchState(1, nSHttpServletRequest, nSHttpServletResponse);
        nSHttpServletRequest.resetRequestDispatcherAttrs();
        if (!bl2) {
            this.restoreNativeSessionStatus(nSServletSession);
            this.handleIncludeForwardException(nSHttpServletRequest);
            LogUtil.logWarning((String)_res.getProp("servlet.NSRequestDispatcher.msg_includeFailed"));
            throw new ServletException(_res.getProp("servlet.NSRequestDispatcher.msg_includeFailed"));
        }
    }
}

