/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import java.io.ByteArrayOutputStream;
import java.util.BitSet;

public class URLByteEncoder {
    protected static BitSet dontNeedEncoding = new BitSet(256);
    protected static final int caseDiff = 32;

    public static byte[] toUTF8Format(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (Exception exception) {
            Debug.println(0, "ERROR: Can not construct String with UTF8 encoding");
            return new byte[0];
        }
    }

    public static String encodeUTF8(String string) {
        return URLByteEncoder.encode(URLByteEncoder.toUTF8Format(string));
    }

    public static String encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            if (dontNeedEncoding.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                }
                byteArrayOutputStream.write(n2);
            } else {
                byteArrayOutputStream.write(37);
                char c = Character.forDigit(n2 >> 4 & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                byteArrayOutputStream.write(c);
                c = Character.forDigit(n2 & 0xF, 16);
                if (Character.isLetter(c)) {
                    c = (char)(c - 32);
                }
                byteArrayOutputStream.write(c);
            }
            ++n;
        }
        return byteArrayOutputStream.toString();
    }

    static {
        int n = 97;
        while (n <= 122) {
            dontNeedEncoding.set(n);
            ++n;
        }
        n = 65;
        while (n <= 90) {
            dontNeedEncoding.set(n);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            dontNeedEncoding.set(n);
            ++n;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

