/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class ImageInfo
implements ImageObserver {
    private Image _image;
    private int _imageWidth;
    private int _imageHeight;

    public ImageInfo(ImageIcon imageIcon) {
        this._image = imageIcon.getImage();
        this._imageWidth = imageIcon.getIconWidth();
        this._imageHeight = imageIcon.getIconHeight();
    }

    public ImageInfo(Image image) {
        this._image = image;
        this._imageWidth = image.getWidth(this);
        this._imageHeight = image.getHeight(this);
    }

    public Color getTopRightAverageColor(int n) {
        int n2 = this._imageWidth;
        int n3 = this._imageHeight;
        return this.getAverageColor(n2 - n, n3 - n, n, n);
    }

    public Color getAverageColor(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        int[] nArray2 = new int[n3 * n4];
        int[] nArray3 = new int[n3 * n4];
        int[] nArray4 = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(this._image, n, n2, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            Debug.println(0, "Interrupted waiting for pixels");
            return Color.black;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            Debug.println("Icon fetch aborted or errored");
            return Color.black;
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = nArray[n5 * n3 + n6];
                nArray2[n5 * n3 + n6] = n7 >> 16 & 0xFF;
                nArray3[n5 * n3 + n6] = n7 >> 8 & 0xFF;
                nArray4[n5 * n3 + n6] = n7 & 0xFF;
                ++n6;
            }
            ++n5;
        }
        return new Color(this.getAverage(nArray2), this.getAverage(nArray3), this.getAverage(nArray4));
    }

    protected int getAverage(int[] nArray) {
        long l = 0L;
        int n = 0;
        while (n < nArray.length) {
            l += (long)nArray[n];
            ++n;
        }
        return (int)(l / (long)nArray.length);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this._imageWidth = n4;
        this._imageHeight = n5;
        return true;
    }
}

