/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.MyHeaderParser;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;

public class BrowseHtmlPane
extends JEditorPane {
    private boolean _errorHappened = false;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");

    public BrowseHtmlPane() {
        this.setEditable(false);
    }

    public BrowseHtmlPane(String string) {
        this();
        this.setPage(string);
    }

    public void setPage(String string) {
        try {
            super.setPage(string);
        }
        catch (IOException iOException) {
            String string2 = _resource.getString("browser-error", "badUrl", string);
            Debug.println(string2);
            this.setText(string2);
            this._errorHappened = true;
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.setText(new String(stringWriter.getBuffer()));
            this._errorHappened = true;
        }
    }

    public void setPage(URL uRL) {
        try {
            if (uRL == null) {
                throw new IOException("invalid url");
            }
            URL uRL2 = this.getPage();
            this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            if (uRL2 == null || !uRL2.equals(uRL) || this._errorHappened) {
                Object object;
                this._errorHappened = false;
                InputStream inputStream = this.getStream(uRL);
                if (this.getEditorKit() != null) {
                    object = this.getEditorKit().createDefaultDocument();
                    if (object.getProperty("stream") == null) {
                        object.putProperty("stream", uRL);
                    }
                    if (object instanceof AbstractDocument) {
                        AbstractDocument abstractDocument = (AbstractDocument)object;
                        this.setDocument((Document)object);
                        this.read(inputStream, (Document)object);
                    }
                }
                object = uRL.getRef();
                SwingUtilities.invokeLater(new Runnable((String)object){
                    private final /* synthetic */ String val$reference;
                    {
                        this.val$reference = string;
                    }

                    public void run() {
                        if (this.val$reference != null) {
                            BrowseHtmlPane.super.scrollToReference(this.val$reference);
                        } else {
                            BrowseHtmlPane.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                        }
                    }
                });
                this.firePropertyChange("page", uRL2, uRL);
            }
        }
        catch (IOException iOException) {
            String string = _resource.getString("browser-error", "badUrl", uRL.toString());
            Debug.println(string);
            this.setText(string);
            this._errorHappened = true;
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.setText(new String(stringWriter.getBuffer()));
            this._errorHappened = true;
        }
    }

    protected InputStream getStream(URL uRL) throws IOException {
        Object object;
        Object object2;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            object2 = (HttpURLConnection)uRLConnection;
            ((URLConnection)object2).setDoOutput(true);
            object = Locale.getDefault() + ", en; q=0.5";
            ((URLConnection)object2).setRequestProperty("Accept-Language", (String)object);
            ((HttpURLConnection)object2).setInstanceFollowRedirects(false);
        }
        if ((object2 = uRLConnection.getContentType()) != null) {
            this.setContentType((String)object2);
        }
        object = uRLConnection.getInputStream();
        return object;
    }

    void read(InputStream inputStream, Document document) throws IOException {
        try {
            String string = (String)this.getClientProperty("charset");
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            this.getEditorKit().read(inputStreamReader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
        catch (ChangedCharSetException changedCharSetException) {
            String string = changedCharSetException.getCharSetSpec();
            if (changedCharSetException.keyEqualsCharSet()) {
                this.putClientProperty("charset", string);
            } else {
                this.setCharsetFromContentTypeParameters(string);
            }
            inputStream.close();
            URL uRL = (URL)document.getProperty("stream");
            URLConnection uRLConnection = uRL.openConnection();
            try {
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setInstanceFollowRedirects(false);
                    httpURLConnection.setDoOutput(true);
                    String string2 = Locale.getDefault() + ", en; q=0.5";
                    httpURLConnection.setRequestProperty("Accept-Language", string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            inputStream = uRLConnection.getInputStream();
            try {
                document.remove(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            document.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            this.read(inputStream, document);
        }
    }

    private void setCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            MyHeaderParser myHeaderParser;
            int n = string.indexOf(59);
            if (n > -1 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            if (string.length() > 0 && (string2 = (myHeaderParser = new MyHeaderParser(string)).findValue("charset")) != null) {
                this.putClientProperty("charset", string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
    }
}

