/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.BrowseHistoryListener;
import com.netscape.management.client.util.Debug;
import java.util.Vector;

class BrowseHtmlHistory {
    private Vector _history = new Vector();
    private int _currIndex = -1;
    private BrowseHistoryListener _listener = null;

    BrowseHtmlHistory() {
    }

    void setPage(String string) {
        Debug.println("BrowseHtmlHistory.setPage: " + string);
        this._history.removeAllElements();
        this._history.addElement(string);
        this._currIndex = 0;
        this.dumpHistory();
    }

    void addPage(String string) {
        Debug.println("BrowseHtmlHistory.addPage: " + string);
        ++this._currIndex;
        if (this._currIndex >= this._history.size()) {
            this._history.addElement(string);
        } else {
            this._history.setElementAt(string, this._currIndex);
        }
        while (this._history.size() > this._currIndex + 1) {
            this._history.removeElementAt(this._history.size() - 1);
        }
        this.notifyHistoryListeners();
        this.dumpHistory();
    }

    void previousPage() {
        if (this._currIndex > 0) {
            --this._currIndex;
            this.notifyHistoryListeners();
        }
        Debug.println("BrowseHtmlHistory.previousPage: " + this._currIndex);
        this.dumpHistory();
    }

    void nextPage() {
        if (this._currIndex < this._history.size() - 1) {
            ++this._currIndex;
            this.notifyHistoryListeners();
        }
        Debug.println("BrowseHtmlHistory.nextPage: " + this._currIndex);
        this.dumpHistory();
    }

    String getCurrentPage() {
        return (String)this._history.elementAt(this.getCurrentIndex());
    }

    int getCurrentIndex() {
        return this._currIndex;
    }

    void notifyHistoryListeners() {
        Debug.println("BrowseHtmlHistory.notifyHistoryListeners: " + this._currIndex + " of " + this._history.size());
        if (this._listener != null) {
            this._listener.historyStateChanged(this._currIndex > 0, this._currIndex < this._history.size() - 1);
        }
    }

    public void addBrowseHistoryListener(BrowseHistoryListener browseHistoryListener) {
        this._listener = browseHistoryListener;
    }

    protected void dumpHistory() {
        Debug.println("BrowseHtmlHistory.dumpHistory:");
        int n = 0;
        while (n < this._history.size()) {
            Debug.print(this._currIndex == n ? Integer.toString(n) + "  " : "   ");
            Debug.println((String)this._history.elementAt(n));
            ++n;
        }
    }
}

