/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.customview;

import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.LDAPPreferenceManager;
import com.netscape.management.client.preferences.LDAPPreferences;
import com.netscape.management.client.topology.ICustomView;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.topology.customview.ViewInfo;
import com.netscape.management.client.topology.customview.ViewSelectorDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class ViewSelectorComponent
extends Box
implements SwingConstants,
SuiConstants {
    LDAPConnection ldc = null;
    String privateViewDN = null;
    String publicViewDN = null;
    TreeModel defaultViewTreeModel = null;
    boolean isViewReloading = false;
    JComboBox viewComboBox = new JComboBox();
    ConsoleInfo consoleInfo;
    ActionListener selectionListener;
    LDAPPreferences userViewPreferences;
    static String _defaultViewPref = "DefaultView";

    static String i18n(String string) {
        return TopologyInitializer._resource.getString("customview", string);
    }

    public ViewSelectorComponent(TreeModel treeModel) {
        super(1);
        this.viewComboBox.setToolTipText(ViewSelectorComponent.i18n("currentViewName_tt"));
        this.defaultViewTreeModel = new ResourceModel((IResourceObject)treeModel.getRoot());
        this.add(this.viewComboBox);
        this.add(Box.createVerticalStrut(6));
    }

    public void initialize(ConsoleInfo consoleInfo) {
        this.consoleInfo = consoleInfo;
        this.ldc = this.consoleInfo.getLDAPConnection();
        LDAPPreferenceManager lDAPPreferenceManager = new LDAPPreferenceManager(consoleInfo.getLDAPConnection(), consoleInfo.getUserPreferenceDN(), "Console", "4.0");
        this.userViewPreferences = (LDAPPreferences)lDAPPreferenceManager.getPreferences("CustomViews");
        this.privateViewDN = this.userViewPreferences.getDN();
        lDAPPreferenceManager = new LDAPPreferenceManager(consoleInfo.getLDAPConnection(), "ou=Global Preferences," + LDAPUtil.getInstalledSoftwareDN(), "admin", "4.0");
        LDAPPreferences lDAPPreferences = (LDAPPreferences)lDAPPreferenceManager.getPreferences("PublicViews");
        this.publicViewDN = lDAPPreferences.getDN();
        Vector vector = this.reloadViewList();
        if (Debug.isEnabled()) {
            Debug.println("pub defaultView=" + lDAPPreferences.getString(_defaultViewPref));
            Debug.println("user defaultView=" + this.userViewPreferences.getString(_defaultViewPref));
        }
        this.setDefaultView(vector, this.userViewPreferences.getString(_defaultViewPref), lDAPPreferences.getString(_defaultViewPref));
    }

    public void addSelectionActionListener(ActionListener actionListener) {
        this.selectionListener = actionListener;
        this.viewComboBox.addActionListener(actionListener);
    }

    public TreeModel getSelectedTreeModel() {
        if (this.isViewReloading) {
            return null;
        }
        ViewInfo viewInfo = (ViewInfo)this.viewComboBox.getSelectedItem();
        this.saveDefaultViewPreference(viewInfo);
        ICustomView iCustomView = viewInfo.getClassInstance();
        if (iCustomView != null) {
            String string = this.getViewDN(viewInfo);
            iCustomView.initialize(this.ldc, string);
            return iCustomView.getTreeModel();
        }
        return this.defaultViewTreeModel;
    }

    void saveDefaultViewPreference(ViewInfo viewInfo) {
        String string;
        String string2 = viewInfo.getID();
        String string3 = "";
        if (string2 != null) {
            string3 = this.getViewDN(viewInfo);
        }
        if ((string = this.userViewPreferences.getString(_defaultViewPref)) != null) {
            DN dN = new DN(string);
            if (dN.equals(new DN(string3))) {
                if (Debug.isEnabled()) {
                    Debug.println(6, "do not need to save DefaultView");
                }
                return;
            }
            if (Debug.isEnabled()) {
                Debug.println(5, "save pref DefaultView=" + string3);
            }
        }
        this.userViewPreferences.set(_defaultViewPref, string3);
        this.userViewPreferences.save();
    }

    void setDefaultView(Vector vector, String string, String string2) {
        String string3;
        String string4 = string3 = string == null ? string2 : string;
        if (string3 != null && string3.length() > 0) {
            DN dN = new DN(string3);
            DN dN2 = null;
            int n = 0;
            while (n < vector.size()) {
                ViewInfo viewInfo = (ViewInfo)vector.elementAt(n);
                if (viewInfo.getID() != null && (dN2 = new DN(this.getViewDN(viewInfo))).equals(dN)) {
                    if (Debug.isEnabled()) {
                        Debug.println("Select Default View - " + viewInfo);
                    }
                    final ViewInfo viewInfo2 = viewInfo;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ViewSelectorComponent.this.viewComboBox.setSelectedItem(viewInfo2);
                        }
                    });
                    break;
                }
                ++n;
            }
        }
    }

    public TreeModel getUserDefaultViewModel() {
        return this.defaultViewTreeModel;
    }

    private String getViewDN(ViewInfo viewInfo) {
        String string = viewInfo.isPublic() ? this.publicViewDN : this.privateViewDN;
        return "cn=" + viewInfo.getID() + "," + string;
    }

    public Vector reloadViewList() {
        this.isViewReloading = true;
        int n = this.viewComboBox.getSelectedIndex();
        this.viewComboBox.removeAllItems();
        this.viewComboBox.addItem(new ViewInfo(null, ViewSelectorComponent.i18n("DefaultView"), null));
        Vector vector = new Vector();
        this.loadViewsFromDN(vector, "cn=CustomView," + LDAPUtil.getAdminGlobalParameterEntry(), null, true);
        this.loadViewsFromDN(vector, this.publicViewDN, "(&(Objectclass=nsCustomView)(nsViewFlags=systemView))", true);
        this.loadViewsFromDN(vector, this.publicViewDN, "(&(Objectclass=nsCustomView)(!(nsViewFlags=systemView)))", true);
        this.loadViewsFromDN(vector, this.privateViewDN, null, false);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ViewInfo viewInfo = (ViewInfo)enumeration.nextElement();
            this.viewComboBox.addItem(viewInfo);
        }
        if (n != -1 && n < this.viewComboBox.getItemCount()) {
            this.viewComboBox.setSelectedIndex(n);
        }
        this.isViewReloading = false;
        return vector;
    }

    public void showConfigDialog() {
        Vector vector = new Vector();
        this.loadViewsFromDN(vector, this.publicViewDN, "(&(Objectclass=nsCustomView)(!(nsViewFlags=systemView)))", true);
        this.loadViewsFromDN(vector, this.privateViewDN, null, false);
        ViewSelectorDialog viewSelectorDialog = new ViewSelectorDialog(this.getParentFrame(this), vector, this.defaultViewTreeModel, this.ldc, this.privateViewDN, this.publicViewDN, this.consoleInfo);
        String string = ((ViewInfo)this.viewComboBox.getSelectedItem()).getID();
        viewSelectorDialog.show();
        this.reloadViewList();
        int n = 0;
        int n2 = this.viewComboBox.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            ViewInfo viewInfo = (ViewInfo)this.viewComboBox.getItemAt(n3);
            String string2 = viewInfo.getID();
            if (string2 != null && string2.equals(string)) {
                n = n3;
                break;
            }
            ++n3;
        }
        this.viewComboBox.setSelectedIndex(n);
        this.selectionListener.actionPerformed(null);
    }

    private void loadViewsFromDN(Vector vector, String string, String string2, boolean bl) {
        block6: {
            LDAPEntry lDAPEntry = null;
            LDAPSearchResults lDAPSearchResults = null;
            if (string2 == null) {
                string2 = "(Objectclass=nsCustomView)";
            }
            try {
                lDAPSearchResults = this.ldc.search(string, 1, string2, null, false);
                if (lDAPSearchResults == null) break block6;
                try {
                    while (lDAPSearchResults.hasMoreElements()) {
                        lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        ViewInfo viewInfo = new ViewInfo(lDAPEntry);
                        viewInfo.setPublic(bl);
                        vector.addElement(viewInfo);
                    }
                }
                catch (Exception exception) {}
            }
            catch (LDAPException lDAPException) {
                Debug.println(0, "Cannot load custom views, error code= " + lDAPException.getLDAPResultCode());
                Debug.println(0, "<dn=" + string + ">");
            }
        }
    }

    private JFrame getParentFrame(Component component) {
        while ((component = component.getParent()) != null && !(component instanceof JFrame)) {
        }
        if (component != null) {
            return (JFrame)component;
        }
        return null;
    }
}

