/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleBytePasswordField;
import com.netscape.management.client.util.SingleByteTextField;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class NewDomainDialog
extends AbstractDialog {
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    private static String sNewDomain = "NewDomain";
    private static String sChangeDirectory = "ChangeDirectory";
    private Help _helpSession = new Help(_resource);
    JTextField _tfDomainName;
    JCheckBox _ssl;
    SingleByteTextField _host;
    JTextField _port;
    JTextField _baseDN;
    JTextField _username;
    JTextField _ownerDN;
    SingleBytePasswordField _password;
    ConsoleInfo _info;

    public NewDomainDialog(Frame frame, ConsoleInfo consoleInfo) {
        super(frame, _resource.getString(sNewDomain, "title"), true, 11);
        this._info = consoleInfo;
        JLabel jLabel = new JLabel(_resource.getString(sNewDomain, "DomainName"), 4);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 2, 0, 0, 0, 0);
        this._tfDomainName = new JTextField();
        jLabel.setLabelFor(this._tfDomainName);
        GridBagUtil.constrain(jPanel, this._tfDomainName, 1, 0, 0, 1, 1.0, 0.0, 17, 2, 0, 9, 0, 0);
        jLabel = new JLabel(_resource.getString(sNewDomain, "UGHost"), 4);
        GridBagUtil.constrain(jPanel, jLabel, 0, 1, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        this._host = new SingleByteTextField();
        jLabel.setLabelFor(this._host);
        GridBagUtil.constrain(jPanel, this._host, 1, 1, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        jLabel = new JLabel(_resource.getString(sNewDomain, "UGPort"), 4);
        GridBagUtil.constrain(jPanel, jLabel, 0, 2, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        this._port = new JTextField(5);
        jLabel.setLabelFor(this._port);
        GridBagUtil.constrain(jPanel, this._port, 1, 2, -1, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        this._ssl = new JCheckBox(_resource.getString(sChangeDirectory, "ssl"));
        this._ssl.setHorizontalAlignment(4);
        GridBagUtil.constrain(jPanel, this._ssl, 2, 2, 1, 1, 1.0, 0.0, 12, 0, 12, 9, 0, 0);
        jLabel = new JLabel(_resource.getString(sNewDomain, "UGSubtree"), 4);
        GridBagUtil.constrain(jPanel, jLabel, 0, 3, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        this._baseDN = new JTextField();
        jLabel.setLabelFor(this._baseDN);
        GridBagUtil.constrain(jPanel, this._baseDN, 1, 3, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        jLabel = new JLabel(_resource.getString(sNewDomain, "BindDN"), 4);
        GridBagUtil.constrain(jPanel, jLabel, 0, 4, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        this._username = new JTextField();
        jLabel.setLabelFor(this._username);
        GridBagUtil.constrain(jPanel, this._username, 1, 4, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        jLabel = new JLabel(_resource.getString(sNewDomain, "BindPassword"), 4);
        GridBagUtil.constrain(jPanel, jLabel, 0, 5, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        this._password = new SingleBytePasswordField();
        jLabel.setLabelFor((Component)((Object)this._password));
        GridBagUtil.constrain(jPanel, (Component)((Object)this._password), 1, 5, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        jLabel = new JLabel(_resource.getString(sNewDomain, "ownerDN"), 4);
        GridBagUtil.constrain(jPanel, jLabel, 0, 6, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        this._ownerDN = new JTextField();
        this._ownerDN.setText(this._info.getAuthenticationDN());
        jLabel.setLabelFor(this._ownerDN);
        GridBagUtil.constrain(jPanel, this._ownerDN, 1, 6, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        JLabel jLabel2 = new JLabel("");
        GridBagUtil.constrain(jPanel, jLabel2, 0, 7, 0, 0, 1.0, 1.0, 17, 1, 12, 0, 0, 0);
        this.setPanel(jPanel);
        this.pack();
    }

    public void helpInvoked() {
        this._helpSession.contextHelp("topology", sNewDomain);
    }

    protected void okInvoked() {
        block24: {
            LDAPEntry lDAPEntry;
            String string;
            String[] stringArray;
            LDAPAttributeSet lDAPAttributeSet;
            int n;
            if (this._tfDomainName.getText().length() == 0) {
                SuiOptionPane.showMessageDialog(null, (Object)_resource.getString(sNewDomain, "domain-error-msg"), (String)_resource.getString(sNewDomain, "domain-error-title"), (int)0);
                return;
            }
            boolean bl = false;
            try {
                n = Integer.parseInt(this._port.getText());
                bl = n > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!bl) {
                SuiOptionPane.showMessageDialog(null, (Object)_resource.getString(sNewDomain, "port-error-msg"), (String)_resource.getString(sNewDomain, "port-error-title"), (int)0);
                return;
            }
            n = DN.isDN((String)this._baseDN.getText()) ? 1 : 0;
            if (n == 0) {
                SuiOptionPane.showMessageDialog(null, (Object)_resource.getString(sNewDomain, "subtreedn-error-msg"), (String)_resource.getString(sNewDomain, "subtreedn-error-title"), (int)0);
                return;
            }
            boolean bl2 = DN.isDN((String)this._username.getText());
            if (!bl2) {
                SuiOptionPane.showMessageDialog(null, (Object)_resource.getString(sNewDomain, "binddn-error-msg"), (String)_resource.getString(sNewDomain, "binddn-error-title"), (int)0);
                return;
            }
            boolean bl3 = DN.isDN((String)this._ownerDN.getText());
            if (!bl3) {
                SuiOptionPane.showMessageDialog(null, (Object)_resource.getString(sNewDomain, "ownerdn-error-msg"), (String)_resource.getString(sNewDomain, "ownerdn-error-title"), (int)0);
                return;
            }
            LDAPConnection lDAPConnection = this._info.getLDAPConnection();
            if (lDAPConnection == null) {
                SuiOptionPane.showMessageDialog(null, (Object)_resource.getString(sNewDomain, "NullConnection"), (String)_resource.getString("error", "title"), (int)0);
                ModalDialogUtil.sleep();
                return;
            }
            try {
                lDAPAttributeSet = new LDAPAttributeSet();
                stringArray = new String[]{"top", "organizationalunit", "nsAdminDomain"};
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
                lDAPAttributeSet.add(new LDAPAttribute("ou", this._tfDomainName.getText()));
                lDAPAttributeSet.add(new LDAPAttribute("nsAdminDomainName", this._tfDomainName.getText()));
                string = this._ownerDN.getText();
                if (string != null && !string.equals("")) {
                    lDAPAttributeSet.add(new LDAPAttribute("aci", "(targetattr=*)(targetfilter=(ou=" + this._tfDomainName.getText() + "))(version 3.0; acl \"Default anonymous access\"; allow(read,search) userdn=\"ldap:///anyone\";)"));
                    lDAPAttributeSet.add(new LDAPAttribute("aci", "(targetattr=*)(version 3.0; acl \"Domain owner access rights\";allow(all) userdn=\"ldap:///" + string + "\";)"));
                }
                lDAPEntry = new LDAPEntry("ou=" + this._tfDomainName.getText() + ", o=netscaperoot", lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                Debug.println("NewDomainDialog: cannot create domain");
                break block24;
            }
            try {
                lDAPAttributeSet = new LDAPAttributeSet();
                stringArray = new String[]{"top", "organizationalunit"};
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
                lDAPAttributeSet.add(new LDAPAttribute("ou", "Global Preferences"));
                lDAPAttributeSet.add(new LDAPAttribute("aci", "(targetattr=*)(version 3.0; acl \"Default anonymous access\"; allow(read,search) userdn=\"ldap:///anyone\";)"));
                lDAPEntry = new LDAPEntry("ou=Global Preferences, ou=" + this._tfDomainName.getText() + ", o=netscaperoot", lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                Debug.println("NewDomainDialog: cannot create domain: ou=Global Preferences, ou=" + this._tfDomainName.getText() + ", o=netscaperoot");
                try {
                    lDAPConnection.delete("ou=" + this._tfDomainName.getText() + ", o=netscaperoot");
                }
                catch (LDAPException lDAPException2) {}
                break block24;
            }
            try {
                String string2;
                String string3;
                String string4;
                lDAPAttributeSet = new LDAPAttributeSet();
                stringArray = new String[]{"top", "nsDirectoryInfo"};
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
                lDAPAttributeSet.add(new LDAPAttribute("cn", "UserDirectory"));
                int n2 = this._host.getText().indexOf(" ");
                if (n2 != -1) {
                    string = "ldap" + (this._ssl.isSelected() ? "s" : "") + "://" + this._host.getText().substring(0, n2) + "/" + this._baseDN.getText();
                    string4 = this._host.getText().substring(n2 + 1);
                } else {
                    string = "ldap" + (this._ssl.isSelected() ? "s" : "") + "://" + this._host.getText() + ":" + this._port.getText() + "/" + this._baseDN.getText();
                    string4 = "";
                }
                Debug.println(string);
                Debug.println(string4);
                if (string != null && !string.equals("") && string4 != null) {
                    lDAPAttributeSet.add(new LDAPAttribute("nsdirectoryurl", string));
                    lDAPAttributeSet.add(new LDAPAttribute("nsdirectoryfailoverlist", string4));
                }
                if ((string3 = this._username.getText()) != null && !string3.equals("")) {
                    lDAPAttributeSet.add(new LDAPAttribute("nsBindDN", string3));
                }
                if ((string2 = ((JPasswordField)((Object)this._password)).getText()) != null && !string2.equals("")) {
                    lDAPAttributeSet.add(new LDAPAttribute("nsBindPassword", string2));
                }
                lDAPEntry = new LDAPEntry("cn=UserDirectory, ou=Global Preferences, ou=" + this._tfDomainName.getText() + ", o=netscaperoot", lDAPAttributeSet);
                lDAPConnection.add(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                Debug.println("NewDomainDialog: cannot create domain: cn=UserDirectory, ou=Global Preferences, ou=" + this._tfDomainName.getText() + ", o=netscaperoot");
                try {
                    lDAPConnection.delete("ou=" + this._tfDomainName.getText() + ", o=netscaperoot");
                    lDAPConnection.delete("ou=Gloabl Preferences, ou=" + this._tfDomainName.getText() + ", o=netscaperoot");
                }
                catch (LDAPException lDAPException3) {}
                break block24;
            }
            super.okInvoked();
            return;
        }
        SuiOptionPane.showMessageDialog(null, (Object)_resource.getString(sNewDomain, "FailToCreate"), (String)_resource.getString("error", "title"), (int)0);
        ModalDialogUtil.sleep();
    }
}

