/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AdminGroupNode;
import com.netscape.management.client.topology.DomainNode;
import com.netscape.management.client.topology.HostNode;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.ServerLocNode;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class DefaultTopologyPlugin
implements ITopologyPlugin {
    public static String name = "com.netscape.management.client.topology.DefaultTopologyPlugin";
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    protected ServiceLocator _sl;
    protected ConsoleInfo _info;

    public void initialize(ConsoleInfo consoleInfo) {
        this._sl = new ServiceLocator(consoleInfo);
        this._info = consoleInfo;
    }

    public Vector getTopNodes() {
        Vector<DomainNode> vector = new Vector<DomainNode>();
        LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)this._sl.getDomains();
        if (lDAPSearchResults != null) {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = null;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                }
                catch (Exception exception) {
                    continue;
                }
                DomainNode domainNode = new DomainNode(this._sl, lDAPEntry);
                vector.addElement(domainNode);
                domainNode.reload();
            }
        }
        return vector;
    }

    public Vector getAdditionalChildren(ResourceObject resourceObject) {
        return null;
    }

    public String getIDByResourceObject(ResourceObject resourceObject) {
        String string = null;
        if (resourceObject instanceof HostNode || resourceObject instanceof AdminGroupNode || resourceObject instanceof DomainNode || resourceObject instanceof ServerNode) {
            ServerLocNode serverLocNode = (ServerLocNode)resourceObject;
            string = serverLocNode.getDN();
        }
        return string;
    }

    public ResourceObject getResourceObjectByID(String string) {
        ServerLocNode serverLocNode;
        block11: {
            Debug.println(6, "DefaultTopologyPlugin.getResourceObjectByID: id=" + string);
            serverLocNode = null;
            try {
                LDAPConnection lDAPConnection = this._info.getLDAPConnection();
                LDAPEntry lDAPEntry = lDAPConnection.read(string);
                if (lDAPEntry != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    if (stringTokenizer.countTokens() == 2) {
                        serverLocNode = new DomainNode(this._sl, lDAPEntry);
                        break block11;
                    }
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (string2.equalsIgnoreCase("nsHost")) {
                            LDAPAttribute lDAPAttribute2 = lDAPEntry.getAttribute("serverhostname");
                            String string3 = lDAPAttribute2 == null ? _resource.getString("General", "noname") : LDAPUtil.flatting(lDAPAttribute2);
                            serverLocNode = new HostNode(this._sl, string, string3);
                        } else if (string2.equalsIgnoreCase("nsAdminDomain")) {
                            serverLocNode = new DomainNode(this._sl, lDAPEntry);
                        } else if (string2.equalsIgnoreCase("nsAdminGroup")) {
                            serverLocNode = new AdminGroupNode(this._sl, lDAPEntry);
                        } else {
                            if (!string2.equalsIgnoreCase("netscapeServer")) continue;
                            serverLocNode = new ServerNode(this._sl, lDAPEntry);
                        }
                        break block11;
                    }
                    break block11;
                }
                Debug.println("getResourceObjectByID() cannot find = " + string);
            }
            catch (LDAPException lDAPException) {
                Debug.println("DefaultTopologyPlugin: cannot create node for: " + string);
                Debug.println(" because " + (Object)((Object)lDAPException));
            }
        }
        return serverLocNode;
    }
}

