/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.preferences.EndsWithFilenameFilter;
import com.netscape.management.client.preferences.FilePreferences;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.Debug;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class FilePreferenceManager
extends PreferenceManager {
    private static String PREFERENCES_FOLDER = ".mcc";
    private static String FILE_SEPARATOR = ".";
    private static String FILE_SUFFIX = ".preferences";
    private Hashtable _prefTable = new Hashtable();
    private String _baseName;

    public FilePreferenceManager(String string, String string2) {
        super(string, string2);
        this._baseName = string + FILE_SEPARATOR + string2 + FILE_SEPARATOR;
    }

    public static String getHomePath() {
        String string;
        File file;
        String string2 = null;
        Properties properties = System.getProperties();
        string2 = (String)((Hashtable)properties).get("user.home");
        if (string2 == null) {
            string2 = ".";
        }
        if (!(file = new File(string = string2 + "/" + PREFERENCES_FOLDER)).exists()) {
            file.mkdir();
        }
        if (!file.exists()) {
            Debug.println("error: cannot create/access" + string);
            return string2;
        }
        return string;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public String[] getPreferencesList() {
        File file = new File(FilePreferenceManager.getHomePath());
        String[] stringArray = file.list(new EndsWithFilenameFilter(FILE_SUFFIX));
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            if (stringArray[n].startsWith(this._baseName)) {
                n2 = this._baseName.length();
            }
            int n3 = stringArray[n].length() - FILE_SUFFIX.length();
            stringArray2[n] = stringArray[n].substring(n2, n3);
            ++n;
        }
        return stringArray2;
    }

    public Preferences getPreferences(String string) {
        Preferences preferences = (Preferences)this._prefTable.get(this._baseName + string);
        if (preferences == null) {
            preferences = new FilePreferences(this._baseName + string + FILE_SUFFIX);
            this._prefTable.put(this._baseName + string, preferences);
        }
        return preferences;
    }

    public void savePreferences() {
        Enumeration enumeration = this._prefTable.elements();
        while (enumeration.hasMoreElements()) {
            Preferences preferences = (Preferences)enumeration.nextElement();
            preferences.save();
        }
    }

    public boolean isPreferencesDirty() {
        Enumeration enumeration = this._prefTable.elements();
        while (enumeration.hasMoreElements()) {
            Preferences preferences = (Preferences)enumeration.nextElement();
            if (!preferences.isDirty()) continue;
            return true;
        }
        return false;
    }
}

