/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.util.ResourceSet;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontFactory {
    private static Hashtable fontHashtable = new Hashtable();
    public static final String FONT_CONTROL = "CONTROLS";
    public static final String FONT_DATA = "DATA_VARIABLE";
    public static final String FONT_MONOSPACED = "DATA_FIXED";
    public static final String FONT_STATUS = "STATUS";
    public static final String FONT_TITLE = "TITLE";
    public static final String FONT_TASK = "TASK";
    public static ResourceSet resource = new ResourceSet("com.netscape.management.client.components.components");

    public static String i18n(String string, String string2) {
        return resource.getString(string, string2);
    }

    public static Enumeration getFontIDs() {
        return fontHashtable.keys();
    }

    public static Font getFont(String string) {
        return (Font)fontHashtable.get(string);
    }

    public static void setFont(String string, Font font) {
        fontHashtable.put(string, font);
    }

    public static String getFontDescription(String string) {
        return FontFactory.i18n("font", string);
    }

    public static void initializeLFFonts() {
        Font font = FontFactory.getFont(FONT_CONTROL);
        Font font2 = FontFactory.getFont(FONT_DATA);
        Font font3 = FontFactory.getFont(FONT_MONOSPACED);
        Font font4 = FontFactory.getFont(FONT_STATUS);
        Font font5 = FontFactory.getFont(FONT_TITLE);
        Font font6 = FontFactory.getFont(FONT_TASK);
        UIManager.put("TaskList.font", font6);
        UIManager.put("Title.font", font5);
        UIManager.put("Status.font", font4);
        UIManager.put("Button.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("TextField.font", font2);
        UIManager.put("PasswordField.font", font3);
        UIManager.put("TextArea.font", font2);
        UIManager.put("TextPane.font", font2);
        UIManager.put("EditorPane.font", font2);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font2);
        UIManager.put("Tree.font", font2);
    }

    public static String toFontInfoString(Font font) {
        return font.getName() + ":" + String.valueOf(font.getStyle()) + ":" + String.valueOf(font.getSize());
    }

    public static Font toFont(String string) {
        String string2 = "SansSerif";
        int n = 0;
        int n2 = 11;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            Integer n3 = new Integer(stringTokenizer.nextToken());
            n = n3;
            n3 = new Integer(stringTokenizer.nextToken());
            n2 = n3;
        }
        return new Font(string2, n, n2);
    }

    static {
        fontHashtable.put(FONT_CONTROL, new FontUIResource("SansSerif", 0, 11));
        fontHashtable.put(FONT_DATA, new FontUIResource("SansSerif", 0, 11));
        fontHashtable.put(FONT_MONOSPACED, new FontUIResource("Monospaced", 0, 11));
        fontHashtable.put(FONT_STATUS, new FontUIResource("SansSerif", 0, 11));
        fontHashtable.put(FONT_TITLE, new FontUIResource("SansSerif", 0, 18));
        fontHashtable.put(FONT_TASK, new FontUIResource("SansSerif", 0, 18));
    }
}

