/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acl;

import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.util.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public abstract class ACL {
    public static final int QUOTE_CHAR = 34;
    protected String resource = null;
    protected String version = null;
    protected Vector rules = new Vector();
    protected String syntax = null;

    public void retrieveACL(Object object) {
        try {
            Reader reader = this.openACLReader(object);
            if (reader == null) {
                this.setDefaults();
                return;
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            this.parse(streamTokenizer);
            reader.close();
        }
        catch (Exception exception) {
            System.err.println("ACL:retrieveACL():" + exception);
            this.setDefaults();
        }
    }

    protected void copy(ACL aCL) {
        this.resource = aCL.resource;
        this.version = aCL.version;
        this.rules = aCL.rules;
        this.syntax = aCL.syntax;
    }

    public void updateACL(Object object) throws Exception {
        Writer writer = this.openACLWriter(object);
        if (!this.syntaxOverrideSet()) {
            if (this.rules.size() > 0) {
                this.write(writer);
            }
        } else {
            writer.write(this.syntax);
        }
        writer.close();
    }

    public String getResourceString() {
        return this.resource;
    }

    public void setResourceString(String string) {
        this.resource = string;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public Rule newRule(StreamTokenizer streamTokenizer) throws Exception {
        return new Rule(streamTokenizer);
    }

    public Rule newRule() {
        return new Rule();
    }

    public void appendRule() {
        this.rules.addElement(this.newRule());
    }

    public void appendRule(StreamTokenizer streamTokenizer) throws Exception {
        this.rules.addElement(this.newRule(streamTokenizer));
    }

    public void insertRule(int n) {
        this.rules.insertElementAt(this.newRule(), n);
    }

    public void deleteRule(int n) {
        this.rules.removeElementAt(n);
    }

    public void swapRules(int n, int n2) {
        Object e = this.rules.elementAt(n);
        Object e2 = this.rules.elementAt(n2);
        this.rules.setElementAt(e, n2);
        this.rules.setElementAt(e2, n);
    }

    public Rule getRule(int n) {
        return (Rule)this.rules.elementAt(n);
    }

    public String getSyntax() {
        if (this.syntax != null) {
            return this.syntax;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            this.write(stringWriter);
            stringWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void setSyntax(String string) {
        this.syntax = string;
    }

    public void setSyntaxOverride(String string) {
        this.syntax = string;
    }

    public boolean syntaxOverrideSet() {
        return this.syntax != null;
    }

    public void clearSyntaxOverride() {
        this.syntax = null;
    }

    public String toString() {
        String string = "-----------------------------------------------\n";
        int n = 0;
        while (n < this.rules.size()) {
            string = string + "Rule: " + n + '\n';
            string = string + this.rules.elementAt(n).toString();
            string = string + '\n';
            ++n;
        }
        string = string + "-----------------------------------------------\n";
        return string;
    }

    protected void parseHeader(StreamTokenizer streamTokenizer) throws IOException {
        int n;
        Debug.println("ACL.parseHeader: Parsing ACL Header.");
        block6: while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case -3: {
                    if (streamTokenizer.sval.equals("acl") || streamTokenizer.sval.equals("version")) continue block6;
                    if (streamTokenizer.sval.equals("allow") || streamTokenizer.sval.equals("deny") || streamTokenizer.sval.equals("authenticate")) {
                        streamTokenizer.pushBack();
                        if (this.resource != null) {
                            return;
                        }
                        throw new IOException("Resource string not found in ACL header");
                    }
                    throw new IOException("Unrecognized token in ACL resource header (" + streamTokenizer.sval + ")");
                }
                case -2: {
                    Debug.println("ACL.parseHeader: Version = " + streamTokenizer.nval);
                    this.version = Double.toString(streamTokenizer.nval);
                    break;
                }
                case 59: {
                    break;
                }
                case 34: {
                    Debug.println("ACL.parseHeader: Resource = " + streamTokenizer.sval);
                    this.resource = streamTokenizer.sval;
                    break;
                }
                default: {
                    throw new IOException("Unrecognized token in ACL resource header");
                }
            }
        }
        throw new EOFException("Unexpected EOF while parsing ACL resource header");
    }

    protected abstract Reader openACLReader(Object var1) throws Exception;

    protected abstract Writer openACLWriter(Object var1) throws Exception;

    protected abstract void parse(StreamTokenizer var1) throws Exception;

    protected abstract void write(Writer var1) throws Exception;

    protected void setDefaults() {
        this.resource = "unknown";
        this.version = "3.0";
        this.appendRule();
    }
}

