/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.jasper.Constants;

public class JspWriterImpl
extends JspWriter {
    protected Writer out;
    protected ServletResponse response;
    protected char[] cb;
    protected int nextChar;
    protected static int defaultCharBufferSize = 8192;
    protected boolean flushed = false;
    static String lineSeparator = System.getProperty("line.separator");

    public JspWriterImpl() {
        super(defaultCharBufferSize, true);
    }

    public JspWriterImpl(ServletResponse servletResponse) {
        this(servletResponse, defaultCharBufferSize, true);
    }

    public JspWriterImpl(ServletResponse servletResponse, int n, boolean bl) {
        super(n, bl);
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.response = servletResponse;
        this.cb = n == 0 ? null : new char[n];
        this.nextChar = 0;
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException(Constants.getString("jsp.error.overflow"));
    }

    public final void clear() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException(Constants.getString("jsp.error.ise_on_clear"));
            }
            if (this.flushed) {
                throw new IOException(Constants.getString("jsp.error.attempt_to_clear_flushed_buffer"));
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    public void clearBuffer() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException(Constants.getString("jsp.error.ise_on_clear"));
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    public void close() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (this.response == null) {
                Object var2_2 = null;
                return;
            }
            this.flush();
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.response == null) {
            throw new IOException("Stream closed");
        }
    }

    public void flush() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.flushBuffer();
            if (this.out != null) {
                this.out.flush();
                this.response.flushBuffer();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void flushBuffer() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                return;
            }
            this.flushed = true;
            this.ensureOpen();
            if (this.nextChar == 0) return;
            this.initOut();
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
            return;
        }
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    void init(ServletResponse servletResponse, int n, boolean bl) {
        this.response = servletResponse;
        if (n > 0 && (this.cb == null || n > this.cb.length)) {
            this.cb = new char[n];
        }
        this.nextChar = 0;
        this.autoFlush = bl;
        this.bufferSize = n;
    }

    protected void initOut() throws IOException {
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
    }

    private int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public void newLine() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.write(lineSeparator);
        }
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(int n) throws IOException {
        this.write(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(Object object) throws IOException {
        this.write(String.valueOf(object));
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(boolean bl) throws IOException {
        this.write(bl ? "true" : "false");
    }

    public void print(char[] cArray) throws IOException {
        this.write(cArray);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(char c) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    public void println(double d) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    public void println(float f) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    public void println(int n) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(n);
            this.println();
        }
    }

    public void println(long l) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    public void println(Object object) throws IOException {
        Object object2 = ((Writer)((Object)this)).lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }

    public void println(String string) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    public void println(boolean bl) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(bl);
            this.println();
        }
    }

    public void println(char[] cArray) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    void recycle() {
        this.flushed = false;
        this.nextChar = 0;
    }

    public void write(int n) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(n);
            } else {
                if (this.nextChar >= this.bufferSize) {
                    if (this.autoFlush) {
                        this.flushBuffer();
                    } else {
                        this.bufferOverflow();
                    }
                }
                this.cb[this.nextChar++] = (char)n;
            }
        }
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(string, n, n2);
                Object var5_5 = null;
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this.min(this.bufferSize - this.nextChar, n4 - n3);
                string.getChars(n3, n3 + n5, this.cb, this.nextChar);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(cArray, n, n2);
                return;
            }
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n > cArray.length) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n + n2 > cArray.length) throw new IndexOutOfBoundsException();
            if (n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (n2 >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
                this.initOut();
                this.out.write(cArray, n, n2);
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            while (true) {
                if (n3 >= n4) {
                    return;
                }
                int n5 = this.min(this.bufferSize - this.nextChar, n4 - n3);
                System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }
}

