/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.IContextProperties;
import com.iplanet.server.http.servlet.IServletStat;
import com.iplanet.server.http.servlet.NSServletContext;
import com.iplanet.server.http.servlet.NSServletRunner;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.session.IWSSessionManager;
import com.iplanet.server.http.session.MMapSessionManager;
import java.util.Enumeration;
import javax.servlet.ServletContext;

public class ServletStat
implements IServletStat {
    private NSServletContext _context;
    private NSServletRunner _runner;

    public ServletStat(ServletContext servletContext) {
        this._context = (NSServletContext)servletContext;
        this._runner = this._context.getRunner();
    }

    public Enumeration getAllContexts() {
        return NSServletRunner.getContexts();
    }

    public String getContextName(ServletContext servletContext) {
        NSServletContext nSServletContext = (NSServletContext)servletContext;
        return nSServletContext.getName();
    }

    public int getMaxSession(ServletContext servletContext) {
        NSServletContext nSServletContext = (NSServletContext)servletContext;
        IWSHttpSessionManager iWSHttpSessionManager = nSServletContext.getHttpSessionManager();
        return iWSHttpSessionManager.getMaxSession();
    }

    public int getSessionCount(ServletContext servletContext) {
        NSServletContext nSServletContext = (NSServletContext)servletContext;
        IWSHttpSessionManager iWSHttpSessionManager = nSServletContext.getHttpSessionManager();
        return iWSHttpSessionManager.getSessionCount();
    }

    public String getSessionManagerClassName(ServletContext servletContext) {
        NSServletContext nSServletContext = (NSServletContext)servletContext;
        IWSHttpSessionManager iWSHttpSessionManager = nSServletContext.getHttpSessionManager();
        if (iWSHttpSessionManager instanceof IWSSessionManager) {
            return "com.iplanet.server.http.session.IWSSessionManager";
        }
        if (iWSHttpSessionManager instanceof MMapSessionManager) {
            return "com.iplanet.server.http.session.MMapSessionManager";
        }
        IContextProperties iContextProperties = nSServletContext.getContextProperties();
        return iContextProperties.getSessionManagerClassName();
    }
}

