/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.CommunityList;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SNMPCommunityPanel
extends PluginConfigPanel {
    IConfigDataModel _configData;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nDescription = _resource.getString("snmpcom", "Description");
    static String _i18nDetailsGroupbox = _resource.getString("snmpcom", "DetailsGroupbox");
    static String _i18nOperationsAll = _resource.getString("snmpcom", "OperationsAll");
    static String _i18nOperationsGET = _resource.getString("snmpcom", "OperationsGET");
    static String _i18nOperationsSET = _resource.getString("snmpcom", "OperationsSET");
    static String _i18nDetailName = _resource.getString("snmpcom", "DetailName");
    static String _i18nDetailOperations = _resource.getString("snmpcom", "DetailOperations");
    static String _i18nEditDialogCommunity = _resource.getString("snmpcom", "EditDialogCommunity");
    static String _i18nEditDialogTitle = _resource.getString("snmpcom", "EditDialogTitle");
    static String _i18nAddDialogTitle = _resource.getString("snmpcom", "AddDialogTitle");
    static String _i18nMsgEnterCommunity;
    static String _i18nEditDialogOperationsGroupbox;
    Help _help;
    JLabel _lblDescription;
    CommunityList _communityList;
    Vector _communities = new Vector();

    public SNMPCommunityPanel(String string, IConfigDataModel iConfigDataModel) {
        super(string);
        this._configData = iConfigDataModel;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makePanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("SNMPCommunityHelp");
    }

    public void initialize() throws ConfigPanelException {
        this.setPanelContent(this._configData);
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) throws ValidationException {
        this._configData = iConfigDataModel;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void resetContent() throws ConfigPanelException {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ValidationException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        this._communityList.addListDataListener(editMonitor);
    }

    public void setPanelContent(IConfigDataModel iConfigDataModel) throws ValidationException {
        String string = iConfigDataModel.getAttribute("snmp.communities");
        this._communities = CGISNMPSetup.stringToCommunityVector(string);
        this._communityList.setCommunities(this._communities);
    }

    public void getPanelContent(IConfigDataModel iConfigDataModel) throws ValidationException {
        String string = CGISNMPSetup.communityVectorToString(this._communities);
        iConfigDataModel.setAttribute("snmp.communities", string);
    }

    protected JComponent makePanel() {
        JPanel jPanel = new JPanel();
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(_i18nDescription);
        gBC.setInsets(10, 0, 10, 0);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)jLabel, gBC);
        this._communityList = new CommunityList(this._communities);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._communityList, gBC);
        return jPanel;
    }

    static {
        _i18nEditDialogOperationsGroupbox = _resource.getString("snmpcom", "EditDialogOperationsGroupbox");
        _i18nMsgEnterCommunity = _resource.getString("snmpcom", "MsgEnterCommunity");
    }
}

