/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.panel.AdminOperation;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.admserv.panel.TimeoutAdmTask;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;

public class RestartOperation
extends AdminOperation {
    protected static int STATE_REQ_RESTART = 0;
    protected static int STATE_GET_NEWPID = 1;
    protected int _oldPID = -1;
    protected int _newPID = -1;
    protected int _state;
    protected String _taskArguments = "op=restart";
    protected IRestartControl _restartControl;
    String _i18nSendRequest = AdminOperation._resource.getString("restart", "SendRequest");
    String _i18nAccepted = AdminOperation._resource.getString("restart", "Accepted");
    String _i18nWait = AdminOperation._resource.getString("restart", "Wait");
    String _i18nDone = AdminOperation._resource.getString("restart", "Done");
    String _i18nStopped = AdminOperation._resource.getString("restart", "Stopped");

    public RestartOperation(ConsoleInfo consoleInfo) {
        super(consoleInfo, "admin-serv/tasks/Operation/Restart");
        this._restartControl = (IRestartControl)this._consoleInfo.get("RESTART_CONTROL");
        this.createActionPanel(true);
    }

    protected void createTask(ConsoleInfo consoleInfo, String string) throws RemoteRequestException {
        try {
            this._task = new TimeoutAdmTask(new URL(string), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((String)("" + malformedURLException));
            throw new RemoteRequestException(malformedURLException);
        }
        this._task.setArguments(this._taskArguments);
    }

    public void performOperationalTask(ConsoleInfo consoleInfo, String string) throws RemoteRequestException {
        this._state = STATE_REQ_RESTART;
        this._newPID = -1;
        this._oldPID = -1;
        this._taskArguments = "op=restart";
        this._actionPanel.setStatusText(this._i18nSendRequest);
        super.performOperationalTask(consoleInfo, string);
        this._actionPanel.setStatusText(this._i18nAccepted);
        if (this._task != null && this._task.getResult() != null) {
            String string2 = (String)this._task.getResult().get("pid");
            try {
                this._oldPID = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.println((String)("restart pid =" + string2));
        }
        if (this._oldPID == -1) {
            throw new RemoteRequestException(string, "No server PID in CGI response,\nRestart CGI needs to be upgraded to the latest version");
        }
        if (this._restartControl != null) {
            this._restartControl.setNeedsAutoRestart(false);
        }
        long l = System.currentTimeMillis();
        boolean bl = false;
        this._state = STATE_GET_NEWPID;
        this._taskArguments = "op=getpid";
        this.createTask(consoleInfo, consoleInfo.getAdminURL() + this._taskURL);
        ((TimeoutAdmTask)this._task).setMaxWaitInterval(5000L);
        this._actionPanel.setStatusText(this._i18nWait);
        this._actionPanel.setStatusTextSameLIne("\n");
        while (this._newPID == -1 || this._newPID == this._oldPID) {
            String string3;
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.println((String)("Exec " + ((TimeoutAdmTask)this._task).getURL()));
            this._task.exec();
            this.processAdmTaskStatus(string);
            if (!bl && this._task != null && this._task.getStatus() == -1 && this._task.getException() != null && this._task.getException() instanceof ConnectException) {
                bl = true;
                this._actionPanel.setStatusTextSameLIne("\n" + this._i18nStopped + "\n");
                String string4 = string3 = this._restartControl == null ? null : this._restartControl.getPostRestartURL();
                if (string3 != null) {
                    Debug.println((String)("post restart URL = " + string3));
                    this._consoleInfo.setAdminURL(string3);
                    this.createTask(consoleInfo, string3 + this._taskURL);
                    ((TimeoutAdmTask)this._task).setMaxWaitInterval(5000L);
                }
            }
            if (this._task != null && this._task.getStatus() == 0 && this._task.getResult() != null) {
                string3 = (String)this._task.getResult().get("pid");
                try {
                    this._newPID = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Debug.println((String)("getpid pid =" + string3 + " old pid = " + this._oldPID));
            }
            this._actionPanel.setStatusTextSameLIne("*");
            if (System.currentTimeMillis() - l <= 90000L) continue;
            l = System.currentTimeMillis();
            this._actionPanel.setStatusTextSameLIne("\n");
        }
        this._actionPanel.setStatusText(this._i18nDone + "\n");
        Debug.println((String)("Operation time = " + (double)(System.currentTimeMillis() - l) / 1000.0));
    }

    public void processAdmTaskStatus(String string) throws RemoteRequestException {
        Debug.println((String)("status=" + this._task.getStatus() + " ex=" + this._task.getException() + " result=" + this._task.getResult()));
        int n = this._task.getStatus();
        if (this._state == STATE_GET_NEWPID) {
            if (n == -1) {
                Debug.println((String)("getpid request error " + this._task.getException()));
                return;
            }
            if (n == -2) {
                Debug.println((String)"getpid request timedout");
                return;
            }
        }
        super.processAdmTaskStatus(string);
    }
}

