/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ActionMonitorPanel;
import com.netscape.management.admserv.config.ConfigErrorDialog;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.SwingWorker;
import com.netscape.management.admserv.panel.IAdminOperationListener;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.Permissions;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;

public class AdminOperation {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nStatus = _resource.getString("adminop", "Status");
    static String _i18nFailureStatus = _resource.getString("adminop", "FailureStatus");
    static String _i18nWarningStatus = _resource.getString("adminop", "WarningStatus");
    static String _i18nCanNotConnect = _resource.getString("adminop", "CanNotConnect");
    static String _i18nServerShutdown = _resource.getString("adminop", "ServerShutdown");
    static String _i18nOperationDone = _resource.getString("adminop", "OperationDone");
    static String _i18nOperationFailed = _resource.getString("adminop", "OperationFailed");
    protected ConsoleInfo _consoleInfo;
    protected boolean _actionPerformed;
    protected Hashtable _resultData;
    protected int _resultStatus;
    protected String _taskURL;
    protected IAdminOperationListener _listener;
    protected ActionMonitorPanel _actionPanel;
    protected AdmTask _task;

    public AdminOperation(ConsoleInfo consoleInfo, String string) {
        this._consoleInfo = consoleInfo;
        this._taskURL = string;
    }

    public JPanel getPanel() {
        return this._actionPanel;
    }

    public Hashtable getConsoleInfo() {
        return this._consoleInfo;
    }

    public Dialog getDialog() {
        Container container = this._actionPanel;
        Dialog dialog = null;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof Dialog)) continue;
            dialog = (Dialog)container;
            break;
        }
        return dialog;
    }

    public Frame getFrame() {
        Container container = this._actionPanel;
        Frame frame = null;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof Frame)) continue;
            frame = (Frame)container;
            break;
        }
        return frame;
    }

    protected void closeDialog() {
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            ((Component)dialog).setVisible(false);
            dialog.dispose();
            ModalDialogUtil.sleep();
        }
    }

    protected void createActionPanel(boolean bl) {
        this._actionPanel = new ActionMonitorPanel(bl);
    }

    public void monitorOperation(String string) {
        this.monitorOperation(string, null);
    }

    public void monitorOperation(String string, IAdminOperationListener objectArray) {
        Object[] objectArray2;
        Method method;
        if (ActionMonitorPanel.getActiveInstance() != null) {
            this._actionPanel = ActionMonitorPanel.getActiveInstance();
            this._actionPanel.setStatusText(string);
            try {
                this.performOperation((IAdminOperationListener)objectArray);
            }
            catch (RemoteRequestException remoteRequestException) {
                ConfigErrorDialog.showDialog(this._actionPanel, remoteRequestException);
            }
            return;
        }
        if (this._actionPanel == null) {
            this.createActionPanel(false);
        }
        if ((method = Permissions.getEnablePrivilegeMethod()) != null) {
            objectArray2 = new Object[]{"UniversalThreadGroupAccess"};
            try {
                method.invoke(null, objectArray2);
            }
            catch (Exception exception) {
                Debug.println((String)("AdminOperation:monitorOperation():unable to grant ThreadGroup privileges:" + exception));
            }
        }
        objectArray2 = objectArray;
        SwingWorker swingWorker = new SwingWorker((IAdminOperationListener)objectArray2){
            RemoteRequestException _rrx = null;
            private final /* synthetic */ IAdminOperationListener val$listenerObject;
            {
                this.val$listenerObject = iAdminOperationListener;
            }

            public Object construct() {
                try {
                    AdminOperation.this.performOperation(this.val$listenerObject);
                }
                catch (RemoteRequestException remoteRequestException) {
                    this._rrx = remoteRequestException;
                }
                return null;
            }

            public void finished() {
                if (this._rrx != null) {
                    ConfigErrorDialog.showDialog(AdminOperation.this._actionPanel, this._rrx);
                }
                if (this._rrx == null && AdminOperation.this._actionPanel.isMultilined()) {
                    AdminOperation.this._actionPanel.monitorProgressWaitForClose();
                    return;
                }
                AdminOperation.this._actionPanel.monitorProgressStop(AdminOperation.this._actionPerformed ? _i18nOperationDone : _i18nOperationFailed);
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AdminOperation.this.closeDialog();
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminOperation.this.closeDialog();
            }
        };
        this._actionPanel.monitorProgressStart(string, swingWorker, actionListener);
        swingWorker.start();
    }

    public void performOperation(IAdminOperationListener iAdminOperationListener) throws RemoteRequestException {
        this.performOperationalTask(this._consoleInfo, this._taskURL);
        if (iAdminOperationListener != null) {
            iAdminOperationListener.cgiRequestCompleted(this._consoleInfo);
        }
    }

    protected void createTask(ConsoleInfo consoleInfo, String string) throws RemoteRequestException {
        try {
            this._task = new AdmTask(new URL(string), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((String)("" + malformedURLException));
            throw new RemoteRequestException(malformedURLException);
        }
    }

    public void performOperationalTask(ConsoleInfo consoleInfo, String string) throws RemoteRequestException {
        String string2 = consoleInfo.getAdminURL() + string;
        this.createTask(consoleInfo, string2);
        this._task.exec();
        this._resultStatus = this._task.getStatus();
        this._resultData = this._task.getResult();
        this._actionPerformed = this._resultStatus == 0 || this._resultStatus == 3;
        this.processAdmTaskStatus(string2);
    }

    public boolean isActionPerformed() {
        return this._actionPerformed;
    }

    public int getResultStatus() {
        return this._resultStatus;
    }

    public Hashtable getResultData() {
        return this._resultData;
    }

    protected void processAdmTaskStatus(String string) throws RemoteRequestException {
        AdminOperation.processAdmTaskStatus(string, this._task, this._consoleInfo);
    }

    public static void processAdmTaskStatus(String string, AdmTask admTask, ConsoleInfo consoleInfo) throws RemoteRequestException {
        int n = admTask.getStatus();
        if (n == 0 || n == 3) {
            return;
        }
        if (n < 0) {
            Debug.println((String)("HTTP Exception status=" + n + " " + admTask.getException()));
            if (admTask.getException() != null && admTask.getException() instanceof SocketException) {
                IRestartControl iRestartControl = (IRestartControl)consoleInfo.get("RESTART_CONTROL");
                if (iRestartControl != null) {
                    if (iRestartControl.isServerShutdown()) {
                        throw new RemoteRequestException("", _i18nServerShutdown);
                    }
                } else {
                    Debug.println((String)"StopOperation: restart activator not in ConsoleInfo");
                }
                throw new RemoteRequestException(string, _i18nCanNotConnect + " " + admTask.getException().getMessage());
            }
            if (admTask.getException() != null) {
                throw new RemoteRequestException(admTask.getException());
            }
            throw new RemoteRequestException(string, _i18nStatus + n);
        }
        String string2 = n == 1 ? _i18nStatus + _i18nFailureStatus : (n == 2 ? _i18nStatus + _i18nWarningStatus : _i18nStatus + " " + n);
        String string3 = "";
        Hashtable hashtable = admTask.getResult();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                string3 = string3 + v + "\n";
            }
        }
        Debug.println((String)("CGI error " + string2 + "\n" + string3));
        throw new RemoteRequestException(string, string2 + "\n" + string3);
    }
}

