/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.config;

import com.netscape.management.admserv.config.ActionMonitorPanel;
import com.netscape.management.admserv.config.ButtonBar;
import com.netscape.management.admserv.config.ConfigErrorDialog;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.IPluginConfigPanel;
import com.netscape.management.admserv.config.SwingWorker;
import com.netscape.management.admserv.panel.DialogFrame;
import com.netscape.management.client.Framework;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Permissions;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BaseConfigPanel
extends JPanel
implements SuiConstants {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.config.config");
    static String _i18nStatusLoading = _resource.getString("baseconfig", "StatusLoading");
    static String _i18nStatusSaving = _resource.getString("baseconfig", "StatusSaving");
    static String _i18nLoadFailed = _resource.getString("baseconfig", "LoadFailed");
    static String _i18nSaveToolTip = _resource.getString("baseconfig", "SaveToolTip");
    static String _i18nResetToolTip = _resource.getString("baseconfig", "ResetToolTip");
    static String _i18nHelpToolTip = _resource.getString("baseconfig", "HelpToolTip");
    private static String[] _toolTips = new String[]{_i18nSaveToolTip, _i18nResetToolTip, null, _i18nHelpToolTip};
    protected JLabel _heading;
    protected ButtonBar _cmdButtons;
    protected JComboBox _targetChoice;
    protected EditMonitor _editMonitor;
    protected JPanel _editPanel;
    protected ActionMonitorPanel _actionPanel = new ActionMonitorPanel();
    protected CardLayout _card;
    protected boolean _initialized;
    protected boolean _dataValid;
    protected boolean _dataSaved;
    protected static Font _fontHeadingLabel = UIManager.getFont("Title.font");
    protected static Font _fontLabel = UIManager.getFont("Panel.font");
    protected IPluginConfigPanel _pluginPanel;
    protected boolean _hasTitle;
    protected boolean _inDialog;
    ActionListener _btnListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            BaseConfigPanel.this.commandButtonAction(actionEvent.getActionCommand());
        }
    };
    private boolean _actionPanelAdded = false;
    static /* synthetic */ Class class$com$netscape$management$client$Framework;
    static /* synthetic */ Class class$com$netscape$management$admserv$panel$DialogFrame;

    public BaseConfigPanel(IPluginConfigPanel iPluginConfigPanel) {
        this(iPluginConfigPanel, false);
    }

    public BaseConfigPanel(IPluginConfigPanel iPluginConfigPanel, boolean bl) {
        int n = 3;
        int n2 = 3;
        this._card = new CardLayout();
        this.setLayout(this._card);
        if (!bl) {
            this.setBorder(BorderFactory.createEmptyBorder(n, n2, n, n2));
        }
        this._inDialog = bl;
        this._editPanel = new JPanel();
        this._editPanel.setLayout(new BorderLayout(0, 12));
        this.add((Component)this._editPanel, "edit");
        this.setPluginPanel(iPluginConfigPanel);
    }

    public void setPluginPanel(IPluginConfigPanel iPluginConfigPanel) {
        this._pluginPanel = iPluginConfigPanel;
        this._cmdButtons = this.createCommandButtonBar();
        this._editMonitor = this.createEditMonitor();
        this._hasTitle = this._pluginPanel.getTitleText() != null && this._pluginPanel.getTitleText().length() != 0;
        this._heading = this.createHeadingLabel(this._pluginPanel.getTitleText());
        this.createEditLayout();
        if (this.isPluginModelLoaded()) {
            this.showPanel(this._editPanel);
            this.initPluginPanel();
        } else {
            this.monitorPluginPanelInit();
        }
    }

    public boolean isInitialized() {
        if (this._initialized) {
            this.showPanel(this._editPanel);
        }
        return this._initialized;
    }

    public IPluginConfigPanel getPluginPanel() {
        return this._pluginPanel;
    }

    public static BaseConfigPanel getInstance(Component component) {
        while (component != null && !(component instanceof BaseConfigPanel)) {
            component = component.getParent();
        }
        return (BaseConfigPanel)component;
    }

    protected boolean isPluginModelLoaded() {
        IConfigDataModel iConfigDataModel = this._pluginPanel.getDataModel();
        return iConfigDataModel != null && iConfigDataModel.isLoaded();
    }

    protected void initPluginPanel() {
        this._initialized = false;
        try {
            IConfigDataModel iConfigDataModel = this._pluginPanel.getDataModel();
            if (iConfigDataModel != null && !iConfigDataModel.isLoaded()) {
                iConfigDataModel.load();
            }
            this._pluginPanel.initialize();
        }
        catch (ConfigPanelException configPanelException) {
            ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), configPanelException);
            return;
        }
        this._pluginPanel.registerEditComponents(this._editMonitor);
        this._editMonitor.start();
        this._initialized = true;
    }

    protected void monitorPluginPanelInit() {
        Object[] objectArray;
        Method method = Permissions.getEnablePrivilegeMethod();
        if (method != null) {
            objectArray = new Object[]{"UniversalThreadGroupAccess"};
            try {
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                Debug.println((String)("ThreadGroup:monitorPluginPanelInit():unable to grant ThreadGroup privileges:" + exception));
            }
        }
        this.showPanel(this._actionPanel);
        objectArray = new SwingWorker(){

            public Object construct() {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseConfigPanel.this.initPluginPanel();
                return null;
            }

            public void finished() {
                BaseConfigPanel.this._actionPanel.monitorProgressStop(BaseConfigPanel.this._initialized ? "" : _i18nLoadFailed);
                if (BaseConfigPanel.this._initialized) {
                    BaseConfigPanel.this.showPanel(BaseConfigPanel.this._editPanel);
                } else if (BaseConfigPanel.this._inDialog) {
                    BaseConfigPanel.this.closeDialog();
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseConfigPanel.this.closeDialog();
            }
        };
        this._actionPanel.monitorProgressStart(_i18nStatusLoading, (SwingWorker)objectArray, actionListener);
        objectArray.start();
    }

    protected void createEditLayout() {
        if (this._heading != null) {
            this._editPanel.add((Component)this.createNorthPanel(), "North");
        }
        if (this._pluginPanel != null) {
            this._editPanel.add((Component)this.createCenterPanel(), "Center");
        }
        if (this._cmdButtons != null) {
            this._editPanel.add((Component)this.createSouthPanel(), "South");
        }
    }

    protected JPanel createNorthPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 12));
        if (this._heading != null) {
            jPanel.add((Component)this._heading, "North");
        }
        return jPanel;
    }

    protected JPanel createCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._pluginPanel.getPanel(), "Center");
        return jPanel;
    }

    protected JLabel createHeadingLabel(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        JLabel jLabel = new JLabel(string, 2);
        jLabel.setFont(_fontHeadingLabel);
        return jLabel;
    }

    protected JPanel createSouthPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._cmdButtons, "East");
        return jPanel;
    }

    public ButtonBar createCommandButtonBar() {
        ButtonBar buttonBar = new ButtonBar(this._inDialog, _toolTips);
        buttonBar.addActionListener(this._btnListener);
        return buttonBar;
    }

    public ButtonBar getCommandButtonBar() {
        return this._cmdButtons;
    }

    protected EditMonitor createEditMonitor() {
        if (this._cmdButtons == null) {
            return null;
        }
        EditMonitor editMonitor = new EditMonitor();
        editMonitor.addEnableComponent(this._cmdButtons.getButton("ok"));
        if (!this._inDialog) {
            editMonitor.addEnableComponent(this._cmdButtons.getButton("cancel"));
        }
        return editMonitor;
    }

    public EditMonitor getEditMonitor() {
        return this._editMonitor;
    }

    protected void commandButtonAction(String string) {
        block12: {
            if (string.equals("ok")) {
                this._dataSaved = false;
                this._dataValid = false;
                try {
                    this._pluginPanel.applyChanges();
                    this._dataValid = true;
                    if (this.isPluginModelModified()) {
                        this.monitorLongAction(_i18nStatusSaving, new Runnable(){

                            public void run() {
                                BaseConfigPanel.this.savePluginPanel();
                            }
                        });
                        break block12;
                    }
                    this._editMonitor.setDirtyFlag(false);
                }
                catch (ConfigPanelException configPanelException) {
                    ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), configPanelException);
                }
            } else if (string.equals("cancel")) {
                if (this._inDialog) {
                    this.closeDialog();
                    return;
                }
                try {
                    this._pluginPanel.resetContent();
                }
                catch (ConfigPanelException configPanelException) {
                    ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), configPanelException);
                    return;
                }
                this._editMonitor.setDirtyFlag(false);
            } else if (string.equals("help")) {
                this._pluginPanel.showHelp();
            } else {
                Debug.println((String)(string + " not implemented"));
            }
        }
    }

    protected boolean isPluginModelModified() {
        IConfigDataModel iConfigDataModel = this._pluginPanel.getDataModel();
        return iConfigDataModel != null && iConfigDataModel.isModified();
    }

    void savePluginPanel() {
        try {
            this._pluginPanel.getDataModel().save();
            this._dataSaved = true;
            this._pluginPanel.resetContent();
            this._editMonitor.setDirtyFlag(false);
            this.closeDialog();
        }
        catch (ConfigPanelException configPanelException) {
            ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), configPanelException);
        }
    }

    public void monitorLongAction(Runnable runnable) {
        this.monitorLongAction(_i18nStatusLoading, runnable);
    }

    public void monitorLongAction(String string, Runnable runnable) {
        Object[] objectArray;
        Method method = Permissions.getEnablePrivilegeMethod();
        if (method != null) {
            objectArray = new Object[]{"UniversalThreadGroupAccess"};
            try {
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                Debug.println((String)("BaseConfigPanel:monitorLongAction():unable to grant ThreadGroup privileges:" + exception));
            }
        }
        this.showPanel(this._actionPanel);
        objectArray = runnable;
        SwingWorker swingWorker = new SwingWorker((Runnable)objectArray){
            private final /* synthetic */ Runnable val$actionTask;
            {
                this.val$actionTask = runnable;
            }

            public Object construct() {
                this.val$actionTask.run();
                return null;
            }

            public void finished() {
                BaseConfigPanel.this._actionPanel.monitorProgressStop("");
                BaseConfigPanel.this.showPanel(BaseConfigPanel.this._editPanel);
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseConfigPanel.this.showPanel(BaseConfigPanel.this._editPanel);
            }
        };
        this._actionPanel.monitorProgressStart(string, swingWorker, actionListener);
        swingWorker.start();
    }

    protected Window getDialog() {
        Container container = this;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof Dialog) && !(container instanceof JDialog)) continue;
            return (Window)container;
        }
        return null;
    }

    protected void closeDialog() {
        Window window = this.getDialog();
        if (window != null) {
            ((Component)window).setVisible(false);
        }
    }

    public static Border createGroupBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
        Border border = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        return BorderFactory.createCompoundBorder(titledBorder, border);
    }

    public static Font getLabelFont() {
        return _fontLabel;
    }

    public static Font getHeadingLabelFont() {
        return _fontHeadingLabel;
    }

    protected void showPanel(JPanel jPanel) {
        if (jPanel == this._actionPanel) {
            if (!this._actionPanelAdded) {
                this.add((Component)this._actionPanel, "action");
                this._actionPanelAdded = true;
            }
            this._card.show(this, "action");
        } else {
            this._card.show(this, "edit");
        }
    }

    private static Framework getActiveFrame(Component component) {
        Framework framework = null;
        if (component != null) {
            framework = (Framework)SwingUtilities.getAncestorOfClass(class$com$netscape$management$client$Framework == null ? (class$com$netscape$management$client$Framework = BaseConfigPanel.class$("com.netscape.management.client.Framework")) : class$com$netscape$management$client$Framework, component);
        }
        if (framework == null) {
            framework = (Framework)UtilConsoleGlobals.getActivatedFrame();
        }
        return framework;
    }

    public static void setProgressIndicator(Component component, String string, int n, int n2) {
        Framework framework;
        DialogFrame dialogFrame = (DialogFrame)((Object)SwingUtilities.getAncestorOfClass(class$com$netscape$management$admserv$panel$DialogFrame == null ? (class$com$netscape$management$admserv$panel$DialogFrame = BaseConfigPanel.class$("com.netscape.management.admserv.panel.DialogFrame")) : class$com$netscape$management$admserv$panel$DialogFrame, component));
        if (dialogFrame != null) {
            dialogFrame.setBusyCursor(true);
        }
        if ((framework = BaseConfigPanel.getActiveFrame(component)) == null) {
            return;
        }
        Integer n3 = StatusItemProgress.STATE_BUSY;
        if (n > 0) {
            n3 = new Integer(n == n2 ? 100 : (int)((double)n2 * 100.0 / (double)n));
        }
        framework.setBusyCursor(true);
        framework.changeStatusItemState("StatusItemText", (Object)string);
        framework.changeStatusItemState("StatusItemProgress", (Object)n3);
    }

    public static void clearProgressIndicator(Component component) {
        Framework framework;
        DialogFrame dialogFrame = (DialogFrame)((Object)SwingUtilities.getAncestorOfClass(class$com$netscape$management$admserv$panel$DialogFrame == null ? (class$com$netscape$management$admserv$panel$DialogFrame = BaseConfigPanel.class$("com.netscape.management.admserv.panel.DialogFrame")) : class$com$netscape$management$admserv$panel$DialogFrame, component));
        if (dialogFrame != null) {
            dialogFrame.setBusyCursor(false);
        }
        if ((framework = BaseConfigPanel.getActiveFrame(component)) == null) {
            return;
        }
        framework.setBusyCursor(false);
        framework.changeStatusItemState("StatusItemText", (Object)"");
        framework.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

