/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ActionMonitorPanel;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminOperation;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.URLByteEncoder;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CGIDataModel
implements IConfigDataModel {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nProgressLoading = _resource.getString("adminop", "ProgressLoading");
    static String _i18nProgressSaving = _resource.getString("adminop", "ProgressSaving");
    static String _i18nLoadFailed = _resource.getString("adminop", "LoadFailed");
    static String _i18nSaveFailed = _resource.getString("adminop", "SaveFailed");
    protected Hashtable _data;
    protected Hashtable _origData;
    protected ConsoleInfo _consoleInfo;
    protected boolean _loaded;
    protected boolean _saved;
    protected boolean _modified;
    protected String _taskURL;
    protected String _adminURL;
    protected Component _dialogParent;

    public CGIDataModel(ConsoleInfo consoleInfo, String string) {
        this._consoleInfo = consoleInfo;
        this._taskURL = string;
        this._adminURL = this._consoleInfo.getAdminURL() + this._taskURL;
    }

    public static String getServerName(ConsoleInfo consoleInfo) {
        String string = (String)consoleInfo.get("SERVER_NAME");
        if (string == null) {
            Debug.println((String)"CGIDataModel.getServerName: SERVER_NAME not found in console info");
            return "unknown";
        }
        return string;
    }

    public String getModelName() {
        return CGIDataModel.getServerName(this._consoleInfo);
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }

    public Enumeration getAttributes() {
        return this._data.keys();
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void load() throws RemoteRequestException {
        if (ActionMonitorPanel.getActiveInstance() != null) {
            MessageFormat messageFormat = new MessageFormat(_i18nProgressLoading);
            Object[] objectArray = new Object[]{""};
            ActionMonitorPanel.getActiveInstance().setStatusText(messageFormat.format(objectArray));
        }
        this._data = this.getConfiguration(this._adminURL, this.getCGIParamsForGetOp());
        boolean bl = this._loaded = !this._data.isEmpty();
        if (!this._loaded) {
            throw new RemoteRequestException(this._adminURL, _i18nLoadFailed);
        }
        this._origData = CGIDataModel.cloneStringHashtable(this._data, null);
    }

    public boolean isModified() {
        return this._modified;
    }

    public void save() throws RemoteRequestException {
        if (ActionMonitorPanel.getActiveInstance() != null) {
            MessageFormat messageFormat = new MessageFormat(_i18nProgressSaving);
            Object[] objectArray = new Object[]{this.getModelName()};
            ActionMonitorPanel.getActiveInstance().setStatusText(messageFormat.format(objectArray));
        }
        try {
            this.setConfiguration(this._adminURL, this.getCGIParamsForSetOp());
            if (!this._saved) {
                throw new RemoteRequestException(this._adminURL, _i18nSaveFailed);
            }
        }
        catch (RemoteRequestException remoteRequestException) {
            this._data.clear();
            this._data = CGIDataModel.cloneStringHashtable(this._origData, null);
            throw remoteRequestException;
        }
        this._origData.clear();
        this._origData = CGIDataModel.cloneStringHashtable(this._data, null);
        this._modified = false;
    }

    public String getAttribute(String string) {
        return (String)this._data.get(string);
    }

    public void setAttribute(String string, String string2) throws ValidationException {
        String string3 = this.getAttribute(string);
        if (!this._modified) {
            this._modified = string2 == null ? string3 != null : !string2.equals(string3);
        }
        this._data.put(string, string2);
    }

    public String toURLformat(Hashtable hashtable) {
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            string = string + string2 + "=" + URLByteEncoder.encodeUTF8((String)string3) + (enumeration.hasMoreElements() ? "&" : "");
        }
        return string;
    }

    public static Hashtable cloneStringHashtable(Hashtable hashtable, String string) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            if (string == null) {
                hashtable2.put(new String(string2), new String(string3));
                continue;
            }
            hashtable2.put(string + string2, new String(string3));
        }
        return hashtable2;
    }

    public static Vector commaStringToVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public static String vectorToCommaString(Vector vector) {
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement();
            if (!enumeration.hasMoreElements()) continue;
            string = string + ",";
        }
        return string;
    }

    public Component getDialogParent() {
        return this._dialogParent;
    }

    public void setDialogParent(Component component) {
        this._dialogParent = component;
    }

    public abstract String getCGIParamsForGetOp();

    public abstract String getCGIParamsForSetOp();

    protected Hashtable getConfiguration(String string, String string2) throws RemoteRequestException {
        AdmTask admTask = null;
        try {
            admTask = new AdmTask(new URL(string), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((String)("CGIDataModel.getConfiguration " + malformedURLException));
            throw new RemoteRequestException(malformedURLException);
        }
        if (string2 != null) {
            admTask.setArguments(string2);
        }
        admTask.exec();
        int n = admTask.getStatus();
        this._loaded = n == 0;
        Debug.println((String)(string + " " + n));
        AdminOperation.processAdmTaskStatus(string, admTask, this._consoleInfo);
        if (admTask != null) {
            return admTask.getResult();
        }
        return new Hashtable();
    }

    protected void setConfiguration(String string, String string2) throws RemoteRequestException {
        AdmTask admTask = null;
        try {
            admTask = new AdmTask(new URL(string), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((String)("CGIDataModel.setConfiguration " + malformedURLException));
            throw new RemoteRequestException(malformedURLException);
        }
        if (string2 != null) {
            admTask.setArguments(string2);
        }
        admTask.exec();
        int n = admTask.getStatus();
        Debug.println((String)(string + " " + n));
        this._saved = n == 0;
        AdminOperation.processAdmTaskStatus(string, admTask, this._consoleInfo);
    }
}

