/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.IWizardControl;
import com.netscape.management.client.util.IWizardPageControl;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class Wizard
extends AbstractDialog {
    private IWizardPageControl wizPages;
    private boolean onLastPage = false;
    private JPanel currentPage = null;
    private JPanel currentPanel = new JPanel();
    private JButton bNext;
    private JButton bBack;
    private JButton bCancel;
    private JButton bHelp;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");
    private IWizardControl wizardControl = new WizardControlListener();

    public Wizard(JFrame jFrame, String string, IWizardPageControl iWizardPageControl) {
        super((Frame)jFrame, string, true);
        iWizardPageControl.setOwner(this.wizardControl);
        this.wizPages = iWizardPageControl;
        this.currentPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.currentPanel);
        jPanel.add("South", this.getControlButtons());
        this.wizardControl.setCanGoBackword(false);
        this.setSize(400, 400);
        this.getContentPane().add(jPanel);
    }

    private JPanel getControlButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 0, 0));
        jPanel.setBorder(new EmptyBorder(9, 0, 0, 0));
        WizardActionListener wizardActionListener = new WizardActionListener();
        this.bBack = JButtonFactory.create(_resource.getString(null, "BackButtonLabel"));
        this.bBack.setToolTipText(_resource.getString(null, "BackButton_tt"));
        this.bBack.addActionListener(wizardActionListener);
        this.bBack.setActionCommand("BACK");
        jPanel.add(this.bBack);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.bNext = JButtonFactory.create(_resource.getString(null, "NextButtonLabel"));
        this.bNext.setToolTipText(_resource.getString(null, "NextButton_tt"));
        this.bNext.addActionListener(wizardActionListener);
        this.bNext.setActionCommand("NEXT_DONE");
        jPanel.add(this.bNext);
        jPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        this.bCancel = JButtonFactory.createCancelButton(wizardActionListener);
        jPanel.add(this.bCancel);
        jPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        this.bHelp = JButtonFactory.createHelpButton(wizardActionListener);
        jPanel.add(this.bHelp);
        JButtonFactory.resizeGroup(this.bHelp, this.bCancel, this.bNext, this.bBack);
        return jPanel;
    }

    public void start() {
        this.currentPanel.add(this.wizPages.getCurrentPage());
        super.setVisible(true);
    }

    class WizardActionListener
    implements ActionListener {
        WizardActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("NEXT_DONE")) {
                Wizard.this.wizardControl.nextInvoked();
            } else if (actionEvent.getActionCommand().equals("BACK")) {
                Wizard.this.wizardControl.backInvoked();
            } else if (actionEvent.getActionCommand().equals("CANCEL")) {
                Wizard.this.wizardControl.cancelInvoked();
            } else if (actionEvent.getActionCommand().equals("HELP")) {
                Wizard.this.wizPages.helpInvoked();
            }
        }
    }

    class WizardControlListener
    implements IWizardControl {
        WizardControlListener() {
        }

        public void setCanGoForward(boolean bl) {
            try {
                Wizard.this.bNext.setEnabled(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setCanGoBackword(boolean bl) {
            try {
                Wizard.this.bBack.setEnabled(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setIsLastPage(boolean bl) {
            try {
                if (bl) {
                    Wizard.this.bNext.setText(_resource.getString(null, "DoneButtonLabel"));
                    Wizard.this.onLastPage = bl;
                } else {
                    Wizard.this.bNext.setText(_resource.getString(null, "NextButtonLabel"));
                    Wizard.this.onLastPage = bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void nextInvoked() {
            if (Wizard.this.onLastPage) {
                Wizard.this.wizPages.wizardCompleted();
                Wizard.this.dispose();
            } else {
                Wizard.this.currentPanel.remove(Wizard.this.wizPages.getCurrentPage());
                Wizard.this.currentPanel.add(Wizard.this.wizPages.getNextPage());
                Wizard.this.currentPanel.validate();
                Wizard.this.currentPanel.repaint();
                Wizard.this.wizPages.getCurrentPage().repaint();
            }
        }

        public void backInvoked() {
            Wizard.this.currentPanel.remove(Wizard.this.wizPages.getCurrentPage());
            Wizard.this.currentPanel.add(Wizard.this.wizPages.getPrevPage());
            Wizard.this.currentPanel.validate();
            Wizard.this.currentPanel.repaint();
            Wizard.this.wizPages.getCurrentPage().repaint();
        }

        public void cancelInvoked() {
            Wizard.this.wizPages.wizardCanceled();
            Wizard.this.dispose();
        }
    }
}

