/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.ug.AttributeValuePair;
import com.netscape.management.client.ug.Renamer;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ShowRenameWarningDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.KingpinLDAPConnection;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class ResourcePageObservable
extends Observable {
    static final String ID_FORMAT_MAIL = "mail";
    static final String ID_FORMAT_NTUSER = "ntuser";
    static final String ID_FORMAT_FIRSTLETTER_LASTNAME = "firstletter_lastname";
    static final String ID_FORMAT_GIVENNAME_FIRSTLETTER = "givenname_firstletter";
    static final String ID_FORMAT_LASTNAME_GIVENNAME = "lastname_givenname";
    static final String ID_FORMAT_GIVENNAME_LASTNAME = "givenname_lastname";
    static final String STRING_UID = "uid";
    static final String STRING_SN = "sn";
    static final String STRING_GIVENNAME = "givenname";
    private ResourceSet _resource;
    public LDAPEntry _entry;
    private ConsoleInfo _info;
    private Hashtable attributes = new Hashtable();
    private Vector attrAdd = new Vector();
    private Vector attrReplace = new Vector();
    private Vector attrDelete = new Vector();
    private Vector attrDeleteValues = new Vector();
    private Vector _objectClassList;
    public boolean _fNewUser;
    public String _sIndexAttribute = "cn";
    public String _sBaseDN;

    public ResourcePageObservable(ConsoleInfo consoleInfo, LDAPEntry lDAPEntry, boolean bl) {
        this._resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
        this._info = consoleInfo;
        this._entry = lDAPEntry;
        this._fNewUser = bl;
        if (this._fNewUser || lDAPEntry == null) {
            return;
        }
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        String string = null;
        int n = 0;
        while (n < lDAPAttributeSet.size()) {
            string = lDAPAttributeSet.elementAt(n).getName().toLowerCase();
            this.attributes.put(string, lDAPAttributeSet.elementAt(n));
            ++n;
        }
        String string2 = this._entry.getDN();
        int n2 = string2.indexOf(61);
        if (n2 > 0) {
            this._sIndexAttribute = string2.substring(0, n2);
        }
    }

    public void setObjectClass(Vector vector) {
        this._objectClassList = vector;
        this.add("objectclass", this._objectClassList);
    }

    public LDAPEntry getLDAPEntry(String string) {
        LDAPEntry lDAPEntry = null;
        try {
            LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
            if (lDAPConnection == null || !lDAPConnection.isConnected()) {
                lDAPConnection = new KingpinLDAPConnection(this._info.getAuthenticationDN(), this._info.getAuthenticationPassword());
                lDAPConnection.connect(3, this._info.getUserHost(), this._info.getUserPort(), this._info.getAuthenticationDN(), this._info.getAuthenticationPassword());
                lDAPEntry = lDAPConnection.read(string);
                lDAPConnection.disconnect();
            } else {
                lDAPEntry = lDAPConnection.read(string);
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return lDAPEntry;
    }

    public void setIndexAttribute(String string) {
        this._sIndexAttribute = string;
    }

    public String getIndexAttribute() {
        return this._sIndexAttribute;
    }

    public ConsoleInfo getConsoleInfo() {
        return this._info;
    }

    public String getDN() {
        if (this._entry != null) {
            return this._entry.getDN();
        }
        return null;
    }

    public String getCreateBaseDN() {
        return this._sBaseDN;
    }

    public void setCreateBaseDN(String string) {
        this._sBaseDN = string;
    }

    public LDAPEntry save() throws LDAPException {
        if (this._fNewUser) {
            String string = this.getCreateBaseDN();
            if (string == null) {
                Debug.println("ResourcePageObservable: cannot save because base DN is null");
            }
            LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String string2 = "";
            try {
                String string3;
                Object object;
                int n = 0;
                int n2 = 0;
                while (n2 < this._objectClassList.size()) {
                    object = (String)this._objectClassList.elementAt(n2);
                    if (((String)object).toLowerCase().equals("inetorgperson")) {
                        n = 1;
                    } else if (((String)object).toLowerCase().equals("groupofuniquenames")) {
                        n = 2;
                    }
                    ++n2;
                }
                switch (n) {
                    case 1: {
                        String string4;
                        object = ResourceEditor.getUserRDNComponent();
                        if (object != null && !((String)object).equals("")) {
                            this._sIndexAttribute = object;
                        }
                        if (((string3 = this.get(STRING_UID, 0)) == null || string3.equals("")) && (object = ResourceEditor.getUniqueAttribute()) != null && !((String)object).equals("")) {
                            string4 = "";
                            if (((String)object).toLowerCase().equals(STRING_UID)) {
                                object = ResourceEditor.getUserIDFormat();
                                if (((String)object).toLowerCase().equals(ID_FORMAT_NTUSER)) {
                                    string4 = this.get("ntUserDomainID", 0);
                                    int n3 = string4.indexOf(58);
                                    if (n3 > 0) {
                                        string4 = string4.substring(n3 + 1);
                                    }
                                } else {
                                    string4 = ((String)object).toLowerCase().equalsIgnoreCase(ID_FORMAT_MAIL) ? this.get(ID_FORMAT_MAIL, 0) : (((String)object).toLowerCase().equalsIgnoreCase(ID_FORMAT_FIRSTLETTER_LASTNAME) ? this.get(STRING_GIVENNAME, 0).substring(0, 1) + this.get(STRING_SN, 0) : (((String)object).toLowerCase().equalsIgnoreCase(ID_FORMAT_GIVENNAME_FIRSTLETTER) ? this.get(STRING_GIVENNAME, 0) + this.get(STRING_SN, 0).substring(0, 1) : (((String)object).toLowerCase().equalsIgnoreCase(ID_FORMAT_LASTNAME_GIVENNAME) ? this.get(STRING_SN, 0) + this.get(STRING_GIVENNAME, 0) : this.get(STRING_GIVENNAME, 0) + this.get(STRING_SN, 0))));
                                }
                            } else {
                                string4 = this.get((String)object, 0);
                            }
                            if (string4 == null) {
                                string4 = "";
                            }
                            this.replace(STRING_UID, string4);
                        }
                        if (LDAPUtil.isVersion4(this._info.getUserLDAPConnection()) || !this.uidAlreadyExists(string4 = this.get(STRING_UID, 0))) break;
                        throw new LDAPException(this._resource.getString("ResourcePageObservable", "uidAlreadyExists") + " " + string4, 68);
                    }
                    case 2: {
                        object = ResourceEditor.getGroupRDNComponent();
                        if (object == null || ((String)object).equals("")) break;
                        this._sIndexAttribute = object;
                    }
                }
                string2 = string != null && string.equals("") ? this._sIndexAttribute + "=" + this.getRdnValue(this.get(this._sIndexAttribute, 0)) : this._sIndexAttribute + "=" + this.getRdnValue(this.get(this._sIndexAttribute, 0)) + "," + string;
                object = this.attributes.keys();
                while (object.hasMoreElements()) {
                    string3 = (String)object.nextElement();
                    lDAPAttributeSet.add((LDAPAttribute)this.attributes.get(string3));
                }
                string3 = new LDAPEntry(string2, lDAPAttributeSet);
                lDAPConnection.add((LDAPEntry)string3);
                this._entry = string3;
            }
            catch (LDAPException lDAPException) {
                Debug.println(0, "ResourcePageObservable.java:ADD LDAP ENTRY:" + lDAPException.getLDAPErrorMessage() + " for " + string2);
                throw lDAPException;
            }
        }
        if (this.attrAdd.size() + this.attrReplace.size() + this.attrDelete.size() + this.attrDeleteValues.size() > 0) {
            String string;
            String string5;
            Object object;
            Object object2;
            Object object3;
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            int n = 0;
            while (n < this.attrDelete.size()) {
                AttributeValuePair attributeValuePair = (AttributeValuePair)this.attrDelete.elementAt(n);
                object3 = new LDAPAttribute(attributeValuePair.getLDAPAttribute().getName());
                Debug.println("ResourcePageObservable.save: mod.del=" + object3);
                if (object3 != null && !this._sIndexAttribute.equals(object3.getName())) {
                    lDAPModificationSet.add(1, (LDAPAttribute)object3);
                }
                ++n;
            }
            int n4 = 0;
            while (n4 < this.attrDeleteValues.size()) {
                object3 = (AttributeValuePair)this.attrDeleteValues.elementAt(n4);
                object2 = ((AttributeValuePair)object3).getLDAPAttribute();
                if (object2 != null && !this._sIndexAttribute.equals(object2.getName())) {
                    lDAPModificationSet.add(1, (LDAPAttribute)object2);
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.attrAdd.size()) {
                object2 = (AttributeValuePair)this.attrAdd.elementAt(n5);
                Debug.println("ResourcePageObservable.save: mod.add=" + ((AttributeValuePair)object2).getLDAPAttribute());
                lDAPModificationSet.add(0, ((AttributeValuePair)object2).getLDAPAttribute());
                ++n5;
            }
            int n6 = 0;
            while (n6 < this.attrReplace.size()) {
                object = (String)this.attrReplace.elementAt(n6);
                object = ((String)object).toLowerCase();
                string5 = null;
                if (this._entry.getAttribute((String)object) == null) {
                    string = (LDAPAttribute)this.attributes.get(object);
                    if (string != null) {
                        Debug.println("ResourcePageObservable.save: mod.add=" + string);
                        lDAPModificationSet.add(0, (LDAPAttribute)string);
                    }
                } else {
                    string = (LDAPAttribute)this.attributes.get(object);
                    if (string != null) {
                        Debug.println("ResourcePageObservable.save: mod.rep=" + string);
                        lDAPModificationSet.add(2, (LDAPAttribute)string);
                    }
                }
                ++n6;
            }
            object = this._info.getUserLDAPConnection();
            try {
                boolean bl;
                string5 = this._entry.getDN();
                string = this.getRdnValue(this.get(this._sIndexAttribute, 0));
                boolean bl2 = bl = string != null && !string.trim().equals("");
                if (!bl) {
                    this._sIndexAttribute = "cn";
                }
                boolean bl3 = true;
                boolean bl4 = false;
                String[] stringArray = LDAPDN.explodeDN((String)string5, (boolean)false);
                String string6 = "";
                if (stringArray.length > 1) {
                    LDAPAttribute lDAPAttribute;
                    LDAPAttribute lDAPAttribute2;
                    String string7;
                    String string8;
                    Object object4;
                    String string9 = stringArray[0];
                    StringBuffer stringBuffer = new StringBuffer();
                    int n7 = 1;
                    while (n7 < stringArray.length) {
                        stringBuffer.append(",");
                        stringBuffer.append(stringArray[n7]);
                        ++n7;
                    }
                    boolean bl5 = true;
                    String string10 = null;
                    Vector vector = this.get(this._sIndexAttribute);
                    ListIterator listIterator = vector.listIterator();
                    while (listIterator.hasNext() && bl5) {
                        object4 = (String)listIterator.next();
                        object4 = this.getRdnValue((String)object4);
                        string8 = this._sIndexAttribute + "=" + (String)object4;
                        if (!new RDN(string8).equals(new RDN(string9))) continue;
                        bl5 = false;
                    }
                    if (bl5) {
                        string10 = this._sIndexAttribute + "=" + this.getRdnValue(this.get(this._sIndexAttribute, 0));
                        object4 = new DN(string10 + stringBuffer.toString());
                        bl5 = !object4.equals((DN)(string8 = new DN(string5)));
                    } else {
                        string10 = string9;
                    }
                    if (bl5) {
                        bl4 = !this.getConfirmationRename(this._entry);
                    }
                    Debug.println(6, "ResourcePageObservable.save: RDN=" + string9);
                    Debug.println(6, "ResourcePageObservable.save: newRDN=" + string10);
                    if (string5.length() > 0 && bl5 && !bl4) {
                        boolean bl6;
                        Debug.println("ResourcePageObservable.save: rename " + string5 + " --> new rdn=" + string10);
                        object4 = new Renamer((LDAPConnection)object, string5, string10, true, UtilConsoleGlobals.getActivatedFrame());
                        ((Renamer)object4).execute();
                        boolean bl7 = bl6 = ((Renamer)object4).getLDAPException() == null;
                        if (!bl6) {
                            throw ((Renamer)object4).getLDAPException();
                        }
                        boolean bl8 = false;
                        int n8 = lDAPModificationSet.size();
                        int n9 = 0;
                        while (n9 < n8 && !bl8) {
                            LDAPModification lDAPModification = lDAPModificationSet.elementAt(n9);
                            if (lDAPModification.getOp() == 0 && lDAPModification.getAttribute().getName().equalsIgnoreCase(this._sIndexAttribute)) {
                                bl8 = true;
                                lDAPModificationSet.removeElementAt(n9);
                                lDAPModificationSet.add(2, lDAPModification.getAttribute());
                            }
                            ++n9;
                        }
                    }
                    string6 = !bl4 ? string10 + stringBuffer.toString() : this._entry.getDN();
                    if (lDAPModificationSet.size() == 1 && bl5 && !bl4 && (string7 = (object4 = new RDN(stringArray[0])).getTypes()[0]).equalsIgnoreCase(this._sIndexAttribute) && (lDAPAttribute2 = lDAPModificationSet.elementAt(0).getAttribute()).getName().equalsIgnoreCase(this._sIndexAttribute) && (lDAPAttribute = this._entry.getAttribute(string7)).getStringValueArray().length == 1 && lDAPAttribute2.getStringValueArray().length == 1) {
                        bl3 = false;
                    }
                } else {
                    string6 = this._entry.getDN();
                }
                if (bl3 && !bl4) {
                    object.modify(string6, lDAPModificationSet);
                }
                this._entry = object.read(string6);
                this.refresh();
            }
            catch (LDAPException lDAPException) {
                Debug.println(0, "ResourcePageObservable.java:MODIFY LDAP ENTRY:" + (Object)((Object)lDAPException));
                throw lDAPException;
            }
        }
        return this._entry;
    }

    public void refresh() {
        this.attrAdd.removeAllElements();
        this.attrReplace.removeAllElements();
        this.attrDelete.removeAllElements();
        this.attrDeleteValues.removeAllElements();
        this.attributes.clear();
        if (!this._fNewUser) {
            this._entry = this.getLDAPEntry(this._entry.getDN());
            LDAPAttributeSet lDAPAttributeSet = this._entry.getAttributeSet();
            String string = null;
            int n = 0;
            while (n < lDAPAttributeSet.size()) {
                string = lDAPAttributeSet.elementAt(n).getName().toLowerCase();
                this.attributes.put(string, lDAPAttributeSet.elementAt(n));
                ++n;
            }
        }
    }

    private boolean isDirectoryVersion40() {
        try {
            LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
            LDAPEntry lDAPEntry = lDAPConnection.read("");
            String string = LDAPUtil.flatting(lDAPEntry.getAttribute("netscapemdsuffix"));
            if (string != null && !string.equals("")) {
                return true;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "ERROR ResourcePageObservable.isDirectoryVersion40: failed to determine server version: " + (Object)((Object)lDAPException));
        }
        return false;
    }

    private boolean uidAlreadyExists(String string) {
        try {
            String string2 = "(&(objectclass=person)(uid=" + string + "))";
            LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this._info.getUserBaseDN(), 2, string2, null, false);
            if (lDAPSearchResults.hasMoreElements() && lDAPSearchResults.nextElement() instanceof LDAPEntry) {
                return true;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "ERROR ResourcePageObservable.uidAlreadyExists: search failed for " + string + ": " + (Object)((Object)lDAPException));
        }
        return false;
    }

    void addAttributeEntry(String string, Object object) {
        String string2 = string.toLowerCase();
        AttributeValuePair attributeValuePair = new AttributeValuePair(string2, object);
        this.attributes.put(string2, attributeValuePair.getLDAPAttribute());
        this.attrAdd.addElement(attributeValuePair);
    }

    public void replaceAttr(String string) {
        AttributeValuePair attributeValuePair;
        String string2 = string.toLowerCase();
        Enumeration enumeration = this.attrAdd.elements();
        while (enumeration.hasMoreElements()) {
            attributeValuePair = (AttributeValuePair)enumeration.nextElement();
            if (!attributeValuePair.getAttribute().equals(string2)) continue;
            this.attrAdd.removeElement(attributeValuePair);
        }
        enumeration = this.attrDelete.elements();
        while (enumeration.hasMoreElements()) {
            attributeValuePair = (AttributeValuePair)enumeration.nextElement();
            if (!attributeValuePair.getAttribute().equals(string2)) continue;
            this.attrDelete.removeElement(attributeValuePair);
        }
        if (!this.attrReplace.contains(string2)) {
            this.attrReplace.addElement(string2);
        }
    }

    public Enumeration getAttributesList() {
        return this.attributes.keys();
    }

    public void add(String string, byte[] byArray) {
        String string2 = string.toLowerCase();
        if (this.attributes.containsKey(string2)) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
            lDAPAttribute.addValue(byArray);
            this.attributes.put(string2, lDAPAttribute);
            this.attrAdd.addElement(new AttributeValuePair(string2, lDAPAttribute));
        } else {
            this.addAttributeEntry(string2, byArray);
        }
        this.setChanged();
        this.notifyObservers(string2);
    }

    public void add(String string, String string2) {
        String string3 = string.toLowerCase();
        if (this.attributes.containsKey(string3)) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string3);
            lDAPAttribute.addValue(string2);
            this.attributes.put(string3, lDAPAttribute);
            this.attrAdd.addElement(new AttributeValuePair(string3, lDAPAttribute));
        } else {
            this.addAttributeEntry(string3, string2);
        }
        this.setChanged();
        this.notifyObservers(string3);
    }

    public void add(String string, Vector vector) {
        String string2 = string.toLowerCase();
        if (this.attributes.containsKey(string2)) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof String) {
                    lDAPAttribute.addValue((String)e);
                    continue;
                }
                lDAPAttribute.addValue((byte[])e);
            }
            this.attributes.put(string2, lDAPAttribute);
            this.attrAdd.addElement(new AttributeValuePair(string2, lDAPAttribute));
        } else {
            this.addAttributeEntry(string2, vector);
        }
        this.setChanged();
        this.notifyObservers(string2);
    }

    public void delete(String string, String string2) {
        this.universalDelete(string, string2);
    }

    public void delete(String string, byte[] byArray) {
        this.universalDelete(string, byArray);
    }

    public void delete(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.universalDelete(string, enumeration.nextElement());
        }
    }

    private void universalDelete(String string, Object object) {
        String string2 = string.toLowerCase();
        try {
            if (this.attributes.containsKey(string2)) {
                LDAPAttribute lDAPAttribute = null;
                if (object == null || object instanceof String && ((String)object).equals("") || object instanceof byte[] && ((byte[])object).length == 0) {
                    lDAPAttribute = new LDAPAttribute(string2);
                } else {
                    lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
                    if (object instanceof String) {
                        lDAPAttribute.removeValue((String)object);
                    } else {
                        lDAPAttribute.removeValue((byte[])object);
                    }
                }
                this.attributes.put(string2, lDAPAttribute);
                Enumeration enumeration = this.attrAdd.elements();
                boolean bl = true;
                while (enumeration.hasMoreElements()) {
                    AttributeValuePair attributeValuePair = (AttributeValuePair)enumeration.nextElement();
                    if (!attributeValuePair.getAttribute().equals(string2)) continue;
                    bl = false;
                    this.attrAdd.removeElement(attributeValuePair);
                }
                if (this.attrReplace.contains(string2)) {
                    this.attrReplace.removeElement(string2);
                }
                if (bl) {
                    this.attrDelete.addElement(new AttributeValuePair(string2, lDAPAttribute));
                }
                this.attributes.remove(string2);
            }
        }
        catch (Exception exception) {
            Debug.println(0, "ResourcePageObservable:" + exception);
        }
        this.setChanged();
        this.notifyObservers(string2);
    }

    public void delete(String string) {
        String string2 = string.toLowerCase();
        if (this.attributes.containsKey(string2)) {
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string2);
            this.attributes.put(string2, lDAPAttribute);
            Enumeration enumeration = this.attrAdd.elements();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                AttributeValuePair attributeValuePair = (AttributeValuePair)enumeration.nextElement();
                if (!attributeValuePair.getAttribute().equals(string2)) continue;
                bl = false;
                this.attrAdd.removeElement(attributeValuePair);
            }
            if (this.attrReplace.contains(string2)) {
                this.attrReplace.removeElement(string2);
            }
            if (bl) {
                this.attrDelete.addElement(new AttributeValuePair(string2, lDAPAttribute));
            }
            this.attributes.remove(string2);
        }
        this.setChanged();
        this.notifyObservers(string2);
    }

    public void replace(String string, String string2) {
        String string3 = string.toLowerCase();
        if (this.attributes.containsKey(string3)) {
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string3, string2);
            if (!this.attributes.get(string3).toString().equals(lDAPAttribute.toString())) {
                this.attributes.put(string3.toLowerCase(), lDAPAttribute);
                this.replaceAttr(string3);
            }
        } else {
            this.addAttributeEntry(string3, string2);
        }
        this.setChanged();
        this.notifyObservers(string3);
    }

    public void replace(String string, Vector vector) {
        String string2 = string.toLowerCase();
        if (this.attributes.containsKey(string2)) {
            Enumeration enumeration = vector.elements();
            boolean bl = true;
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string2);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof String) {
                    lDAPAttribute.addValue((String)e);
                    continue;
                }
                lDAPAttribute.addValue((byte[])e);
            }
            if (!this.areAttributeValuesEqual((LDAPAttribute)this.attributes.get(string2), lDAPAttribute)) {
                this.attributes.put(string2.toLowerCase(), lDAPAttribute);
                this.replaceAttr(string2);
            }
        } else {
            this.addAttributeEntry(string2, vector);
        }
        this.setChanged();
        this.notifyObservers(string2);
    }

    public void replace(String string, byte[] byArray) {
        String string2 = string.toLowerCase();
        if (this.attributes.containsKey(string2)) {
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string2, byArray);
            if (!this.attributes.get(string2).toString().equals(lDAPAttribute.toString())) {
                this.attributes.put(string2.toLowerCase(), lDAPAttribute);
                this.replaceAttr(string2);
            }
        } else {
            this.addAttributeEntry(string2, byArray);
        }
        this.setChanged();
        this.notifyObservers(string2);
    }

    public Vector get(String string) {
        String string2 = string.toLowerCase();
        Vector vector = new Vector();
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public byte[] getBytes(String string) {
        Enumeration enumeration;
        String string2 = string.toLowerCase();
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
        byte[] byArray = null;
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getByteValues()) != null && enumeration.hasMoreElements()) {
            byArray = (byte[])enumeration.nextElement();
        }
        return byArray;
    }

    public Enumeration getBytesVector(String string) {
        String string2 = string.toLowerCase();
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
        Enumeration enumeration = null;
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getByteValues();
        }
        return enumeration;
    }

    public String getValues(String string) {
        Enumeration enumeration;
        String string2 = string.toLowerCase();
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
        StringBuffer stringBuffer = new StringBuffer("");
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null) {
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public String[] getValueArray(String string) {
        String string2 = string.toLowerCase();
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
        String[] stringArray = null;
        if (lDAPAttribute != null) {
            stringArray = this.convertEnumToArray(lDAPAttribute.getStringValues());
        }
        return stringArray;
    }

    public String[] convertEnumToArray(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        Enumeration enumeration2 = vector.elements();
        int n2 = 0;
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String get(String string, int n) {
        String string2 = string.toLowerCase();
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attributes.get(string2);
        String string3 = "";
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (n2 != n) continue;
                string3 = string4;
                break;
            }
        }
        return string3 == null ? "" : string3;
    }

    public boolean isNewUser() {
        return this._fNewUser;
    }

    public String[] getLanguages() {
        if (this._entry != null) {
            return LDAPUtil.getAttributeLanguages(this._entry);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ResourcePageObservable:");
        stringBuffer.append("\n\tnewUser=");
        stringBuffer.append(this._fNewUser);
        stringBuffer.append("\n\tsBaseDN=");
        stringBuffer.append(this._sBaseDN);
        stringBuffer.append("\n\tobjectClassList=");
        int n = 0;
        while (this._objectClassList != null && n < this._objectClassList.size()) {
            stringBuffer.append(this._objectClassList.elementAt(n));
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append("\n\tattributes=");
        stringBuffer.append(this.attributes.toString());
        stringBuffer.append("\n\tattrAdd=");
        int n2 = 0;
        while (this.attrAdd != null && n2 < this.attrAdd.size()) {
            stringBuffer.append(this.attrAdd.elementAt(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer.append("\n\tattrReplace=");
        int n3 = 0;
        while (this.attrReplace != null && n3 < this.attrReplace.size()) {
            stringBuffer.append(this.attrReplace.elementAt(n3));
            stringBuffer.append(" ");
            ++n3;
        }
        stringBuffer.append("\n\tattrDelete=");
        int n4 = 0;
        while (this.attrDelete != null && n4 < this.attrDelete.size()) {
            stringBuffer.append(this.attrDelete.elementAt(n4));
            stringBuffer.append(" ");
            ++n4;
        }
        stringBuffer.append("\n\tattrDeleteValues=");
        int n5 = 0;
        while (this.attrDeleteValues != null && n5 < this.attrDeleteValues.size()) {
            stringBuffer.append(this.attrDeleteValues.elementAt(n5));
            stringBuffer.append(" ");
            ++n5;
        }
        stringBuffer.append("\n\tentry=");
        stringBuffer.append(this._entry);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getRdnValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            boolean bl = false;
            int n2 = 0;
            while (n2 < DN.ESCAPED_CHAR.length && !bl) {
                bl = c == DN.ESCAPED_CHAR[n2];
                ++n2;
            }
            if (bl) {
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (n == 0) {
                if (c == ' ') {
                    stringBuffer.deleteCharAt(n);
                    stringBuffer.insert(n, "\\20");
                    n += 2;
                } else if (c == '#') {
                    stringBuffer.insert(n, '\\');
                    ++n;
                }
            } else if (n == stringBuffer.length() - 1 && c == ' ') {
                stringBuffer.deleteCharAt(n);
                stringBuffer.insert(n, "\\20");
                n += 2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean areAttributeValuesEqual(LDAPAttribute lDAPAttribute, LDAPAttribute lDAPAttribute2) {
        String[] stringArray;
        boolean bl = true;
        String[] stringArray2 = lDAPAttribute.getStringValueArray();
        boolean bl2 = bl = stringArray2.length == (stringArray = lDAPAttribute2.getStringValueArray()).length;
        if (bl) {
            int n = 0;
            while (n < stringArray2.length && bl) {
                bl = stringArray2[n].equals(stringArray[n]);
                ++n;
            }
        }
        if (bl) {
            byte[][] byArray;
            byte[][] byArray2 = lDAPAttribute.getByteValueArray();
            boolean bl3 = bl = byArray2.length == (byArray = lDAPAttribute2.getByteValueArray()).length;
            if (bl) {
                int n = 0;
                while (n < byArray2.length && bl) {
                    boolean bl4 = bl = byArray2[n].length == byArray[n].length;
                    if (bl) {
                        int n2 = 0;
                        while (n2 < byArray2[n].length && bl) {
                            bl = byArray2[n][n2] == byArray[n][n2];
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    void addValues(String string, Vector vector, Vector vector2) {
        AttributeValuePair attributeValuePair;
        Object e;
        String string2 = string.toLowerCase();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string);
        LDAPAttribute lDAPAttribute2 = new LDAPAttribute(string);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (e instanceof String) {
                lDAPAttribute.addValue((String)e);
                continue;
            }
            lDAPAttribute.addValue((byte[])e);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (e instanceof String) {
                lDAPAttribute.addValue((String)e);
                lDAPAttribute2.addValue((String)e);
                continue;
            }
            lDAPAttribute.addValue((byte[])e);
            lDAPAttribute2.addValue((byte[])e);
        }
        boolean bl = false;
        int n = 0;
        while (n < this.attrDeleteValues.size() && !bl) {
            attributeValuePair = (AttributeValuePair)this.attrDeleteValues.elementAt(n);
            bl = attributeValuePair.getAttribute().equalsIgnoreCase(string2);
            if (bl) {
                String[] stringArray = attributeValuePair.getLDAPAttribute().getStringValueArray();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    lDAPAttribute.removeValue(stringArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        this.attributes.put(string2, lDAPAttribute);
        attributeValuePair = new AttributeValuePair(string2, lDAPAttribute2);
        bl = false;
        int n3 = 0;
        while (n3 < this.attrAdd.size() && !bl) {
            AttributeValuePair attributeValuePair2 = (AttributeValuePair)this.attrAdd.elementAt(n3);
            bl = attributeValuePair2.getAttribute().equalsIgnoreCase(string2);
            if (bl) {
                if (vector.size() > 0) {
                    this.attrAdd.set(n3, attributeValuePair);
                } else {
                    this.attrAdd.remove(n3);
                }
            }
            ++n3;
        }
        if (!bl && vector.size() > 0) {
            this.attrAdd.addElement(attributeValuePair);
        }
    }

    void deleteValues(String string, Vector vector, Vector vector2) {
        AttributeValuePair attributeValuePair;
        Object e;
        String string2 = string.toLowerCase();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string);
        LDAPAttribute lDAPAttribute2 = new LDAPAttribute(string);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (vector.contains(e)) continue;
            if (e instanceof String) {
                lDAPAttribute.addValue((String)e);
                continue;
            }
            lDAPAttribute.addValue((byte[])e);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (e instanceof String) {
                lDAPAttribute2.addValue((String)e);
                continue;
            }
            lDAPAttribute2.addValue((byte[])e);
        }
        boolean bl = false;
        int n = 0;
        while (n < this.attrAdd.size() && !bl) {
            attributeValuePair = (AttributeValuePair)this.attrAdd.elementAt(n);
            bl = attributeValuePair.getAttribute().equalsIgnoreCase(string2);
            if (bl) {
                String[] stringArray = attributeValuePair.getLDAPAttribute().getStringValueArray();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    lDAPAttribute.addValue(stringArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        this.attributes.put(string2, lDAPAttribute);
        attributeValuePair = new AttributeValuePair(string2, lDAPAttribute2);
        bl = false;
        int n3 = 0;
        while (n3 < this.attrDeleteValues.size() && !bl) {
            AttributeValuePair attributeValuePair2 = (AttributeValuePair)this.attrDeleteValues.elementAt(n3);
            bl = attributeValuePair2.getAttribute().equalsIgnoreCase(string2);
            if (bl) {
                if (vector.size() > 0) {
                    this.attrDeleteValues.set(n3, attributeValuePair);
                } else {
                    this.attrDeleteValues.remove(n3);
                }
            }
            ++n3;
        }
        if (!bl && vector.size() > 0) {
            this.attrDeleteValues.addElement(attributeValuePair);
        }
    }

    private boolean getConfirmationRename(LDAPEntry lDAPEntry) {
        Preferences preferences = PreferenceManager.getPreferenceManager("Console", "4.0").getPreferences("DS_MISCELLANEOUS");
        boolean bl = preferences.getBoolean("SHOW_RENAME_WARNING_DIALOG", true);
        boolean bl2 = true;
        if (bl) {
            int n;
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("numsubordinates");
            if (lDAPAttribute == null) {
                n = 0;
            } else {
                try {
                    n = Integer.parseInt(lDAPAttribute.getStringValueArray()[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
            }
            if (n > 0) {
                ShowRenameWarningDialog showRenameWarningDialog = new ShowRenameWarningDialog(UtilConsoleGlobals.getActivatedFrame());
                showRenameWarningDialog.packAndShow();
                bl = showRenameWarningDialog.continueShowingDialog();
                if (!bl) {
                    preferences.set("SHOW_RENAME_WARNING_DIALOG", bl);
                }
                bl2 = !showRenameWarningDialog.isCancelled();
            }
        }
        return bl2;
    }
}

